/*
 * Decompiled with CFR 0.152.
 */
package com.brsanthu.googleanalytics;

import com.brsanthu.googleanalytics.DefaultRequest;
import com.brsanthu.googleanalytics.GoogleAnalyticsConfig;
import com.brsanthu.googleanalytics.GoogleAnalyticsParameter;
import com.brsanthu.googleanalytics.GoogleAnalyticsRequest;
import com.brsanthu.googleanalytics.GoogleAnalyticsResponse;
import com.brsanthu.googleanalytics.GoogleAnalyticsStats;
import com.brsanthu.googleanalytics.GoogleAnalyticsThreadFactory;
import com.brsanthu.googleanalytics.RequestProvider;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleAnalytics {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Logger logger = LoggerFactory.getLogger(GoogleAnalytics.class);
    private GoogleAnalyticsConfig config = null;
    private DefaultRequest defaultRequest = null;
    private CloseableHttpClient httpClient = null;
    private ThreadPoolExecutor executor = null;
    private GoogleAnalyticsStats stats = new GoogleAnalyticsStats();

    public GoogleAnalytics(String trackingId) {
        this(new GoogleAnalyticsConfig(), (DefaultRequest)new DefaultRequest().trackingId(trackingId));
    }

    public GoogleAnalytics(GoogleAnalyticsConfig config, String trackingId) {
        this(config, (DefaultRequest)new DefaultRequest().trackingId(trackingId));
    }

    public GoogleAnalytics(String trackingId, String appName, String appVersion) {
        this(new GoogleAnalyticsConfig(), trackingId, appName, appVersion);
    }

    public GoogleAnalytics(GoogleAnalyticsConfig config, String trackingId, String appName, String appVersion) {
        this(config, (DefaultRequest)((DefaultRequest)((DefaultRequest)new DefaultRequest().trackingId(trackingId)).applicationName(appName)).applicationVersion(appVersion));
    }

    public GoogleAnalytics(GoogleAnalyticsConfig config, DefaultRequest defaultRequest) {
        if (config.isDeriveSystemParameters()) {
            this.deriveSystemParameters(config, defaultRequest);
        }
        logger.info("Initializing Google Analytics with config=" + config + " and defaultRequest=" + defaultRequest);
        this.config = config;
        this.defaultRequest = defaultRequest;
        this.httpClient = this.createHttpClient(config);
    }

    public GoogleAnalyticsConfig getConfig() {
        return this.config;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public DefaultRequest getDefaultRequest() {
        return this.defaultRequest;
    }

    public void setDefaultRequest(DefaultRequest request) {
        this.defaultRequest = request;
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GoogleAnalyticsResponse post(GoogleAnalyticsRequest request) {
        GoogleAnalyticsResponse response = new GoogleAnalyticsResponse();
        if (!this.config.isEnabled()) {
            return response;
        }
        CloseableHttpResponse httpResponse = null;
        try {
            Map<GoogleAnalyticsParameter, String> parms = request.getParameters();
            Map<GoogleAnalyticsParameter, String> defaultParms = this.defaultRequest.getParameters();
            for (GoogleAnalyticsParameter parm : defaultParms.keySet()) {
                String value = parms.get((Object)parm);
                String defaultValue = defaultParms.get((Object)parm);
                if (!this.isEmpty(value) || this.isEmpty(defaultValue)) continue;
                parms.put(parm, defaultValue);
            }
            logger.debug("Sending " + request);
            HttpPost httpPost = new HttpPost(this.config.getUrl());
            ArrayList<BasicNameValuePair> postParms = new ArrayList<BasicNameValuePair>();
            for (GoogleAnalyticsParameter key : parms.keySet()) {
                postParms.add(new BasicNameValuePair(key.getParameterName(), parms.get((Object)key)));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(postParms, UTF8));
            httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);
            response.setStatusCode(httpResponse.getStatusLine().getStatusCode());
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            if (this.config.isGatherStats()) {
                this.gatherStats(request);
            }
        }
        catch (Exception e) {
            if (e instanceof UnknownHostException) {
                logger.warn("Coudln't connect to Google Analytics. Internet may not be available. " + e.toString());
            } else {
                logger.warn("Exception while sending the Google Analytics tracker request " + request, (Throwable)e);
            }
        }
        finally {
            try {
                httpResponse.close();
            }
            catch (Exception e2) {}
        }
        return response;
    }

    private void gatherStats(GoogleAnalyticsRequest request) {
        String hitType = request.hitType();
        if ("pageView".equalsIgnoreCase(hitType)) {
            this.stats.pageViewHit();
        } else if ("appView".equalsIgnoreCase(hitType)) {
            this.stats.appViewHit();
        } else if ("event".equalsIgnoreCase(hitType)) {
            this.stats.eventHit();
        } else if ("item".equalsIgnoreCase(hitType)) {
            this.stats.itemHit();
        } else if ("transaction".equalsIgnoreCase(hitType)) {
            this.stats.transactionHit();
        } else if ("social".equalsIgnoreCase(hitType)) {
            this.stats.socialHit();
        } else if ("timing".equalsIgnoreCase(hitType)) {
            this.stats.timingHit();
        }
    }

    public Future<GoogleAnalyticsResponse> postAsync(final RequestProvider requestProvider) {
        if (!this.config.isEnabled()) {
            return null;
        }
        Future<GoogleAnalyticsResponse> future = this.getExecutor().submit(new Callable<GoogleAnalyticsResponse>(){

            @Override
            public GoogleAnalyticsResponse call() throws Exception {
                try {
                    GoogleAnalyticsRequest request = requestProvider.getRequest();
                    if (request != null) {
                        return GoogleAnalytics.this.post(request);
                    }
                }
                catch (Exception e) {
                    logger.warn("Request Provider (" + requestProvider + ") thrown exception " + e.toString() + " and hence nothing is posted to GA.");
                }
                return null;
            }
        });
        return future;
    }

    public Future<GoogleAnalyticsResponse> postAsync(final GoogleAnalyticsRequest request) {
        if (!this.config.isEnabled()) {
            return null;
        }
        Future<GoogleAnalyticsResponse> future = this.getExecutor().submit(new Callable<GoogleAnalyticsResponse>(){

            @Override
            public GoogleAnalyticsResponse call() throws Exception {
                return GoogleAnalytics.this.post(request);
            }
        });
        return future;
    }

    private boolean isNotEmpty(String value) {
        return !this.isEmpty(value);
    }

    private boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public void close() {
        try {
            this.executor.shutdown();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.httpClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected DefaultRequest deriveSystemParameters(GoogleAnalyticsConfig config, DefaultRequest request) {
        try {
            if (this.isEmpty(config.getUserAgent())) {
                config.setUserAgent(this.getUserAgentString());
            }
            if (this.isEmpty(request.userLanguage())) {
                String region = System.getProperty("user.region");
                if (this.isEmpty(region)) {
                    region = System.getProperty("user.country");
                }
                request.userLanguage(System.getProperty("user.language") + "-" + region);
            }
            if (this.isEmpty(request.documentEncoding())) {
                request.documentEncoding(System.getProperty("file.encoding"));
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (this.isEmpty(request.screenResolution())) {
                Dimension screenSize = toolkit.getScreenSize();
                request.screenResolution((int)screenSize.getWidth() + "x" + (int)screenSize.getHeight() + ", " + toolkit.getScreenResolution() + " dpi");
            }
            if (this.isEmpty(request.screenColors())) {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice[] graphicsDevices = graphicsEnvironment.getScreenDevices();
                StringBuilder sb = new StringBuilder();
                for (GraphicsDevice graphicsDevice : graphicsDevices) {
                    if (sb.length() != 0) {
                        sb.append(", ");
                    }
                    sb.append(graphicsDevice.getDisplayMode().getBitDepth());
                }
                request.screenColors(sb.toString());
            }
        }
        catch (Exception e) {
            logger.warn("Exception while deriving the System properties for request " + request, (Throwable)e);
        }
        return request;
    }

    protected CloseableHttpClient createHttpClient(GoogleAnalyticsConfig config) {
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        connManager.setDefaultMaxPerRoute(this.getDefaultMaxPerRoute(config));
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        if (this.isNotEmpty(config.getUserAgent())) {
            builder.setUserAgent(config.getUserAgent());
        }
        if (this.isNotEmpty(config.getProxyHost())) {
            builder.setProxy(new HttpHost(config.getProxyHost(), config.getProxyPort()));
            if (this.isNotEmpty(config.getProxyUserName())) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(config.getProxyHost(), config.getProxyPort()), (Credentials)new UsernamePasswordCredentials(config.getProxyUserName(), config.getProxyPassword()));
                builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
        }
        return builder.build();
    }

    protected int getDefaultMaxPerRoute(GoogleAnalyticsConfig config) {
        return Math.max(config.getMaxThreads(), 1);
    }

    protected ThreadPoolExecutor getExecutor() {
        if (this.executor == null) {
            this.executor = this.createExecutor(this.config);
        }
        return this.executor;
    }

    protected synchronized ThreadPoolExecutor createExecutor(GoogleAnalyticsConfig config) {
        return new ThreadPoolExecutor(0, config.getMaxThreads(), 5L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>(), this.createThreadFactory());
    }

    protected String getUserAgentString() {
        StringBuilder sb = new StringBuilder("java");
        this.appendProperty(sb, "java.runtime.version");
        this.appendProperty(sb, "java.specification.vendor");
        this.appendProperty(sb, "java.vm.name");
        this.appendProperty(sb, "os.name");
        this.appendProperty(sb, "os.version");
        this.appendProperty(sb, "os.arch");
        return sb.toString();
    }

    protected void appendProperty(StringBuilder sb, String property) {
        String value = System.getProperty(property);
        if (this.isNotEmpty(value)) {
            sb.append("/").append(value);
        }
    }

    protected ThreadFactory createThreadFactory() {
        return new GoogleAnalyticsThreadFactory(this.config.getThreadNameFormat());
    }

    public GoogleAnalyticsStats getStats() {
        return this.stats;
    }

    public void resetStats() {
        this.stats = new GoogleAnalyticsStats();
    }
}

