/*
 * Decompiled with CFR 0.152.
 */
package com.brsanthu.googleanalytics;

public class GoogleAnalyticsConfig {
    private String threadNameFormat = "googleanalytics-thread-{0}";
    private boolean enabled = true;
    private int maxThreads = 1;
    private boolean useHttps = true;
    private boolean validate = true;
    private String httpUrl = "http://www.google-analytics.com/collect";
    private String httpsUrl = "https://www.google-analytics.com/collect";
    private String userAgent = null;
    private String proxyHost = null;
    private int proxyPort = 80;
    private String proxyUserName = null;
    private String proxyPassword = null;
    private boolean deriveSystemParameters = true;
    private boolean gatherStats = false;

    public boolean isGatherStats() {
        return this.gatherStats;
    }

    public void setGatherStats(boolean gatherStats) {
        this.gatherStats = gatherStats;
    }

    public GoogleAnalyticsConfig setThreadNameFormat(String threadNameFormat) {
        this.threadNameFormat = threadNameFormat;
        return this;
    }

    public String getThreadNameFormat() {
        return this.threadNameFormat;
    }

    public GoogleAnalyticsConfig setDeriveSystemParameters(boolean deriveSystemProperties) {
        this.deriveSystemParameters = deriveSystemProperties;
        return this;
    }

    public boolean isDeriveSystemParameters() {
        return this.deriveSystemParameters;
    }

    public GoogleAnalyticsConfig setProxyUserName(String proxyUserName) {
        this.proxyUserName = proxyUserName;
        return this;
    }

    public String getProxyUserName() {
        return this.proxyUserName;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public GoogleAnalyticsConfig setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        return this;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public GoogleAnalyticsConfig setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public GoogleAnalyticsConfig setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public GoogleAnalyticsConfig setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public GoogleAnalyticsConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public GoogleAnalyticsConfig setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }

    public boolean isUseHttps() {
        return this.useHttps;
    }

    public GoogleAnalyticsConfig setUseHttps(boolean useHttps) {
        this.useHttps = useHttps;
        return this;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public GoogleAnalyticsConfig setValidate(boolean validate) {
        this.validate = validate;
        return this;
    }

    public String getHttpUrl() {
        return this.httpUrl;
    }

    public GoogleAnalyticsConfig setHttpUrl(String httpUrl) {
        this.httpUrl = httpUrl;
        return this;
    }

    public String getHttpsUrl() {
        return this.httpsUrl;
    }

    public GoogleAnalyticsConfig setHttpsUrl(String httpsUrl) {
        this.httpsUrl = httpsUrl;
        return this;
    }

    String getUrl() {
        return this.useHttps ? this.httpsUrl : this.httpUrl;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GoogleAnalyticsConfig [");
        if (this.threadNameFormat != null) {
            builder.append("threadNameFormat=");
            builder.append(this.threadNameFormat);
            builder.append(", ");
        }
        builder.append("enabled=");
        builder.append(this.enabled);
        builder.append(", maxThreads=");
        builder.append(this.maxThreads);
        builder.append(", useHttps=");
        builder.append(this.useHttps);
        builder.append(", validate=");
        builder.append(this.validate);
        builder.append(", ");
        if (this.httpUrl != null) {
            builder.append("httpUrl=");
            builder.append(this.httpUrl);
            builder.append(", ");
        }
        if (this.httpsUrl != null) {
            builder.append("httpsUrl=");
            builder.append(this.httpsUrl);
            builder.append(", ");
        }
        if (this.userAgent != null) {
            builder.append("userAgent=");
            builder.append(this.userAgent);
            builder.append(", ");
        }
        if (this.proxyHost != null) {
            builder.append("proxyHost=");
            builder.append(this.proxyHost);
            builder.append(", ");
        }
        builder.append("proxyPort=");
        builder.append(this.proxyPort);
        builder.append(", ");
        if (this.proxyUserName != null) {
            builder.append("proxyUserName=");
            builder.append(this.proxyUserName);
            builder.append(", ");
        }
        if (this.proxyPassword != null) {
            builder.append("proxyPassword=");
            builder.append(GoogleAnalyticsConfig.mask(this.proxyPassword));
            builder.append(", ");
        }
        builder.append("deriveSystemParameters=");
        builder.append(this.deriveSystemParameters);
        builder.append(", gatherStats=");
        builder.append(this.gatherStats);
        builder.append("]");
        return builder.toString();
    }

    public static String mask(String value) {
        return value == null ? null : "********";
    }
}

