/*
 * Decompiled with CFR 0.152.
 */
package com.brsanthu.googleanalytics;

public enum GoogleAnalyticsParameter {
    PROTOCOL_VERSION("v", true),
    TRACKING_ID("tid", true),
    ANONYMIZE_IP("aip", "boolean"),
    QUEUE_TIME("qt", "integer"),
    CACHE_BUSTER("z"),
    USER_IP("uip"),
    USER_AGENT("ua"),
    CLIENT_ID("cid", true),
    SESSION_CONTROL("sc"),
    DOCUMENT_REFERRER("dr"),
    CAMPAIGN_NAME("cn"),
    CAMPAIGN_SOURCE("cs"),
    CAMPAIGN_MEDIUM("cm"),
    CAMPAIGN_KEYWORD("ck"),
    CAMPAIGN_CONTENT("cc"),
    CAMPAIGN_ID("ci"),
    ADWORDS_ID("gclid"),
    DISPLAY_ADS_ID("dclid"),
    SCREEN_RESOLUTION("sr"),
    VIEWPORT_SIZE("vp"),
    DOCUMENT_ENCODING("de"),
    SCREEN_COLORS("sd"),
    USER_LANGUAGE("ul"),
    JAVA_ENABLED("je", "boolean"),
    FLASH_VERSION("fl"),
    HIT_TYPE("t", true),
    NON_INTERACTION_HIT("ni"),
    DOCUMENT_URL("dl"),
    DOCUMENT_HOST_NAME("dh"),
    DOCUMENT_PATH("dp"),
    DOCUMENT_TITLE("dt"),
    CONTENT_DESCRIPTION("cd"),
    APPLICATION_NAME("an"),
    APPLICATION_VERSION("av"),
    EVENT_CATEGORY("ec", new String[]{"event"}),
    EVENT_ACTION("ea", new String[]{"event"}),
    EVENT_LABEL("el", new String[]{"event"}),
    EVENT_VALUE("ev", false, "integer", new String[]{"event"}),
    TRANSACTION_ID("ti", new String[]{"transaction", "item"}),
    TRANSACTION_AFFILIATION("ta", new String[]{"transaction"}),
    TRANSACTION_REVENUE("tr", false, "currency", new String[]{"transaction"}),
    TRANSACTION_SHIPPING("ts", false, "currency", new String[]{"transaction"}),
    TRANSACTION_TAX("tt", false, "currency", new String[]{"transaction"}),
    ITEM_NAME("in", new String[]{"item"}),
    ITEM_PRICE("ip", false, "currency", new String[]{"item"}),
    ITEM_QUANTITY("iq", false, "integer", new String[]{"item"}),
    ITEM_CODE("ic", new String[]{"item"}),
    ITEM_CATEGORY("iv", new String[]{"item"}),
    CURRENCY_CODE("cu", new String[]{"transaction", "item"}),
    SOCIAL_NETWORK("sn", new String[]{"social"}),
    SOCIAL_ACTION("sa", new String[]{"social"}),
    SOCIAL_ACTION_TARGET("st", new String[]{"social"}),
    USER_TIMING_CATEGORY("utc", new String[]{"timing"}),
    USER_TIMING_VARIABLE_NAME("utv", new String[]{"timing"}),
    USER_TIMING_TIME("utt", false, "integer", new String[]{"timing"}),
    USER_TIMING_LABEL("utl", new String[]{"timing"}),
    PAGE_LOAD_TIME("plt", false, "integer", new String[]{"timing"}),
    DNS_TIME("dns", false, "integer", new String[]{"timing"}),
    PAGE_DOWNLOAD_TIME("pdt", false, "integer", new String[]{"timing"}),
    REDIRECT_RESPONSE_TIME("rrt", false, "integer", new String[]{"timing"}),
    TCP_CONNECT_TIME("tcp", false, "integer", new String[]{"timing"}),
    SERVER_RESPONSE_TIME("srt", false, "integer", new String[]{"timing"}),
    EXCEPTION_DESCRIPTION("exd", new String[]{"exception"}),
    EXCEPTION_FATAL("exf", false, "boolean", new String[]{"exception"}),
    EXPERIMENT_ID("xid"),
    EXPERIMENT_VARIANT("xvar");

    private String parameterName = null;
    private boolean required = false;
    private String type = "text";
    private String[] supportedHitTypes = null;

    private GoogleAnalyticsParameter(String name) {
        this(name, false);
    }

    private GoogleAnalyticsParameter(String name, boolean required) {
        this(name, required, "text", null);
    }

    private GoogleAnalyticsParameter(String name, String type) {
        this(name, false, type, null);
    }

    private GoogleAnalyticsParameter(String name, String[] supportedHitTypes) {
        this(name, false, "text", supportedHitTypes);
    }

    private GoogleAnalyticsParameter(String name, boolean required, String type, String[] supportedHitTypes) {
        this.parameterName = name;
        this.required = required;
        this.type = type;
        this.supportedHitTypes = supportedHitTypes;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String[] getSupportedHitTypes() {
        return this.supportedHitTypes;
    }

    public String getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }
}

