/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.service.sms.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.byteplus.error.SdkError;
import com.byteplus.model.ServiceInfo;
import com.byteplus.model.request.ApplySmsTemplateRequest;
import com.byteplus.model.request.ConversionRequest;
import com.byteplus.model.request.DeleteSmsTemplateRequest;
import com.byteplus.model.request.GetSmsTemplateAndOrderListRequest;
import com.byteplus.model.request.GetSubAccountListRequest;
import com.byteplus.model.request.SmsBatchSendRequest;
import com.byteplus.model.request.SmsCheckVerifyCodeRequest;
import com.byteplus.model.request.SmsSendRequest;
import com.byteplus.model.request.SmsSendVerifyCodeRequest;
import com.byteplus.model.request.SubAccountRequest;
import com.byteplus.model.response.ApplySmsTemplateResponse;
import com.byteplus.model.response.ConversionResponse;
import com.byteplus.model.response.DeleteSmsTemplateResponse;
import com.byteplus.model.response.GetSmsTemplateAndOrderListResponse;
import com.byteplus.model.response.GetSubAccountDetailResponse;
import com.byteplus.model.response.GetSubAccountListResponse;
import com.byteplus.model.response.RawResponse;
import com.byteplus.model.response.ResponseMetadata;
import com.byteplus.model.response.SmsCheckVerifyCodeResponse;
import com.byteplus.model.response.SmsSendResponse;
import com.byteplus.service.BaseServiceImpl;
import com.byteplus.service.sms.SmsConfig;
import com.byteplus.service.sms.SmsService;
import com.byteplus.util.ConvertUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.NameValuePair;

public class SmsServiceImpl
extends BaseServiceImpl
implements SmsService {
    private SmsServiceImpl() {
        super(SmsConfig.serviceInfoMap.get("cn-north-1"), SmsConfig.apiInfoList);
    }

    private SmsServiceImpl(ServiceInfo serviceInfo) {
        super(serviceInfo, SmsConfig.apiInfoList);
    }

    public static SmsService getInstance() {
        return new SmsServiceImpl();
    }

    public static SmsService getInstance(String region) throws Exception {
        ServiceInfo serviceInfo = SmsConfig.serviceInfoMap.get(region);
        if (serviceInfo == null) {
            throw new Exception("Edit not support region " + region);
        }
        return new SmsServiceImpl(serviceInfo);
    }

    public static SmsService newSmsService(ServiceInfo serviceInfo) throws Exception {
        if (serviceInfo == null) {
            throw new Exception("ServiceInfo is null");
        }
        return new SmsServiceImpl(serviceInfo);
    }

    @Override
    public SmsSendResponse send(SmsSendRequest smsSendRequest) throws Exception {
        RawResponse response = this.json("SendSms", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsSendRequest));
        if (response.getCode() == SdkError.EHTTP.getNumber()) {
            response = this.json("SendSms", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsSendRequest));
        }
        return this.getSmsSendResponse(response);
    }

    @Override
    public SmsSendResponse batchSend(SmsBatchSendRequest smsBatchSendRequest) throws Exception {
        RawResponse response = this.json("SendBatchSms", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsBatchSendRequest));
        if (response.getCode() == SdkError.EHTTP.getNumber()) {
            response = this.json("SendBatchSms", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsBatchSendRequest));
        }
        return this.getSmsSendResponse(response);
    }

    @Override
    public SmsSendResponse sendVerifyCode(SmsSendVerifyCodeRequest smsSendVerifyCodeRequest) throws Exception {
        RawResponse response = this.json("SendSmsVerifyCode", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsSendVerifyCodeRequest));
        return this.getSmsSendResponse(response);
    }

    @Override
    public SmsCheckVerifyCodeResponse checkVerifyCode(SmsCheckVerifyCodeRequest smsCheckVerifyCodeRequest) throws Exception {
        RawResponse response = this.json("CheckSmsVerifyCode", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsCheckVerifyCodeRequest));
        return this.getSmsCheckResponse(response);
    }

    @Override
    public ConversionResponse conversion(ConversionRequest conversionRequest) throws Exception {
        RawResponse response = this.json("Conversion", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)conversionRequest));
        return this.getConversionResponse(response);
    }

    @Override
    public GetSubAccountListResponse getSubAccountList(GetSubAccountListRequest getSubAccountListRequest) throws Exception {
        List<NameValuePair> urlParams = ConvertUtils.convertToPair(getSubAccountListRequest);
        RawResponse response = this.json("GetSubAccountList", urlParams, "");
        return this.getSubAccountListResponse(response);
    }

    @Override
    public GetSubAccountDetailResponse getSubAccountDetail(SubAccountRequest subAccountRequest) throws Exception {
        List<NameValuePair> urlParams = ConvertUtils.convertToPair(subAccountRequest);
        RawResponse response = this.json("GetSubAccountDetail", urlParams, "");
        return this.getSubAccountDetailResponse(response);
    }

    @Override
    public GetSmsTemplateAndOrderListResponse getSmsTemplateAndOrderList(GetSmsTemplateAndOrderListRequest getSmsTemplateAndOrderListRequest) throws Exception {
        List<NameValuePair> urlParams = ConvertUtils.convertToPair(getSmsTemplateAndOrderListRequest);
        RawResponse response = this.json("GetSmsTemplateAndOrderList", urlParams, "");
        return this.getSmsTemplateAndOrderListResponse(response);
    }

    @Override
    public ApplySmsTemplateResponse applySmsTemplate(ApplySmsTemplateRequest applySmsTemplateRequest) throws Exception {
        RawResponse response = this.json("ApplySmsTemplate", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)applySmsTemplateRequest));
        return this.applySmsTemplateResponse(response);
    }

    @Override
    public DeleteSmsTemplateResponse deleteSmsTemplate(DeleteSmsTemplateRequest deleteSmsTemplateRequest) throws Exception {
        RawResponse response = this.json("DeleteSmsTemplate", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)deleteSmsTemplateRequest));
        return this.deleteSmsTemplateResponse(response);
    }

    private SmsSendResponse getSmsSendResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        SmsSendResponse res = (SmsSendResponse)JSON.parseObject((byte[])response.getData(), SmsSendResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private SmsCheckVerifyCodeResponse getSmsCheckResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        SmsCheckVerifyCodeResponse res = (SmsCheckVerifyCodeResponse)JSON.parseObject((byte[])response.getData(), SmsCheckVerifyCodeResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private ConversionResponse getConversionResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ConversionResponse res = (ConversionResponse)JSON.parseObject((byte[])response.getData(), ConversionResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private GetSubAccountListResponse getSubAccountListResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetSubAccountListResponse res = (GetSubAccountListResponse)JSON.parseObject((byte[])response.getData(), GetSubAccountListResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private GetSubAccountDetailResponse getSubAccountDetailResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetSubAccountDetailResponse res = (GetSubAccountDetailResponse)JSON.parseObject((byte[])response.getData(), GetSubAccountDetailResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private GetSmsTemplateAndOrderListResponse getSmsTemplateAndOrderListResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetSmsTemplateAndOrderListResponse res = (GetSmsTemplateAndOrderListResponse)JSON.parseObject((byte[])response.getData(), GetSmsTemplateAndOrderListResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private ApplySmsTemplateResponse applySmsTemplateResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ApplySmsTemplateResponse res = (ApplySmsTemplateResponse)JSON.parseObject((byte[])response.getData(), ApplySmsTemplateResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private DeleteSmsTemplateResponse deleteSmsTemplateResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DeleteSmsTemplateResponse res = (DeleteSmsTemplateResponse)JSON.parseObject((byte[])response.getData(), DeleteSmsTemplateResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }
}

