/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy;

import com.cedarpolicy.AuthorizationEngine;
import com.cedarpolicy.CedarJson;
import com.cedarpolicy.model.AuthorizationResponse;
import com.cedarpolicy.model.ValidationRequest;
import com.cedarpolicy.model.ValidationResponse;
import com.cedarpolicy.model.exception.AuthException;
import com.cedarpolicy.model.exception.BadRequestException;
import com.cedarpolicy.model.exception.InternalException;
import com.cedarpolicy.model.slice.Slice;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BasicAuthorizationEngine
implements AuthorizationEngine {
    private static final Logger LOG = LoggerFactory.getLogger(BasicAuthorizationEngine.class);

    @Override
    public AuthorizationResponse isAuthorized(com.cedarpolicy.model.AuthorizationRequest q, Slice slice) throws AuthException {
        LOG.trace("Making an isAuthorized request:\n{}\nwith slice\n{}", (Object)q, (Object)slice);
        AuthorizationRequest request = new AuthorizationRequest(q, slice);
        return BasicAuthorizationEngine.call("AuthorizationOperation", AuthorizationResponse.class, request);
    }

    @Override
    public ValidationResponse validate(ValidationRequest q) throws AuthException {
        LOG.trace("Making a validate request:\n{}", (Object)q);
        return BasicAuthorizationEngine.call("ValidateOperation", ValidationResponse.class, q);
    }

    private static <REQ, RESP> RESP call(String operation, Class<RESP> responseClass, REQ request) throws AuthException {
        try {
            String cedarJNIVersion = BasicAuthorizationEngine.getCedarJNIVersion();
            if (!cedarJNIVersion.equals(AuthorizationEngine.getCedarLangVersion())) {
                throw new AuthException("Error, Java Cedar Language version is " + AuthorizationEngine.getCedarLangVersion() + " but JNI Cedar Language version is " + cedarJNIVersion);
            }
            String fullRequest = CedarJson.objectWriter().writeValueAsString(request);
            LOG.debug("Making a request ({}, {}) of length {} through the JNI interface:", (Object)operation, (Object)fullRequest.length());
            LOG.trace("The request:\n{}", (Object)fullRequest);
            String response = BasicAuthorizationEngine.callCedarJNI(operation, fullRequest);
            LOG.trace("Received response of length {}:\n{}", (Object)response.length(), (Object)response);
            JsonNode responseNode = CedarJson.objectReader().readTree(response);
            boolean wasSuccessful = responseNode.path("success").asBoolean(false);
            if (wasSuccessful) {
                String resultJson = responseNode.path("result").textValue();
                return (RESP)CedarJson.objectReader().readValue(resultJson, responseClass);
            }
            ErrorResponse error = (ErrorResponse)CedarJson.objectReader().forType(ErrorResponse.class).readValue(responseNode);
            if (error.isInternal) {
                throw new InternalException(error.errors);
            }
            throw new BadRequestException(error.errors);
        }
        catch (JsonProcessingException e) {
            throw new AuthException("JSON Serialization Error", e);
        }
        catch (IllegalArgumentException e) {
            throw new AuthException("Authorization error caused by illegal argument exception.", e);
        }
        catch (IOException e) {
            throw new AuthException("JSON Deserialization Error", e);
        }
    }

    private static native String callCedarJNI(String var0, String var1);

    private static native String getCedarJNIVersion();

    static {
        System.load(System.getenv("CEDAR_JAVA_FFI_LIB"));
    }

    private static final class AuthorizationRequest
    extends com.cedarpolicy.model.AuthorizationRequest {
        @JsonProperty
        public final Slice slice;

        AuthorizationRequest(com.cedarpolicy.model.AuthorizationRequest request, Slice slice) {
            super(request.principalEUID, request.actionEUID, request.resourceEUID, request.context, request.schema);
            this.slice = slice;
        }
    }

    private static final class ErrorResponse {
        public final boolean success;
        public final boolean isInternal;
        public final String[] errors;

        @JsonCreator
        ErrorResponse(@JsonProperty(value="success") boolean success, @JsonProperty(value="isInternal") boolean isInternal, @JsonProperty(value="errors") String[] errors) {
            this.success = success;
            this.isInternal = isInternal;
            this.errors = errors;
        }
    }
}

