/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model;

import com.cedarpolicy.Experimental;
import com.cedarpolicy.ExperimentalFeature;
import com.cedarpolicy.model.AuthorizationRequest;
import com.cedarpolicy.model.schema.Schema;
import com.cedarpolicy.model.slice.Entity;
import com.cedarpolicy.value.EntityUID;
import com.cedarpolicy.value.Value;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;

@Experimental(value=ExperimentalFeature.PARTIAL_EVALUATION)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class PartialAuthorizationRequest
extends AuthorizationRequest {
    public PartialAuthorizationRequest(Optional<EntityUID> principalEUID, EntityUID actionEUID, Optional<EntityUID> resourceEUID, Optional<Map<String, Value>> context, Optional<Schema> schema, boolean enableRequestValidation) {
        super(principalEUID, actionEUID, resourceEUID, context, schema, enableRequestValidation);
    }

    public PartialAuthorizationRequest(Optional<Entity> principal, Entity action, Optional<Entity> resource, Optional<Map<String, Value>> context, Optional<Schema> schema, boolean enableRequestValidation) {
        super(principal, action, resource, context, schema, enableRequestValidation);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private EntityUID principalEUID;
        private EntityUID actionEUID;
        private EntityUID resourceEUID;
        private Map<String, Value> context;
        private Schema schema;
        private boolean enableRequestValidation;

        private Builder() {
        }

        public Builder principal(EntityUID principalEUID) {
            this.principalEUID = principalEUID;
            return this;
        }

        public Builder principal(Entity principal) {
            return this.principal(principal != null ? principal.getEUID() : null);
        }

        public Builder action(EntityUID actionEUID) {
            this.actionEUID = actionEUID;
            return this;
        }

        public Builder action(Entity action) {
            return this.action(action != null ? action.getEUID() : null);
        }

        public Builder resource(EntityUID resourceEUID) {
            this.resourceEUID = resourceEUID;
            return this;
        }

        public Builder resource(Entity resource) {
            return this.resource(resource != null ? resource.getEUID() : null);
        }

        public Builder context(Map<String, Value> context) {
            this.context = ImmutableMap.copyOf(context);
            return this;
        }

        public Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public Builder enableRequestValidation() {
            this.enableRequestValidation = true;
            return this;
        }

        public PartialAuthorizationRequest build() {
            return new PartialAuthorizationRequest(Optional.ofNullable(this.principalEUID), this.actionEUID, Optional.ofNullable(this.resourceEUID), Optional.ofNullable(this.context), Optional.ofNullable(this.schema), this.enableRequestValidation);
        }
    }
}

