/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model;

import com.cedarpolicy.Experimental;
import com.cedarpolicy.ExperimentalFeature;
import com.cedarpolicy.model.AuthorizationResponse;
import com.cedarpolicy.model.slice.Policy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Experimental(value=ExperimentalFeature.PARTIAL_EVALUATION)
public abstract class PartialAuthorizationResponse {
    private final AuthorizationResponse.Diagnostics diagnostics;

    @JsonCreator
    public static PartialAuthorizationResponse createPartialAuthorizationResponse(@JsonProperty(value="response") PartialAuthorizationResponse nested, @JsonProperty(value="decision") AuthorizationResponse.Decision decision, @JsonProperty(value="residuals") Map<String, JsonNode> residuals, @JsonProperty(value="diagnostics") AuthorizationResponse.Diagnostics diagnostics) {
        if (nested != null) {
            return nested;
        }
        if (decision != null && diagnostics != null) {
            return new ConcretePartialAuthorizationResponse(decision, diagnostics);
        }
        if (residuals != null && diagnostics != null) {
            return new ResidualPartialAuthorizationResponse(residuals, diagnostics);
        }
        return null;
    }

    protected PartialAuthorizationResponse(AuthorizationResponse.Diagnostics diagnostics) {
        this.diagnostics = diagnostics;
    }

    public AuthorizationResponse.Diagnostics getDiagnostics() {
        return this.diagnostics;
    }

    public Set<String> getReasons() {
        return this.diagnostics.getReasons();
    }

    public List<String> getErrors() {
        return this.diagnostics.getErrors();
    }

    public abstract boolean reachedDecision();

    public static final class ConcretePartialAuthorizationResponse
    extends PartialAuthorizationResponse {
        private final AuthorizationResponse.Decision decision;

        private ConcretePartialAuthorizationResponse(AuthorizationResponse.Decision decision, AuthorizationResponse.Diagnostics diagnostics) {
            super(diagnostics);
            this.decision = decision;
        }

        public AuthorizationResponse.Decision getDecision() {
            return this.decision;
        }

        public boolean isAllowed() {
            return this.decision == AuthorizationResponse.Decision.Allow;
        }

        @Override
        public boolean reachedDecision() {
            return this.decision != AuthorizationResponse.Decision.NoDecision;
        }
    }

    public static final class ResidualPartialAuthorizationResponse
    extends PartialAuthorizationResponse {
        private final ImmutableSet<Policy> residuals;

        public ResidualPartialAuthorizationResponse(Map<String, JsonNode> residuals, AuthorizationResponse.Diagnostics diagnostics) {
            super(diagnostics);
            this.residuals = (ImmutableSet)residuals.entrySet().stream().map(e -> new Policy(((JsonNode)e.getValue()).toString(), (String)e.getKey())).collect(ImmutableSet.toImmutableSet());
        }

        public Set<Policy> getResiduals() {
            return this.residuals;
        }

        @Override
        public boolean reachedDecision() {
            return false;
        }
    }
}

