/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model;

import com.cedarpolicy.model.schema.Schema;
import com.cedarpolicy.model.slice.Entity;
import com.cedarpolicy.value.EntityUID;
import com.cedarpolicy.value.Value;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class AuthorizationRequest {
    @JsonProperty(value="principal")
    public final Optional<EntityUID> principalEUID;
    @JsonProperty(value="action")
    public final EntityUID actionEUID;
    @JsonProperty(value="resource")
    public final Optional<EntityUID> resourceEUID;
    public final Optional<Map<String, Value>> context;
    public final Optional<Schema> schema;
    public final boolean enable_request_validation;

    public AuthorizationRequest(Optional<EntityUID> principalEUID, EntityUID actionEUID, Optional<EntityUID> resourceEUID, Optional<Map<String, Value>> context, Optional<Schema> schema, boolean enable_request_validation) {
        this.principalEUID = principalEUID;
        this.actionEUID = actionEUID;
        this.resourceEUID = resourceEUID;
        this.context = !context.isPresent() || context.get() == null ? Optional.empty() : Optional.of(new HashMap<String, Value>(context.get()));
        this.schema = schema;
        this.enable_request_validation = enable_request_validation;
    }

    public AuthorizationRequest(EntityUID principalEUID, EntityUID actionEUID, EntityUID resourceEUID, Map<String, Value> context) {
        this(Optional.of(principalEUID), actionEUID, Optional.of(resourceEUID), Optional.of(context), Optional.empty(), false);
    }

    public AuthorizationRequest(Entity principalEUID, Entity actionEUID, Entity resourceEUID, Map<String, Value> context) {
        this(principalEUID.getEUID(), actionEUID.getEUID(), resourceEUID.getEUID(), context);
    }

    public AuthorizationRequest(Optional<Entity> principal, Entity action, Optional<Entity> resource, Optional<Map<String, Value>> context, Optional<Schema> schema, boolean enable_request_validation) {
        this(principal.map(e -> e.getEUID()), action.getEUID(), resource.map(e -> e.getEUID()), context, schema, enable_request_validation);
    }

    public String toString() {
        return "Request(" + this.principalEUID + ",\t" + this.actionEUID + ",\t" + this.resourceEUID + ")";
    }
}

