/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model;

import com.cedarpolicy.Experimental;
import com.cedarpolicy.ExperimentalFeature;
import com.cedarpolicy.model.AuthorizationResponse;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;

@Experimental(value=ExperimentalFeature.PARTIAL_EVALUATION)
public class PartialAuthorizationResponse {
    private final AuthorizationResponse.Decision decision;
    private final ImmutableSet<String> satisfied;
    private final ImmutableSet<String> errored;
    private final ImmutableSet<String> may_be_determining;
    private final ImmutableSet<String> must_be_determining;
    private final ImmutableMap<String, JsonNode> residuals;
    private final ImmutableSet<String> nontrivial_residuals;

    public PartialAuthorizationResponse(AuthorizationResponse.Decision decision, Set<String> satisfied, Set<String> errored, Set<String> may_be_determining, Set<String> must_be_determining, Map<String, JsonNode> residuals, Set<String> nontrivial_residuals) {
        this.decision = decision;
        this.satisfied = (ImmutableSet)satisfied.stream().collect(ImmutableSet.toImmutableSet());
        this.errored = (ImmutableSet)errored.stream().collect(ImmutableSet.toImmutableSet());
        this.may_be_determining = (ImmutableSet)may_be_determining.stream().collect(ImmutableSet.toImmutableSet());
        this.must_be_determining = (ImmutableSet)must_be_determining.stream().collect(ImmutableSet.toImmutableSet());
        this.residuals = ImmutableMap.builder().putAll(residuals).build();
        this.nontrivial_residuals = (ImmutableSet)nontrivial_residuals.stream().collect(ImmutableSet.toImmutableSet());
    }

    public AuthorizationResponse.Decision getDecision() {
        return this.decision;
    }

    public Map<String, JsonNode> getResiduals() {
        return this.residuals;
    }

    public Set<String> getSatisfied() {
        return this.satisfied;
    }

    public Set<String> getErrored() {
        return this.errored;
    }

    public Set<String> getMayBeDetermining() {
        return this.may_be_determining;
    }

    public Set<String> getMustBeDetermining() {
        return this.must_be_determining;
    }

    public Set<String> getNontrivialResiduals() {
        return this.nontrivial_residuals;
    }

    @JsonCreator
    public static PartialAuthorizationResponse createPartialAuthorizationResponse(@JsonProperty(value="response") PartialAuthorizationResponse nested, @JsonProperty(value="decision") AuthorizationResponse.Decision decision, @JsonProperty(value="satisfied") Set<String> satisfied, @JsonProperty(value="errored") Set<String> errored, @JsonProperty(value="may_be_determining") Set<String> may_be_determining, @JsonProperty(value="must_be_determining") Set<String> must_be_determining, @JsonProperty(value="residuals") Map<String, JsonNode> residuals, @JsonProperty(value="nontrivial_residuals") Set<String> nontrivial_residuals) {
        if (nested != null) {
            return nested;
        }
        return new PartialAuthorizationResponse(decision, satisfied, errored, may_be_determining, must_be_determining, residuals, nontrivial_residuals);
    }
}

