/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.value;

import com.cedarpolicy.value.Value;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Decimal
extends Value {
    private final String decimal;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public Decimal(String decimal) throws NullPointerException, IllegalArgumentException {
        if (!DecimalValidator.validDecimal(decimal)) {
            throw new IllegalArgumentException("Input string is not a valid decimal. E.g., \"1.0000\") \n " + decimal);
        }
        this.decimal = decimal;
    }

    @Override
    public String toCedarExpr() {
        return "decimal(\"" + this.decimal + "\")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Decimal decimal1 = (Decimal)o;
        return this.decimal.equals(decimal1.decimal);
    }

    public int hashCode() {
        return Objects.hash(this.decimal);
    }

    public String toString() {
        return this.decimal;
    }

    private static class DecimalValidator {
        private static final Pattern decimalPattern = Pattern.compile("^([0-9])*(\\.)([0-9]{0,4})$");

        private DecimalValidator() {
        }

        public static boolean validDecimal(String d) {
            if (d == null || d.isEmpty()) {
                return false;
            }
            if ((d = d.trim()).length() > 21) {
                return false;
            }
            try {
                Matcher matcher = decimalPattern.matcher(d);
                return matcher.matches();
            }
            catch (PatternSyntaxException ex) {
                return false;
            }
        }
    }
}

