/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model;

import com.cedarpolicy.Experimental;
import com.cedarpolicy.ExperimentalFeature;
import com.cedarpolicy.model.schema.Schema;
import com.cedarpolicy.value.EntityUID;
import com.cedarpolicy.value.Value;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@Experimental(value=ExperimentalFeature.PARTIAL_EVALUATION)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class PartialAuthorizationRequest {
    public final Optional<EntityUID> principal;
    public final Optional<EntityUID> action;
    public final Optional<EntityUID> resource;
    public final Optional<Map<String, Value>> context;
    public final Optional<Schema> schema;
    @JsonProperty(value="validateRequest")
    public final boolean enableRequestValidation;

    public PartialAuthorizationRequest(Optional<EntityUID> principal, Optional<EntityUID> action, Optional<EntityUID> resource, Optional<Map<String, Value>> context, Optional<Schema> schema, boolean enableRequestValidation) {
        this.principal = principal;
        this.action = action;
        this.resource = resource;
        this.context = context;
        this.schema = schema;
        this.enableRequestValidation = enableRequestValidation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Optional<EntityUID> principalEUID = Optional.empty();
        private Optional<EntityUID> actionEUID = Optional.empty();
        private Optional<EntityUID> resourceEUID = Optional.empty();
        private Optional<Map<String, Value>> context = Optional.empty();
        private Optional<Schema> schema = Optional.empty();
        private boolean enableRequestValidation = false;

        private Builder() {
        }

        public Builder principal(EntityUID principalEUID) {
            this.principalEUID = Optional.of(principalEUID);
            return this;
        }

        public Builder action(EntityUID actionEUID) {
            this.actionEUID = Optional.of(actionEUID);
            return this;
        }

        public Builder resource(EntityUID resourceEUID) {
            this.resourceEUID = Optional.of(resourceEUID);
            return this;
        }

        public Builder context(Map<String, Value> context) {
            this.context = Optional.of(ImmutableMap.copyOf(context));
            return this;
        }

        public Builder emptyContext() {
            this.context = Optional.of(new HashMap());
            return this;
        }

        public Builder schema(Schema schema) {
            this.schema = Optional.of(schema);
            return this;
        }

        public Builder enableRequestValidation() {
            this.enableRequestValidation = true;
            return this;
        }

        public PartialAuthorizationRequest build() {
            return new PartialAuthorizationRequest(this.principalEUID, this.actionEUID, this.resourceEUID, this.context, this.schema, this.enableRequestValidation);
        }
    }
}

