/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model.policy;

import com.cedarpolicy.loader.LibraryLoader;
import com.cedarpolicy.model.exception.InternalException;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.atomic.AtomicInteger;

public class Policy {
    private static final AtomicInteger ID_COUNTER = new AtomicInteger(0);
    public final String policySrc;
    public final String policyID;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public Policy(@JsonProperty(value="policySrc") String policy, @JsonProperty(value="policyID") String policyID) throws NullPointerException {
        if (policy == null) {
            throw new NullPointerException("Failed to construct policy from null string");
        }
        if (policyID == null) {
            policyID = "policy" + ID_COUNTER.addAndGet(1);
        }
        this.policySrc = policy;
        this.policyID = policyID;
    }

    public String getID() {
        return this.policyID;
    }

    public String getSource() {
        return this.policySrc;
    }

    public String toString() {
        return "// Policy ID: " + this.policyID + "\n" + this.policySrc;
    }

    public String toJson() throws InternalException, NullPointerException {
        return this.toJsonJni(this.policySrc);
    }

    public static Policy fromJson(String policyId, String policyJson) throws InternalException, NullPointerException {
        String policyText = Policy.fromJsonJni(policyJson);
        return new Policy(policyText, policyId);
    }

    public static Policy parseStaticPolicy(String policyStr) throws InternalException, NullPointerException {
        String policyText = Policy.parsePolicyJni(policyStr);
        return new Policy(policyText, null);
    }

    public static Policy parsePolicyTemplate(String templateStr) throws InternalException, NullPointerException {
        String templateText = Policy.parsePolicyTemplateJni(templateStr);
        return new Policy(templateText, null);
    }

    private static native String parsePolicyJni(String var0) throws InternalException, NullPointerException;

    private static native String parsePolicyTemplateJni(String var0) throws InternalException, NullPointerException;

    private native String toJsonJni(String var1) throws InternalException, NullPointerException;

    private static native String fromJsonJni(String var0) throws InternalException, NullPointerException;

    static {
        LibraryLoader.loadLibrary();
    }
}

