/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy.model;

import com.cedarpolicy.model.AuthorizationSuccessResponse;
import com.cedarpolicy.model.DetailedError;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;

public final class AuthorizationResponse {
    @JsonProperty(value="type")
    public final SuccessOrFailure type;
    @JsonProperty(value="response")
    public final Optional<AuthorizationSuccessResponse> success;
    @JsonProperty(value="errors")
    public final Optional<ImmutableList<DetailedError>> errors;
    @JsonProperty(value="warnings")
    public final ImmutableList<String> warnings;

    @JsonCreator
    public AuthorizationResponse(@JsonProperty(value="type") SuccessOrFailure type, @JsonProperty(value="response") Optional<AuthorizationSuccessResponse> success, @JsonProperty(value="errors") Optional<ArrayList<DetailedError>> errors, @JsonProperty(value="warnings") ArrayList<String> warnings) {
        this.type = type;
        this.success = success;
        this.errors = errors.map(list -> ImmutableList.copyOf((Collection)list));
        this.warnings = warnings == null ? ImmutableList.of() : ImmutableList.copyOf(warnings);
    }

    public String toString() {
        String warningsString;
        String string = warningsString = this.warnings.isEmpty() ? "" : "\nwith warnings: " + this.warnings.toString();
        if (this.type == SuccessOrFailure.Success) {
            return "SUCCESS: " + this.success.get().toString() + warningsString;
        }
        return "FAILURE: " + this.errors.get().toString() + warningsString;
    }

    public static enum SuccessOrFailure {
        Success,
        Failure;

    }
}

