/*
 * Decompiled with CFR 0.152.
 */
package com.cedarpolicy;

import com.cedarpolicy.AuthorizationEngine;
import com.cedarpolicy.CedarJson;
import com.cedarpolicy.Experimental;
import com.cedarpolicy.ExperimentalFeature;
import com.cedarpolicy.loader.LibraryLoader;
import com.cedarpolicy.model.AuthorizationResponse;
import com.cedarpolicy.model.EntityValidationRequest;
import com.cedarpolicy.model.PartialAuthorizationResponse;
import com.cedarpolicy.model.ValidationRequest;
import com.cedarpolicy.model.ValidationResponse;
import com.cedarpolicy.model.entity.Entity;
import com.cedarpolicy.model.exception.AuthException;
import com.cedarpolicy.model.exception.BadRequestException;
import com.cedarpolicy.model.exception.InternalException;
import com.cedarpolicy.model.exception.MissingExperimentalFeatureException;
import com.cedarpolicy.model.policy.PolicySet;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.List;
import java.util.Set;

public final class BasicAuthorizationEngine
implements AuthorizationEngine {
    @Override
    public AuthorizationResponse isAuthorized(com.cedarpolicy.model.AuthorizationRequest q, PolicySet policySet, Set<Entity> entities) throws AuthException {
        AuthorizationRequest request = new AuthorizationRequest(q, policySet, entities);
        return BasicAuthorizationEngine.call("AuthorizationOperation", AuthorizationResponse.class, request);
    }

    @Override
    @Experimental(value=ExperimentalFeature.PARTIAL_EVALUATION)
    public PartialAuthorizationResponse isAuthorizedPartial(com.cedarpolicy.model.PartialAuthorizationRequest q, PolicySet policySet, Set<Entity> entities) throws AuthException {
        try {
            PartialAuthorizationRequest request = new PartialAuthorizationRequest(q, policySet, entities);
            return BasicAuthorizationEngine.call("AuthorizationPartialOperation", PartialAuthorizationResponse.class, request);
        }
        catch (InternalException e) {
            if (e.getMessage().contains("AuthorizationPartialOperation")) {
                throw new MissingExperimentalFeatureException(ExperimentalFeature.PARTIAL_EVALUATION);
            }
            throw e;
        }
    }

    @Override
    public ValidationResponse validate(ValidationRequest q) throws AuthException {
        return BasicAuthorizationEngine.call("ValidateOperation", ValidationResponse.class, q);
    }

    @Override
    public void validateEntities(EntityValidationRequest q) throws AuthException {
        EntityValidationResponse entityValidationResponse = BasicAuthorizationEngine.call("ValidateEntities", EntityValidationResponse.class, q);
        if (!entityValidationResponse.success) {
            if (entityValidationResponse.isInternal) {
                throw new InternalException(entityValidationResponse.errors.toArray(new String[0]));
            }
            throw new BadRequestException(entityValidationResponse.errors.toArray(new String[0]));
        }
    }

    private static <REQ, RESP> RESP call(String operation, Class<RESP> responseClass, REQ request) throws AuthException {
        try {
            String cedarJNIVersion = BasicAuthorizationEngine.getCedarJNIVersion();
            if (!cedarJNIVersion.equals(AuthorizationEngine.getCedarLangVersion())) {
                throw new AuthException("Error, Java Cedar Language version is " + AuthorizationEngine.getCedarLangVersion() + " but JNI Cedar Language version is " + cedarJNIVersion);
            }
            String fullRequest = CedarJson.objectWriter().writeValueAsString(request);
            String response = BasicAuthorizationEngine.callCedarJNI(operation, fullRequest);
            JsonNode responseNode = CedarJson.objectReader().readTree(response);
            return (RESP)CedarJson.objectReader().readValue(responseNode, responseClass);
        }
        catch (JsonProcessingException e) {
            throw new AuthException("JSON Serialization Error", e);
        }
        catch (IllegalArgumentException e) {
            throw new AuthException("Authorization error caused by illegal argument exception.", e);
        }
        catch (IOException e) {
            throw new AuthException("JSON Deserialization Error", e);
        }
    }

    private static native String callCedarJNI(String var0, String var1);

    private static native String getCedarJNIVersion();

    static {
        LibraryLoader.loadLibrary();
    }

    private static class AuthorizationRequest
    extends com.cedarpolicy.model.AuthorizationRequest {
        @JsonProperty
        private final PolicySet policies;
        @JsonProperty
        private final Set<Entity> entities;

        AuthorizationRequest(com.cedarpolicy.model.AuthorizationRequest request, PolicySet policySet, Set<Entity> entities) {
            super(request.principalEUID, request.actionEUID, request.resourceEUID, request.context, request.schema, request.enableRequestValidation);
            this.policies = policySet;
            this.entities = entities;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private static final class PartialAuthorizationRequest
    extends com.cedarpolicy.model.PartialAuthorizationRequest {
        @JsonProperty
        private final PolicySet policies;
        @JsonProperty
        private final Set<Entity> entities;

        PartialAuthorizationRequest(com.cedarpolicy.model.PartialAuthorizationRequest request, PolicySet policySet, Set<Entity> entities) {
            super(request.principal, request.action, request.resource, request.context, request.schema, request.enableRequestValidation);
            this.policies = policySet;
            this.entities = entities;
        }
    }

    @JsonIgnoreProperties(value={"result"})
    private static final class EntityValidationResponse {
        private final boolean success;
        private final boolean isInternal;
        private final List<String> errors;

        @JsonCreator
        @SuppressFBWarnings
        EntityValidationResponse(@JsonProperty(value="success") boolean success, @JsonProperty(value="isInternal") boolean isInternal, @JsonProperty(value="errors") List<String> errors) {
            this.success = success;
            this.isInternal = isInternal;
            this.errors = errors;
        }
    }
}

