/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.ValidationStatus;
import com.chargebee.org.json.JSONObject;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Address
extends Resource<Address> {
    public Address(String jsonStr) {
        super(jsonStr);
    }

    public Address(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String label() {
        return this.reqString("label");
    }

    public String firstName() {
        return this.optString("first_name");
    }

    public String lastName() {
        return this.optString("last_name");
    }

    public String email() {
        return this.optString("email");
    }

    public String company() {
        return this.optString("company");
    }

    public String phone() {
        return this.optString("phone");
    }

    public String addr() {
        return this.optString("addr");
    }

    public String extendedAddr() {
        return this.optString("extended_addr");
    }

    public String extendedAddr2() {
        return this.optString("extended_addr2");
    }

    public String city() {
        return this.optString("city");
    }

    public String stateCode() {
        return this.optString("state_code");
    }

    public String state() {
        return this.optString("state");
    }

    public String country() {
        return this.optString("country");
    }

    public String zip() {
        return this.optString("zip");
    }

    public ValidationStatus validationStatus() {
        return this.optEnum("validation_status", ValidationStatus.class);
    }

    public String subscriptionId() {
        return this.reqString("subscription_id");
    }

    public static RetrieveRequest retrieve() throws IOException {
        String uri = Address.uri("addresses");
        return new RetrieveRequest(HttpUtil.Method.GET, uri);
    }

    public static UpdateRequest update() throws IOException {
        String uri = Address.uri("addresses");
        return new UpdateRequest(HttpUtil.Method.POST, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateRequest
    extends Request<UpdateRequest> {
        private UpdateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public UpdateRequest subscriptionId(String subscriptionId) {
            this.params.add("subscription_id", subscriptionId);
            return this;
        }

        public UpdateRequest label(String label) {
            this.params.add("label", label);
            return this;
        }

        public UpdateRequest firstName(String firstName) {
            this.params.addOpt("first_name", firstName);
            return this;
        }

        public UpdateRequest lastName(String lastName) {
            this.params.addOpt("last_name", lastName);
            return this;
        }

        public UpdateRequest email(String email) {
            this.params.addOpt("email", email);
            return this;
        }

        public UpdateRequest company(String company) {
            this.params.addOpt("company", company);
            return this;
        }

        public UpdateRequest phone(String phone) {
            this.params.addOpt("phone", phone);
            return this;
        }

        public UpdateRequest addr(String addr) {
            this.params.addOpt("addr", addr);
            return this;
        }

        public UpdateRequest extendedAddr(String extendedAddr) {
            this.params.addOpt("extended_addr", extendedAddr);
            return this;
        }

        public UpdateRequest extendedAddr2(String extendedAddr2) {
            this.params.addOpt("extended_addr2", extendedAddr2);
            return this;
        }

        public UpdateRequest city(String city) {
            this.params.addOpt("city", city);
            return this;
        }

        public UpdateRequest stateCode(String stateCode) {
            this.params.addOpt("state_code", stateCode);
            return this;
        }

        public UpdateRequest state(String state) {
            this.params.addOpt("state", state);
            return this;
        }

        public UpdateRequest zip(String zip) {
            this.params.addOpt("zip", zip);
            return this;
        }

        public UpdateRequest country(String country) {
            this.params.addOpt("country", country);
            return this;
        }

        public UpdateRequest validationStatus(ValidationStatus validationStatus) {
            this.params.addOpt("validation_status", (Object)validationStatus);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RetrieveRequest
    extends Request<RetrieveRequest> {
        private RetrieveRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public RetrieveRequest subscriptionId(String subscriptionId) {
            this.params.add("subscription_id", subscriptionId);
            return this;
        }

        public RetrieveRequest label(String label) {
            this.params.add("label", label);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }
}

