/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse;

import com.cinchapi.concourse.Concourse;
import com.cinchapi.concourse.ConnectionPool;
import com.cinchapi.concourse.util.ConcurrentLoadingQueue;
import java.util.Queue;
import java.util.concurrent.Callable;

class CachedConnectionPool
extends ConnectionPool {
    private final String host;
    private final int port;
    private String username;
    private final String password;
    private final String environment;

    protected CachedConnectionPool(String host, int port, String username, String password, int poolSize) {
        this(host, port, username, password, "", poolSize);
    }

    protected CachedConnectionPool(String host, int port, String username, String password, String environment, int poolSize) {
        super(host, port, username, password, environment, poolSize);
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.environment = environment;
    }

    @Override
    protected Queue<Concourse> buildQueue(int size) {
        return ConcurrentLoadingQueue.create(new Callable<Concourse>(){

            @Override
            public Concourse call() throws Exception {
                return Concourse.connect(CachedConnectionPool.this.host, CachedConnectionPool.this.port, CachedConnectionPool.this.username, CachedConnectionPool.this.password, CachedConnectionPool.this.environment);
            }
        });
    }

    @Override
    protected Concourse getConnection() {
        return (Concourse)this.available.poll();
    }
}

