/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse;

import com.cinchapi.concourse.Concourse;
import com.cinchapi.concourse.ConcourseThriftDriver;
import com.cinchapi.concourse.Timestamp;
import com.cinchapi.concourse.lang.Criteria;
import com.cinchapi.concourse.lang.Language;
import com.cinchapi.concourse.thrift.TObject;
import com.cinchapi.concourse.util.Collections;
import com.cinchapi.concourse.util.Convert;
import com.google.common.base.Preconditions;
import java.util.Collection;

public class Calculator {
    private final ConcourseThriftDriver concourse;

    Calculator(Concourse concourse) {
        Preconditions.checkArgument((boolean)(concourse instanceof ConcourseThriftDriver));
        this.concourse = (ConcourseThriftDriver)concourse;
    }

    public Number average(String key) {
        return this.concourse.execute(() -> {
            TObject result = this.concourse.thrift().averageKey(key, this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number average(String key, Collection<Long> records) {
        return this.concourse.execute(() -> {
            TObject result = this.concourse.thrift().averageKeyRecords(key, Collections.toLongList(records), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number average(String key, Collection<Long> records, Timestamp timestamp) {
        return this.concourse.execute(() -> {
            TObject result = timestamp.isString() ? this.concourse.thrift().averageKeyRecordsTimestr(key, Collections.toLongList(records), timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().averageKeyRecordsTime(key, Collections.toLongList(records), timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number average(String key, Criteria criteria) {
        return this.concourse.execute(() -> {
            TObject result = this.concourse.thrift().averageKeyCriteria(key, Language.translateToThriftCriteria(criteria), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number average(String key, Criteria criteria, Timestamp timestamp) {
        return this.concourse.execute(() -> {
            TObject result = timestamp.isString() ? this.concourse.thrift().averageKeyCriteriaTimestr(key, Language.translateToThriftCriteria(criteria), timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().averageKeyCriteriaTime(key, Language.translateToThriftCriteria(criteria), timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number average(String key, long record) {
        return this.concourse.execute(() -> {
            TObject result = this.concourse.thrift().averageKeyRecord(key, record, this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number average(String key, long record, Timestamp timestamp) {
        return this.concourse.execute(() -> {
            TObject result = timestamp.isString() ? this.concourse.thrift().averageKeyRecordTimestr(key, record, timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().averageKeyRecordTime(key, record, timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number average(String key, String ccl) {
        return this.concourse.execute(() -> {
            TObject result = this.concourse.thrift().averageKeyCcl(key, ccl, this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number average(String key, String ccl, Timestamp timestamp) {
        return this.concourse.execute(() -> {
            TObject result = timestamp.isString() ? this.concourse.thrift().averageKeyCclTimestr(key, ccl, timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().averageKeyCclTime(key, ccl, timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number average(String key, Timestamp timestamp) {
        return this.concourse.execute(() -> {
            TObject result = timestamp.isString() ? this.concourse.thrift().averageKeyTimestr(key, timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().averageKeyTime(key, timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public long count(String key) {
        return this.concourse.execute(() -> this.concourse.thrift().countKey(key, this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()));
    }

    public long count(String key, Collection<Long> records) {
        return this.concourse.execute(() -> this.concourse.thrift().countKeyRecords(key, Collections.toLongList(records), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()));
    }

    public long count(String key, Collection<Long> records, Timestamp timestamp) {
        return this.concourse.execute(() -> timestamp.isString() ? this.concourse.thrift().countKeyRecordsTimestr(key, Collections.toLongList(records), timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().countKeyRecordsTime(key, Collections.toLongList(records), timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()));
    }

    public long count(String key, Criteria criteria) {
        return this.concourse.execute(() -> this.concourse.thrift().countKeyCriteria(key, Language.translateToThriftCriteria(criteria), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()));
    }

    public long count(String key, Criteria criteria, Timestamp timestamp) {
        return this.concourse.execute(() -> timestamp.isString() ? this.concourse.thrift().countKeyCriteriaTimestr(key, Language.translateToThriftCriteria(criteria), timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().countKeyCriteriaTime(key, Language.translateToThriftCriteria(criteria), timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()));
    }

    public long count(String key, long record) {
        return this.concourse.execute(() -> this.concourse.thrift().countKeyRecord(key, record, this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()));
    }

    public long count(String key, long record, Timestamp timestamp) {
        return this.concourse.execute(() -> timestamp.isString() ? this.concourse.thrift().countKeyRecordTimestr(key, record, timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().countKeyRecordTime(key, record, timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()));
    }

    public long count(String key, String ccl) {
        return this.concourse.execute(() -> this.concourse.thrift().countKeyCcl(key, ccl, this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()));
    }

    public long count(String key, String ccl, Timestamp timestamp) {
        return this.concourse.execute(() -> timestamp.isString() ? this.concourse.thrift().countKeyCclTimestr(key, ccl, timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().countKeyCclTime(key, ccl, timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()));
    }

    public long count(String key, Timestamp timestamp) {
        return this.concourse.execute(() -> timestamp.isString() ? this.concourse.thrift().countKeyTimestr(key, timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().countKeyTime(key, timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()));
    }

    public Number max(String key) {
        return this.concourse.execute(() -> {
            TObject result = this.concourse.thrift().maxKey(key, this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number max(String key, Collection<Long> records) {
        return this.concourse.execute(() -> {
            TObject result = this.concourse.thrift().maxKeyRecords(key, Collections.toLongList(records), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number max(String key, Collection<Long> records, Timestamp timestamp) {
        return this.concourse.execute(() -> {
            TObject result = timestamp.isString() ? this.concourse.thrift().maxKeyRecordsTimestr(key, Collections.toLongList(records), timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().maxKeyRecordsTime(key, Collections.toLongList(records), timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number max(String key, Criteria criteria) {
        return this.concourse.execute(() -> {
            TObject result = this.concourse.thrift().maxKeyCriteria(key, Language.translateToThriftCriteria(criteria), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number max(String key, Criteria criteria, Timestamp timestamp) {
        return this.concourse.execute(() -> {
            TObject result = timestamp.isString() ? this.concourse.thrift().maxKeyCriteriaTimestr(key, Language.translateToThriftCriteria(criteria), timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().maxKeyCriteriaTime(key, Language.translateToThriftCriteria(criteria), timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number max(String key, long record) {
        return this.concourse.execute(() -> {
            TObject result = this.concourse.thrift().maxKeyRecord(key, record, this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number max(String key, long record, Timestamp timestamp) {
        return this.concourse.execute(() -> {
            TObject result = timestamp.isString() ? this.concourse.thrift().maxKeyRecordTimestr(key, record, timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().maxKeyRecordTime(key, record, timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number max(String key, String ccl) {
        return this.concourse.execute(() -> {
            TObject result = this.concourse.thrift().maxKeyCcl(key, ccl, this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number max(String key, String ccl, Timestamp timestamp) {
        return this.concourse.execute(() -> {
            TObject result = timestamp.isString() ? this.concourse.thrift().maxKeyCclTimestr(key, ccl, timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().maxKeyCclTime(key, ccl, timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number max(String key, Timestamp timestamp) {
        return this.concourse.execute(() -> {
            TObject result = timestamp.isString() ? this.concourse.thrift().maxKeyTimestr(key, timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().maxKeyTime(key, timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number min(String key) {
        return this.concourse.execute(() -> {
            TObject result = this.concourse.thrift().minKey(key, this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number min(String key, Collection<Long> records) {
        return this.concourse.execute(() -> {
            TObject result = this.concourse.thrift().minKeyRecords(key, Collections.toLongList(records), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number min(String key, Collection<Long> records, Timestamp timestamp) {
        return this.concourse.execute(() -> {
            TObject result = timestamp.isString() ? this.concourse.thrift().minKeyRecordsTimestr(key, Collections.toLongList(records), timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().minKeyRecordsTime(key, Collections.toLongList(records), timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number min(String key, Criteria criteria) {
        return this.concourse.execute(() -> {
            TObject result = this.concourse.thrift().minKeyCriteria(key, Language.translateToThriftCriteria(criteria), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number min(String key, Criteria criteria, Timestamp timestamp) {
        return this.concourse.execute(() -> {
            TObject result = timestamp.isString() ? this.concourse.thrift().minKeyCriteriaTimestr(key, Language.translateToThriftCriteria(criteria), timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().minKeyCriteriaTime(key, Language.translateToThriftCriteria(criteria), timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number min(String key, long record) {
        return this.concourse.execute(() -> {
            TObject result = this.concourse.thrift().minKeyRecord(key, record, this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number min(String key, long record, Timestamp timestamp) {
        return this.concourse.execute(() -> {
            TObject result = timestamp.isString() ? this.concourse.thrift().minKeyRecordTimestr(key, record, timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().minKeyRecordTime(key, record, timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number min(String key, String ccl) {
        return this.concourse.execute(() -> {
            TObject result = this.concourse.thrift().minKeyCcl(key, ccl, this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number min(String key, String ccl, Timestamp timestamp) {
        return this.concourse.execute(() -> {
            TObject result = timestamp.isString() ? this.concourse.thrift().minKeyCclTimestr(key, ccl, timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().minKeyCclTime(key, ccl, timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number min(String key, Timestamp timestamp) {
        return this.concourse.execute(() -> {
            TObject result = timestamp.isString() ? this.concourse.thrift().minKeyTimestr(key, timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().minKeyTime(key, timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number sum(String key) {
        return this.concourse.execute(() -> {
            TObject result = this.concourse.thrift().sumKey(key, this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number sum(String key, Collection<Long> records) {
        return this.concourse.execute(() -> {
            TObject result = this.concourse.thrift().sumKeyRecords(key, Collections.toLongList(records), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number sum(String key, Collection<Long> records, Timestamp timestamp) {
        return this.concourse.execute(() -> {
            TObject result = timestamp.isString() ? this.concourse.thrift().sumKeyRecordsTimestr(key, Collections.toLongList(records), timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().sumKeyRecordsTime(key, Collections.toLongList(records), timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number sum(String key, Criteria criteria) {
        return this.concourse.execute(() -> {
            TObject result = this.concourse.thrift().sumKeyCriteria(key, Language.translateToThriftCriteria(criteria), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number sum(String key, Criteria criteria, Timestamp timestamp) {
        return this.concourse.execute(() -> {
            TObject result = timestamp.isString() ? this.concourse.thrift().sumKeyCriteriaTimestr(key, Language.translateToThriftCriteria(criteria), timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().sumKeyCriteriaTime(key, Language.translateToThriftCriteria(criteria), timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number sum(String key, long record) {
        return this.concourse.execute(() -> {
            TObject result = this.concourse.thrift().sumKeyRecord(key, record, this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number sum(String key, long record, Timestamp timestamp) {
        return this.concourse.execute(() -> {
            TObject result = timestamp.isString() ? this.concourse.thrift().sumKeyRecordTimestr(key, record, timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().sumKeyRecordTime(key, record, timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number sum(String key, String ccl) {
        return this.concourse.execute(() -> {
            TObject result = this.concourse.thrift().sumKeyCcl(key, ccl, this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number sum(String key, String ccl, Timestamp timestamp) {
        return this.concourse.execute(() -> {
            TObject result = timestamp.isString() ? this.concourse.thrift().sumKeyCclTimestr(key, ccl, timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().sumKeyCclTime(key, ccl, timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }

    public Number sum(String key, Timestamp timestamp) {
        return this.concourse.execute(() -> {
            TObject result = timestamp.isString() ? this.concourse.thrift().sumKeyTimestr(key, timestamp.toString(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment()) : this.concourse.thrift().sumKeyTime(key, timestamp.getMicros(), this.concourse.creds(), this.concourse.transaction(), this.concourse.environment());
            return (Number)Convert.thriftToJava(result);
        });
    }
}

