/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse;

import com.cinchapi.common.reflect.Reflection;
import com.cinchapi.concourse.Calculator;
import com.cinchapi.concourse.ConcourseThriftDriver;
import com.cinchapi.concourse.DuplicateEntryException;
import com.cinchapi.concourse.Manager;
import com.cinchapi.concourse.Timestamp;
import com.cinchapi.concourse.TransactionException;
import com.cinchapi.concourse.annotate.Incubating;
import com.cinchapi.concourse.config.ConcourseClientPreferences;
import com.cinchapi.concourse.lang.BuildableState;
import com.cinchapi.concourse.lang.Criteria;
import com.cinchapi.concourse.thrift.Diff;
import com.cinchapi.concourse.thrift.Operator;
import com.cinchapi.concourse.util.Convert;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class Concourse
implements AutoCloseable {
    private Calculator calculator = null;
    private Manager manager = null;

    public static Concourse connect() {
        return new ConcourseThriftDriver();
    }

    public static Concourse connect(String environment) {
        return new ConcourseThriftDriver(environment);
    }

    public static Concourse connect(String host, int port, String username, String password) {
        return new ConcourseThriftDriver(host, port, username, password);
    }

    public static Concourse connect(String host, int port, String username, String password, String environment) {
        return new ConcourseThriftDriver(host, port, username, password, environment);
    }

    public static Concourse connectWithPrefs(String file) {
        ConcourseClientPreferences prefs = ConcourseClientPreferences.open(file);
        return Concourse.connect(prefs.getHost(), prefs.getPort(), prefs.getUsername(), String.valueOf(prefs.getPassword()), prefs.getEnvironment());
    }

    public static Concourse copyExistingConnection(Concourse concourse) {
        return concourse.copyConnection();
    }

    public abstract void abort();

    public abstract <T> long add(String var1, T var2);

    public abstract <T> Map<Long, Boolean> add(String var1, T var2, Collection<Long> var3);

    public abstract <T> boolean add(String var1, T var2, long var3);

    public abstract Map<Timestamp, String> audit(long var1);

    public abstract Map<Timestamp, String> audit(long var1, Timestamp var3);

    public abstract Map<Timestamp, String> audit(long var1, Timestamp var3, Timestamp var4);

    public abstract Map<Timestamp, String> audit(String var1, long var2);

    public abstract Map<Timestamp, String> audit(String var1, long var2, Timestamp var4);

    public abstract Map<Timestamp, String> audit(String var1, long var2, Timestamp var4, Timestamp var5);

    public abstract Map<String, Map<Object, Set<Long>>> browse(Collection<String> var1);

    public abstract Map<String, Map<Object, Set<Long>>> browse(Collection<String> var1, Timestamp var2);

    public abstract Map<Object, Set<Long>> browse(String var1);

    public abstract Map<Object, Set<Long>> browse(String var1, Timestamp var2);

    public Calculator calculate() {
        if (this.calculator == null) {
            this.calculator = new Calculator(this);
        }
        return this.calculator;
    }

    public Object calculate(String method, Object ... args) {
        if (this.calculator == null) {
            this.calculator = new Calculator(this);
        }
        return Reflection.call((Object)this.calculator, (String)method, (Object[])args);
    }

    public abstract Map<Timestamp, Set<Object>> chronologize(String var1, long var2);

    public abstract Map<Timestamp, Set<Object>> chronologize(String var1, long var2, Timestamp var4);

    public abstract Map<Timestamp, Set<Object>> chronologize(String var1, long var2, Timestamp var4, Timestamp var5);

    public abstract void clear(Collection<Long> var1);

    public abstract void clear(Collection<String> var1, Collection<Long> var2);

    public abstract void clear(Collection<String> var1, long var2);

    public abstract void clear(long var1);

    public abstract void clear(String var1, Collection<Long> var2);

    public abstract void clear(String var1, long var2);

    @Override
    public final void close() {
        this.exit();
    }

    public abstract boolean commit();

    public abstract Set<String> describe();

    public abstract Map<Long, Set<String>> describe(Collection<Long> var1);

    public abstract Map<Long, Set<String>> describe(Collection<Long> var1, Timestamp var2);

    public abstract Set<String> describe(long var1);

    public abstract Set<String> describe(long var1, Timestamp var3);

    public abstract Set<String> describe(Timestamp var1);

    public abstract <T> Map<String, Map<Diff, Set<T>>> diff(long var1, Timestamp var3);

    public abstract <T> Map<String, Map<Diff, Set<T>>> diff(long var1, Timestamp var3, Timestamp var4);

    public abstract <T> Map<Diff, Set<T>> diff(String var1, long var2, Timestamp var4);

    public abstract <T> Map<Diff, Set<T>> diff(String var1, long var2, Timestamp var4, Timestamp var5);

    public abstract <T> Map<T, Map<Diff, Set<Long>>> diff(String var1, Timestamp var2);

    public abstract <T> Map<T, Map<Diff, Set<Long>>> diff(String var1, Timestamp var2, Timestamp var3);

    public abstract void exit();

    public abstract Set<Long> find(Criteria var1);

    public abstract Set<Long> find(Object var1);

    public abstract Set<Long> find(String var1);

    public abstract Set<Long> find(String var1, Object var2);

    public abstract Set<Long> find(String var1, Object var2, Timestamp var3);

    public abstract Set<Long> find(String var1, Operator var2, Object var3);

    public abstract Set<Long> find(String var1, Operator var2, Object var3, Object var4);

    public abstract Set<Long> find(String var1, Operator var2, Object var3, Object var4, Timestamp var5);

    public abstract Set<Long> find(String var1, Operator var2, Object var3, Timestamp var4);

    public abstract Set<Long> find(String var1, String var2, Object var3);

    public abstract Set<Long> find(String var1, String var2, Object var3, Object var4);

    public abstract Set<Long> find(String var1, String var2, Object var3, Object var4, Timestamp var5);

    public abstract Set<Long> find(String var1, String var2, Object var3, Timestamp var4);

    public abstract <T> long findOrAdd(String var1, T var2) throws DuplicateEntryException;

    public final long findOrInsert(BuildableState criteria, Map<String, Object> data) throws DuplicateEntryException {
        String json = Convert.mapToJson(data);
        return this.findOrInsert(criteria, json);
    }

    public final long findOrInsert(BuildableState criteria, Multimap<String, Object> data) throws DuplicateEntryException {
        String json = Convert.mapToJson(data);
        return this.findOrInsert(criteria, json);
    }

    public long findOrInsert(BuildableState criteria, String json) throws DuplicateEntryException {
        return this.findOrInsert(criteria.build(), json);
    }

    public final long findOrInsert(Criteria criteria, Map<String, Object> data) throws DuplicateEntryException {
        String json = Convert.mapToJson(data);
        return this.findOrInsert(criteria, json);
    }

    public final long findOrInsert(Criteria criteria, Multimap<String, Object> data) throws DuplicateEntryException {
        String json = Convert.mapToJson(data);
        return this.findOrInsert(criteria, json);
    }

    public abstract long findOrInsert(Criteria var1, String var2) throws DuplicateEntryException;

    public final long findOrInsert(String ccl, Map<String, Object> data) throws DuplicateEntryException {
        String json = Convert.mapToJson(data);
        return this.findOrInsert(ccl, json);
    }

    public final long findOrInsert(String ccl, Multimap<String, Object> data) throws DuplicateEntryException {
        String json = Convert.mapToJson(data);
        return this.findOrInsert(ccl, json);
    }

    public abstract long findOrInsert(String var1, String var2) throws DuplicateEntryException;

    public abstract <T> Map<Long, Map<String, T>> get(Collection<String> var1, Collection<Long> var2);

    public abstract <T> Map<Long, Map<String, T>> get(Collection<String> var1, Collection<Long> var2, Timestamp var3);

    public abstract <T> Map<Long, Map<String, T>> get(Collection<String> var1, Criteria var2);

    public abstract <T> Map<Long, Map<String, T>> get(Collection<String> var1, Criteria var2, Timestamp var3);

    public abstract <T> Map<String, T> get(Collection<String> var1, long var2);

    public abstract <T> Map<String, T> get(Collection<String> var1, long var2, Timestamp var4);

    public abstract <T> Map<Long, Map<String, T>> get(Collection<String> var1, Object var2);

    public abstract <T> Map<Long, Map<String, T>> get(Collection<String> var1, Object var2, Timestamp var3);

    public abstract <T> Map<Long, Map<String, T>> get(Collection<String> var1, String var2);

    public abstract <T> Map<Long, Map<String, T>> get(Collection<String> var1, String var2, Timestamp var3);

    public abstract <T> Map<Long, Map<String, T>> get(Criteria var1);

    public abstract <T> Map<Long, Map<String, T>> get(Criteria var1, Timestamp var2);

    public abstract <T> Map<Long, Map<String, T>> get(Object var1);

    public abstract <T> Map<Long, Map<String, T>> get(Object var1, Timestamp var2);

    public abstract <T> Map<Long, Map<String, T>> get(String var1);

    public abstract <T> Map<Long, T> get(String var1, Collection<Long> var2);

    public abstract <T> Map<Long, T> get(String var1, Collection<Long> var2, Timestamp var3);

    public abstract <T> Map<Long, T> get(String var1, Criteria var2);

    public abstract <T> Map<Long, T> get(String var1, Criteria var2, Timestamp var3);

    @Nullable
    public abstract <T> T get(String var1, long var2);

    @Nullable
    public abstract <T> T get(String var1, long var2, Timestamp var4);

    public abstract <T> Map<Long, T> get(String var1, Object var2);

    public abstract <T> Map<Long, T> get(String var1, Object var2, Timestamp var3);

    public abstract <T> Map<Long, T> get(String var1, String var2);

    public abstract <T> Map<Long, T> get(String var1, String var2, Timestamp var3);

    public abstract <T> Map<Long, Map<String, T>> get(String var1, Timestamp var2);

    public abstract String getServerEnvironment();

    public abstract String getServerVersion();

    public final Set<Long> insert(Collection<Multimap<String, Object>> data) {
        String json = Convert.mapsToJson(data);
        return this.insert(json);
    }

    public final long insert(Map<String, Object> data) {
        String json = Convert.mapToJson(data);
        return this.insert(json).iterator().next();
    }

    public final Map<Long, Boolean> insert(Map<String, Object> data, Collection<Long> records) {
        String json = Convert.mapToJson(data);
        return this.insert(json, records);
    }

    public final boolean insert(Map<String, Object> data, long record) {
        String json = Convert.mapToJson(data);
        return this.insert(json, record);
    }

    public final long insert(Multimap<String, Object> data) {
        String json = Convert.mapToJson(data);
        return this.insert(json).iterator().next();
    }

    public final Map<Long, Boolean> insert(Multimap<String, Object> data, Collection<Long> records) {
        String json = Convert.mapToJson(data);
        return this.insert(json, records);
    }

    public final boolean insert(Multimap<String, Object> data, long record) {
        String json = Convert.mapToJson(data);
        return this.insert(json, record);
    }

    public abstract Set<Long> insert(String var1);

    public abstract Map<Long, Boolean> insert(String var1, Collection<Long> var2);

    public abstract boolean insert(String var1, long var2);

    public abstract Set<Long> inventory();

    public abstract <T> T invokePlugin(String var1, String var2, Object ... var3);

    public abstract String jsonify(Collection<Long> var1);

    public abstract String jsonify(Collection<Long> var1, boolean var2);

    public abstract String jsonify(Collection<Long> var1, Timestamp var2);

    public abstract String jsonify(Collection<Long> var1, Timestamp var2, boolean var3);

    public abstract String jsonify(long var1);

    public abstract String jsonify(long var1, boolean var3);

    public abstract String jsonify(long var1, Timestamp var3);

    public abstract String jsonify(long var1, Timestamp var3, boolean var4);

    public abstract Map<Long, Boolean> link(String var1, Collection<Long> var2, long var3);

    public abstract boolean link(String var1, long var2, long var4);

    public Manager manage() {
        if (this.manager == null) {
            this.manager = new Manager(this);
        }
        return this.manager;
    }

    public abstract <T> Map<Long, Map<String, Set<T>>> navigate(Collection<String> var1, Collection<Long> var2);

    public abstract <T> Map<Long, Map<String, Set<T>>> navigate(Collection<String> var1, Collection<Long> var2, Timestamp var3);

    public abstract <T> Map<Long, Map<String, Set<T>>> navigate(Collection<String> var1, Criteria var2);

    public abstract <T> Map<Long, Map<String, Set<T>>> navigate(Collection<String> var1, Criteria var2, Timestamp var3);

    public abstract <T> Map<Long, Map<String, Set<T>>> navigate(Collection<String> var1, long var2);

    public abstract <T> Map<Long, Map<String, Set<T>>> navigate(Collection<String> var1, long var2, Timestamp var4);

    public final <T> Map<Long, Map<String, Set<T>>> navigate(Collection<String> keys, Object criteria) {
        if (criteria instanceof BuildableState) {
            return this.navigate(keys, ((BuildableState)criteria).build());
        }
        throw new IllegalArgumentException(criteria + " is not a valid argument for the navigate method");
    }

    public final <T> Map<Long, Map<String, Set<T>>> navigate(Collection<String> keys, Object criteria, Timestamp timestamp) {
        if (criteria instanceof BuildableState) {
            return this.navigate(keys, ((BuildableState)criteria).build(), timestamp);
        }
        throw new IllegalArgumentException(criteria + " is not a valid argument for the navigate method");
    }

    public abstract <T> Map<Long, Map<String, Set<T>>> navigate(Collection<String> var1, String var2);

    public abstract <T> Map<Long, Map<String, Set<T>>> navigate(Collection<String> var1, String var2, Timestamp var3);

    public abstract <T> Map<Long, Set<T>> navigate(String var1, Collection<Long> var2);

    public abstract <T> Map<Long, Set<T>> navigate(String var1, Collection<Long> var2, Timestamp var3);

    public abstract <T> Map<Long, Set<T>> navigate(String var1, Criteria var2);

    public abstract <T> Map<Long, Set<T>> navigate(String var1, Criteria var2, Timestamp var3);

    public abstract <T> Map<Long, Set<T>> navigate(String var1, long var2);

    public abstract <T> Map<Long, Set<T>> navigate(String var1, long var2, Timestamp var4);

    public final <T> Map<Long, Set<T>> navigate(String key, Object criteria) {
        if (criteria instanceof BuildableState) {
            return this.navigate(key, ((BuildableState)criteria).build());
        }
        throw new IllegalArgumentException(criteria + " is not a valid argument for the navigate method");
    }

    public final <T> Map<Long, Set<T>> navigate(String key, Object criteria, Timestamp timestamp) {
        if (criteria instanceof BuildableState) {
            return this.navigate(key, ((BuildableState)criteria).build(), timestamp);
        }
        throw new IllegalArgumentException(criteria + " is not a valid argument for the navigate method");
    }

    public abstract <T> Map<Long, Set<T>> navigate(String var1, String var2);

    public abstract <T> Map<Long, Set<T>> navigate(String var1, String var2, Timestamp var3);

    public abstract Map<Long, Boolean> ping(Collection<Long> var1);

    public abstract boolean ping(long var1);

    @Incubating
    public abstract <T> void reconcile(String var1, long var2, Collection<T> var4);

    @Incubating
    public final <T> void reconcile(String key, long record, T ... values) {
        this.reconcile(key, record, Sets.newHashSet((Object[])values));
    }

    public abstract <T> Map<Long, Boolean> remove(String var1, T var2, Collection<Long> var3);

    public abstract <T> boolean remove(String var1, T var2, long var3);

    public abstract void revert(Collection<String> var1, Collection<Long> var2, Timestamp var3);

    public abstract void revert(Collection<String> var1, long var2, Timestamp var4);

    public abstract void revert(String var1, Collection<Long> var2, Timestamp var3);

    public abstract void revert(String var1, long var2, Timestamp var4);

    public abstract Set<Long> search(String var1, String var2);

    public abstract Map<Long, Map<String, Set<Object>>> select(Collection<Long> var1);

    public abstract Map<Long, Map<String, Set<Object>>> select(Collection<Long> var1, Timestamp var2);

    public abstract <T> Map<Long, Map<String, Set<T>>> select(Collection<String> var1, Collection<Long> var2);

    public abstract <T> Map<Long, Map<String, Set<T>>> select(Collection<String> var1, Collection<Long> var2, Timestamp var3);

    public abstract <T> Map<Long, Map<String, Set<T>>> select(Collection<String> var1, Criteria var2);

    public abstract <T> Map<Long, Map<String, Set<T>>> select(Collection<String> var1, Criteria var2, Timestamp var3);

    public abstract <T> Map<String, Set<T>> select(Collection<String> var1, long var2);

    public abstract <T> Map<String, Set<T>> select(Collection<String> var1, long var2, Timestamp var4);

    public abstract <T> Map<Long, Map<String, Set<T>>> select(Collection<String> var1, Object var2);

    public abstract <T> Map<Long, Map<String, Set<T>>> select(Collection<String> var1, Object var2, Timestamp var3);

    public abstract <T> Map<Long, Map<String, Set<T>>> select(Collection<String> var1, String var2);

    public abstract <T> Map<Long, Map<String, Set<T>>> select(Collection<String> var1, String var2, Timestamp var3);

    public abstract <T> Map<Long, Map<String, Set<T>>> select(Criteria var1);

    public abstract <T> Map<Long, Map<String, Set<T>>> select(Criteria var1, Timestamp var2);

    public abstract Map<String, Set<Object>> select(long var1);

    public abstract Map<String, Set<Object>> select(long var1, Timestamp var3);

    public abstract <T> Map<Long, Map<String, Set<T>>> select(Object var1);

    public abstract <T> Map<Long, Map<String, Set<T>>> select(Object var1, Timestamp var2);

    public abstract <T> Map<Long, Map<String, Set<T>>> select(String var1);

    public abstract <T> Map<Long, Set<T>> select(String var1, Collection<Long> var2);

    public abstract <T> Map<Long, Set<T>> select(String var1, Collection<Long> var2, Timestamp var3);

    public abstract <T> Map<Long, Set<T>> select(String var1, Criteria var2);

    public abstract <T> Map<Long, Set<T>> select(String var1, Criteria var2, Timestamp var3);

    public abstract <T> Set<T> select(String var1, long var2);

    public abstract <T> Set<T> select(String var1, long var2, Timestamp var4);

    public abstract <T> Map<Long, Set<T>> select(String var1, Object var2);

    public abstract <T> Map<Long, Set<T>> select(String var1, Object var2, Timestamp var3);

    public abstract <T> Map<Long, Set<T>> select(String var1, String var2);

    public abstract <T> Map<Long, Set<T>> select(String var1, String var2, Timestamp var3);

    public abstract <T> Map<Long, Map<String, Set<T>>> select(String var1, Timestamp var2);

    public abstract void set(String var1, Object var2, Collection<Long> var3);

    public abstract <T> void set(String var1, T var2, long var3);

    public abstract void stage() throws TransactionException;

    public final boolean stage(Runnable task) throws TransactionException {
        this.stage();
        try {
            task.run();
            return this.commit();
        }
        catch (TransactionException e) {
            this.abort();
            throw e;
        }
    }

    public abstract Timestamp time();

    public final Timestamp time(long micros) {
        return Timestamp.fromMicros(micros);
    }

    public final Timestamp time(Number micros) {
        return this.time(micros.longValue());
    }

    public abstract Timestamp time(String var1);

    public abstract boolean unlink(String var1, long var2, long var4);

    public abstract boolean verify(String var1, Object var2, long var3);

    public abstract boolean verify(String var1, Object var2, long var3, Timestamp var5);

    public abstract boolean verifyAndSwap(String var1, Object var2, long var3, Object var5);

    public abstract void verifyOrSet(String var1, Object var2, long var3);

    protected abstract Concourse copyConnection();
}

