/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse;

import com.cinchapi.common.base.CheckedExceptions;
import com.cinchapi.concourse.Concourse;
import com.cinchapi.concourse.InvalidArgumentException;
import com.cinchapi.concourse.Link;
import com.cinchapi.concourse.ManagementException;
import com.cinchapi.concourse.ParseException;
import com.cinchapi.concourse.PermissionException;
import com.cinchapi.concourse.Thrift;
import com.cinchapi.concourse.Timestamp;
import com.cinchapi.concourse.config.ConcourseClientPreferences;
import com.cinchapi.concourse.lang.BuildableState;
import com.cinchapi.concourse.lang.Criteria;
import com.cinchapi.concourse.lang.Language;
import com.cinchapi.concourse.security.ClientSecurity;
import com.cinchapi.concourse.thrift.AccessToken;
import com.cinchapi.concourse.thrift.ComplexTObject;
import com.cinchapi.concourse.thrift.ConcourseService;
import com.cinchapi.concourse.thrift.Diff;
import com.cinchapi.concourse.thrift.DuplicateEntryException;
import com.cinchapi.concourse.thrift.Operator;
import com.cinchapi.concourse.thrift.SecurityException;
import com.cinchapi.concourse.thrift.TObject;
import com.cinchapi.concourse.thrift.TransactionException;
import com.cinchapi.concourse.thrift.TransactionToken;
import com.cinchapi.concourse.util.ByteBuffers;
import com.cinchapi.concourse.util.Collections;
import com.cinchapi.concourse.util.Conversions;
import com.cinchapi.concourse.util.Convert;
import com.cinchapi.concourse.util.LinkNavigation;
import com.cinchapi.concourse.util.PrettyLinkedHashMap;
import com.cinchapi.concourse.util.PrettyLinkedTableMap;
import com.cinchapi.concourse.util.Transformers;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

class ConcourseThriftDriver
extends Concourse {
    private static String ENVIRONMENT;
    private static String PASSWORD;
    private static String SERVER_HOST;
    private static int SERVER_PORT;
    private static String USERNAME;
    private final ConcourseService.Client client;
    private AccessToken creds = null;
    private final String environment;
    private final String host;
    private final ByteBuffer password;
    private final int port;
    private TransactionToken transaction = null;
    private final ByteBuffer username;

    public ConcourseThriftDriver() {
        this(ENVIRONMENT);
    }

    public ConcourseThriftDriver(String environment) {
        this(SERVER_HOST, SERVER_PORT, USERNAME, PASSWORD, environment);
    }

    public ConcourseThriftDriver(String host, int port, String username, String password) {
        this(host, port, username, password, "");
    }

    public ConcourseThriftDriver(String host, int port, String username, String password, String environment) {
        this.host = host;
        this.port = port;
        this.username = ClientSecurity.encrypt(username);
        this.password = ClientSecurity.encrypt(password);
        this.environment = environment;
        TSocket transport = new TSocket(host, port);
        try {
            transport.open();
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
            this.client = new ConcourseService.Client((TProtocol)protocol);
            this.authenticate();
            Runtime.getRuntime().addShutdownHook(new Thread("shutdown", (TTransport)transport){
                final /* synthetic */ TTransport val$transport;
                {
                    this.val$transport = tTransport;
                    super(x0);
                }

                @Override
                public void run() {
                    if (ConcourseThriftDriver.this.transaction != null && this.val$transport.isOpen()) {
                        ConcourseThriftDriver.this.abort();
                        this.val$transport.close();
                    }
                }
            });
        }
        catch (TTransportException e) {
            throw new RuntimeException("Could not connect to the Concourse Server at " + host + ":" + port);
        }
    }

    @Override
    public void abort() {
        this.execute(() -> {
            if (this.transaction != null) {
                TransactionToken token = this.transaction;
                this.transaction = null;
                this.client.abort(this.creds, token, this.environment);
            }
            return null;
        });
    }

    @Override
    public <T> long add(String key, T value) {
        return this.execute(() -> this.client.addKeyValue(key, Convert.javaToThrift(value), this.creds, this.transaction, this.environment));
    }

    @Override
    public <T> Map<Long, Boolean> add(String key, T value, Collection<Long> records) {
        return this.execute(() -> {
            Map<Long, Boolean> raw = this.client.addKeyValueRecords(key, Convert.javaToThrift(value), Collections.toLongList(records), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap<Long, Boolean> pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", "Successful");
            Iterator iterator = records.iterator();
            while (iterator.hasNext()) {
                long record = (Long)iterator.next();
                pretty.put(record, raw.get(record));
            }
            return pretty;
        });
    }

    @Override
    public <T> boolean add(String key, T value, long record) {
        return this.execute(() -> this.client.addKeyValueRecord(key, Convert.javaToThrift(value), record, this.creds, this.transaction, this.environment));
    }

    @Override
    public Map<Timestamp, String> audit(long record) {
        return this.execute(() -> {
            Map<Long, String> audit = this.client.auditRecord(record, this.creds, this.transaction, this.environment);
            return ((PrettyLinkedHashMap)Transformers.transformMap(audit, Conversions.timestampToMicros())).setKeyName("DateTime").setValueName("Revision");
        });
    }

    @Override
    public Map<Timestamp, String> audit(long record, Timestamp start) {
        return this.execute(() -> {
            Map<Long, String> audit = start.isString() ? this.client.auditRecordStartstr(record, start.toString(), this.creds, this.transaction, this.environment) : this.client.auditRecordStart(record, start.getMicros(), this.creds, this.transaction, this.environment);
            return ((PrettyLinkedHashMap)Transformers.transformMap(audit, Conversions.timestampToMicros())).setKeyName("DateTime").setValueName("Revision");
        });
    }

    @Override
    public Map<Timestamp, String> audit(long record, Timestamp start, Timestamp end) {
        return this.execute(() -> {
            Map<Long, String> audit = start.isString() ? this.client.auditRecordStartstrEndstr(record, start.toString(), end.toString(), this.creds, this.transaction, this.environment) : this.client.auditRecordStartEnd(record, start.getMicros(), end.getMicros(), this.creds, this.transaction, this.environment);
            return ((PrettyLinkedHashMap)Transformers.transformMap(audit, Conversions.timestampToMicros())).setKeyName("DateTime").setValueName("Revision");
        });
    }

    @Override
    public Map<Timestamp, String> audit(String key, long record) {
        return this.execute(() -> {
            Map<Long, String> audit = this.client.auditKeyRecord(key, record, this.creds, this.transaction, this.environment);
            return ((PrettyLinkedHashMap)Transformers.transformMap(audit, Conversions.timestampToMicros())).setKeyName("DateTime").setValueName("Revision");
        });
    }

    @Override
    public Map<Timestamp, String> audit(String key, long record, Timestamp start) {
        return this.execute(() -> {
            Map<Long, String> audit = start.isString() ? this.client.auditKeyRecordStartstr(key, record, start.toString(), this.creds, this.transaction, this.environment) : this.client.auditKeyRecordStart(key, record, start.getMicros(), this.creds, this.transaction, this.environment);
            return ((PrettyLinkedHashMap)Transformers.transformMap(audit, Conversions.timestampToMicros())).setKeyName("DateTime").setValueName("Revision");
        });
    }

    @Override
    public Map<Timestamp, String> audit(String key, long record, Timestamp start, Timestamp end) {
        return this.execute(() -> {
            Map<Long, String> audit = start.isString() ? this.client.auditKeyRecordStartstrEndstr(key, record, start.toString(), end.toString(), this.creds, this.transaction, this.environment) : this.client.auditKeyRecordStartEnd(key, record, start.getMicros(), end.getMicros(), this.creds, this.transaction, this.environment);
            return ((PrettyLinkedHashMap)Transformers.transformMap(audit, Conversions.timestampToMicros())).setKeyName("DateTime").setValueName("Revision");
        });
    }

    @Override
    public Map<String, Map<Object, Set<Long>>> browse(Collection<String> keys) {
        return this.execute(() -> {
            Map<String, Map<TObject, Set<Long>>> raw = this.client.browseKeys(Collections.toList(keys), this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap("Key");
            for (Map.Entry<String, Map<TObject, Set<Long>>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapSet(entry.getValue(), Conversions.thriftToJava(), Conversions.none()));
            }
            return pretty;
        });
    }

    @Override
    public Map<String, Map<Object, Set<Long>>> browse(Collection<String> keys, Timestamp timestamp) {
        return this.execute(() -> {
            Map<String, Map<TObject, Set<Long>>> raw = timestamp.isString() ? this.client.browseKeysTimestr(Collections.toList(keys), timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.browseKeysTime(Collections.toList(keys), timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap("Key");
            for (Map.Entry<String, Map<TObject, Set<Long>>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapSet(entry.getValue(), Conversions.thriftToJava(), Conversions.none()));
            }
            return pretty;
        });
    }

    @Override
    public Map<Object, Set<Long>> browse(String key) {
        return this.execute(() -> {
            Map<TObject, Set<Long>> raw = this.client.browseKey(key, this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap<Object, Set<Long>> pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap(key, "Records");
            for (Map.Entry<TObject, Set<Long>> entry : raw.entrySet()) {
                pretty.put(Convert.thriftToJava(entry.getKey()), entry.getValue());
            }
            return pretty;
        });
    }

    @Override
    public Map<Object, Set<Long>> browse(String key, Timestamp timestamp) {
        return this.execute(() -> {
            Map<TObject, Set<Long>> raw = timestamp.isString() ? this.client.browseKeyTimestr(key, timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.browseKeyTime(key, timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap<Object, Set<Long>> pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap(key, "Records");
            for (Map.Entry<TObject, Set<Long>> entry : raw.entrySet()) {
                pretty.put(Convert.thriftToJava(entry.getKey()), entry.getValue());
            }
            return pretty;
        });
    }

    @Override
    public Map<Timestamp, Set<Object>> chronologize(String key, long record) {
        return this.execute(() -> {
            Map<Long, Set<TObject>> raw = this.client.chronologizeKeyRecord(key, record, this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap<Timestamp, Set<Object>> pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("DateTime", "Values");
            for (Map.Entry<Long, Set<TObject>> entry : raw.entrySet()) {
                pretty.put(Timestamp.fromMicros(entry.getKey()), Transformers.transformSetLazily(entry.getValue(), Conversions.thriftToJava()));
            }
            return pretty;
        });
    }

    @Override
    public Map<Timestamp, Set<Object>> chronologize(String key, long record, Timestamp start) {
        return this.execute(() -> {
            Map<Long, Set<TObject>> raw = start.isString() ? this.client.chronologizeKeyRecordStartstr(key, record, start.toString(), this.creds, this.transaction, this.environment) : this.client.chronologizeKeyRecordStart(key, record, start.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap<Timestamp, Set<Object>> pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("DateTime", "Values");
            for (Map.Entry<Long, Set<TObject>> entry : raw.entrySet()) {
                pretty.put(Timestamp.fromMicros(entry.getKey()), Transformers.transformSetLazily(entry.getValue(), Conversions.thriftToJava()));
            }
            return pretty;
        });
    }

    @Override
    public Map<Timestamp, Set<Object>> chronologize(String key, long record, Timestamp start, Timestamp end) {
        return this.execute(() -> {
            Map<Long, Set<TObject>> raw = start.isString() ? this.client.chronologizeKeyRecordStartstrEndstr(key, record, start.toString(), end.toString(), this.creds, this.transaction, this.environment) : this.client.chronologizeKeyRecordStartEnd(key, record, start.getMicros(), end.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap<Timestamp, Set<Object>> pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("DateTime", "Values");
            for (Map.Entry<Long, Set<TObject>> entry : raw.entrySet()) {
                pretty.put(Timestamp.fromMicros(entry.getKey()), Transformers.transformSetLazily(entry.getValue(), Conversions.thriftToJava()));
            }
            return pretty;
        });
    }

    @Override
    public void clear(Collection<Long> records) {
        this.execute(() -> {
            this.client.clearRecords(Collections.toLongList(records), this.creds, this.transaction, this.environment);
            return null;
        });
    }

    @Override
    public void clear(Collection<String> keys, Collection<Long> records) {
        this.execute(() -> {
            this.client.clearKeysRecords(Collections.toList(keys), Collections.toLongList(records), this.creds, this.transaction, this.environment);
            return null;
        });
    }

    @Override
    public void clear(Collection<String> keys, long record) {
        this.execute(() -> {
            this.client.clearKeysRecord(Collections.toList(keys), record, this.creds, this.transaction, this.environment);
            return null;
        });
    }

    @Override
    public void clear(long record) {
        this.execute(() -> {
            this.client.clearRecord(record, this.creds, this.transaction, this.environment);
            return null;
        });
    }

    @Override
    public void clear(String key, Collection<Long> records) {
        this.execute(() -> {
            this.client.clearKeyRecords(key, Collections.toLongList(records), this.creds, this.transaction, this.environment);
            return null;
        });
    }

    @Override
    public void clear(String key, long record) {
        this.execute(() -> {
            this.client.clearKeyRecord(key, record, this.creds, this.transaction, this.environment);
            return null;
        });
    }

    @Override
    public boolean commit() {
        return this.execute(() -> {
            TransactionToken token = this.transaction;
            this.transaction = null;
            return token != null ? this.client.commit(this.creds, token, this.environment) : false;
        });
    }

    @Override
    public Set<String> describe() {
        return this.execute(() -> this.client.describe(this.creds, this.transaction, this.environment));
    }

    @Override
    public Set<String> describe(Timestamp timestamp) {
        return this.execute(() -> {
            if (timestamp.isString()) {
                return this.client.describeTimestr(timestamp.toString(), this.creds, this.transaction, this.environment);
            }
            return this.client.describeTime(timestamp.getMicros(), this.creds, this.transaction, this.environment);
        });
    }

    @Override
    public Map<Long, Set<String>> describe(Collection<Long> records) {
        return this.execute(() -> {
            Map<Long, Set<String>> raw = this.client.describeRecords(Collections.toLongList(records), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap<Long, Set<String>> pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", "Keys");
            for (Map.Entry<Long, Set<String>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), entry.getValue());
            }
            return pretty;
        });
    }

    @Override
    public Map<Long, Set<String>> describe(Collection<Long> records, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, Set<String>> raw = timestamp.isString() ? this.client.describeRecordsTimestr(Collections.toLongList(records), timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.describeRecordsTime(Collections.toLongList(records), timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap<Long, Set<String>> pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", "Keys");
            for (Map.Entry<Long, Set<String>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), entry.getValue());
            }
            return pretty;
        });
    }

    @Override
    public Set<String> describe(long record) {
        return this.execute(() -> {
            Set<String> result = this.client.describeRecord(record, this.creds, this.transaction, this.environment);
            return result;
        });
    }

    @Override
    public Set<String> describe(long record, Timestamp timestamp) {
        return this.execute(() -> {
            if (timestamp.isString()) {
                return this.client.describeRecordTimestr(record, timestamp.toString(), this.creds, this.transaction, this.environment);
            }
            return this.client.describeRecordTime(record, timestamp.getMicros(), this.creds, this.transaction, this.environment);
        });
    }

    @Override
    public <T> Map<String, Map<Diff, Set<T>>> diff(long record, Timestamp start) {
        return this.execute(() -> {
            Map<String, Map<Diff, Set<TObject>>> raw = start.isString() ? this.client.diffRecordStartstr(record, start.toString(), this.creds, this.transaction, this.environment) : this.client.diffRecordStart(record, start.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap();
            pretty.setRowName("Key");
            for (Map.Entry<String, Map<Diff, Set<TObject>>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapSet(entry.getValue(), Conversions.none(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<String, Map<Diff, Set<T>>> diff(long record, Timestamp start, Timestamp end) {
        return this.execute(() -> {
            Map<String, Map<Diff, Set<TObject>>> raw = start.isString() ? this.client.diffRecordStartstrEndstr(record, start.toString(), end.toString(), this.creds, this.transaction, this.environment) : this.client.diffRecordStartEnd(record, start.getMicros(), end.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap();
            pretty.setRowName("Key");
            for (Map.Entry<String, Map<Diff, Set<TObject>>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapSet(entry.getValue(), Conversions.none(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Diff, Set<T>> diff(String key, long record, Timestamp start) {
        return this.execute(() -> {
            Map<Diff, Set<TObject>> raw = start.isString() ? this.client.diffKeyRecordStartstr(key, record, start.toString(), this.creds, this.transaction, this.environment) : this.client.diffKeyRecordStart(key, record, start.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Operation", "Value");
            for (Map.Entry<Diff, Set<TObject>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformSetLazily(entry.getValue(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Diff, Set<T>> diff(String key, long record, Timestamp start, Timestamp end) {
        return this.execute(() -> {
            Map<Diff, Set<TObject>> raw = start.isString() ? this.client.diffKeyRecordStartstrEndstr(key, record, start.toString(), end.toString(), this.creds, this.transaction, this.environment) : this.client.diffKeyRecordStartEnd(key, record, start.getMicros(), end.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Operation", "Value");
            for (Map.Entry<Diff, Set<TObject>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformSetLazily(entry.getValue(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<T, Map<Diff, Set<Long>>> diff(String key, Timestamp start) {
        return this.execute(() -> {
            Map<TObject, Map<Diff, Set<Long>>> raw = start.isString() ? this.client.diffKeyStartstr(key, start.toString(), this.creds, this.transaction, this.environment) : this.client.diffKeyStart(key, start.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap<Object, Diff, Set<Long>> pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap();
            pretty.setRowName("Value");
            for (Map.Entry<TObject, Map<Diff, Set<Long>>> entry : raw.entrySet()) {
                pretty.put(Convert.thriftToJava(entry.getKey()), entry.getValue());
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<T, Map<Diff, Set<Long>>> diff(String key, Timestamp start, Timestamp end) {
        return this.execute(() -> {
            Map<TObject, Map<Diff, Set<Long>>> raw = start.isString() ? this.client.diffKeyStartstrEndstr(key, start.toString(), end.toString(), this.creds, this.transaction, this.environment) : this.client.diffKeyStartEnd(key, start.getMicros(), end.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap<Object, Diff, Set<Long>> pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap();
            pretty.setRowName("Value");
            for (Map.Entry<TObject, Map<Diff, Set<Long>>> entry : raw.entrySet()) {
                pretty.put(Convert.thriftToJava(entry.getKey()), entry.getValue());
            }
            return pretty;
        });
    }

    @Override
    public void exit() {
        try {
            this.client.logout(this.creds, this.environment);
            this.client.getInputProtocol().getTransport().close();
            this.client.getOutputProtocol().getTransport().close();
        }
        catch (SecurityException | TTransportException object) {
        }
        catch (Exception e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    @Override
    public Set<Long> find(Criteria criteria) {
        return this.execute(() -> this.client.findCriteria(Language.translateToThriftCriteria(criteria), this.creds, this.transaction, this.environment));
    }

    @Override
    public Set<Long> find(Object criteria) {
        if (criteria instanceof BuildableState) {
            return this.find(((BuildableState)criteria).build());
        }
        throw new IllegalArgumentException(criteria + " is not a valid argument for the find method");
    }

    @Override
    public Set<Long> find(String ccl) {
        return this.execute(() -> this.client.findCcl(ccl, this.creds, this.transaction, this.environment));
    }

    @Override
    public Set<Long> find(String key, Object value) {
        return this.executeFind(key, (Object)Operator.EQUALS, value);
    }

    @Override
    public Set<Long> find(String key, Object value, Timestamp timestamp) {
        return this.executeFind(key, (Object)Operator.EQUALS, value, timestamp);
    }

    @Override
    public Set<Long> find(String key, Operator operator, Object value) {
        return this.executeFind(key, (Object)operator, value);
    }

    @Override
    public Set<Long> find(String key, Operator operator, Object value, Object value2) {
        return this.executeFind(key, (Object)operator, value, value2);
    }

    @Override
    public Set<Long> find(String key, Operator operator, Object value, Object value2, Timestamp timestamp) {
        return this.executeFind(timestamp, key, (Object)operator, value, value2);
    }

    @Override
    public Set<Long> find(String key, Operator operator, Object value, Timestamp timestamp) {
        return this.executeFind(timestamp, key, (Object)operator, value);
    }

    @Override
    public Set<Long> find(String key, String operator, Object value) {
        return this.executeFind(key, (Object)operator, value);
    }

    @Override
    public Set<Long> find(String key, String operator, Object value, Object value2) {
        return this.executeFind(key, (Object)operator, value, value2);
    }

    @Override
    public Set<Long> find(String key, String operator, Object value, Object value2, Timestamp timestamp) {
        return this.executeFind(timestamp, key, (Object)operator, value, value2);
    }

    @Override
    public Set<Long> find(String key, String operator, Object value, Timestamp timestamp) {
        return this.executeFind(timestamp, key, (Object)operator, value);
    }

    @Override
    public <T> long findOrAdd(String key, T value) throws com.cinchapi.concourse.DuplicateEntryException {
        return this.execute(() -> this.client.findOrAddKeyValue(key, Convert.javaToThrift(value), this.creds, this.transaction, this.environment));
    }

    @Override
    public long findOrInsert(Criteria criteria, String json) throws com.cinchapi.concourse.DuplicateEntryException {
        return this.execute(() -> this.client.findOrInsertCriteriaJson(Language.translateToThriftCriteria(criteria), json, this.creds, this.transaction, this.environment));
    }

    @Override
    public long findOrInsert(String ccl, String json) throws com.cinchapi.concourse.DuplicateEntryException {
        return this.execute(() -> this.client.findOrInsertCclJson(ccl, json, this.creds, this.transaction, this.environment));
    }

    @Override
    public <T> Map<Long, Map<String, T>> get(Collection<String> keys, Collection<Long> records) {
        return this.execute(() -> {
            Map<Long, Map<String, TObject>> raw = this.client.getKeysRecords(Collections.toList(keys), Collections.toLongList(records), this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap("Record");
            for (Map.Entry<Long, Map<String, TObject>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapValues(entry.getValue(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, Map<String, T>> get(Collection<String> keys, Collection<Long> records, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, Map<String, TObject>> raw = timestamp.isString() ? this.client.getKeysRecordsTimestr(Collections.toList(keys), Collections.toLongList(records), timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.getKeysRecordsTime(Collections.toList(keys), Collections.toLongList(records), timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap("Record");
            for (Map.Entry<Long, Map<String, TObject>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapValues(entry.getValue(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, Map<String, T>> get(Collection<String> keys, Criteria criteria) {
        return this.execute(() -> {
            Map<Long, Map<String, TObject>> raw = this.client.getKeysCriteria(Collections.toList(keys), Language.translateToThriftCriteria(criteria), this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap("Record");
            for (Map.Entry<Long, Map<String, TObject>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapValues(entry.getValue(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, Map<String, T>> get(Collection<String> keys, Criteria criteria, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, Map<String, TObject>> raw = timestamp.isString() ? this.client.getKeysCriteriaTimestr(Collections.toList(keys), Language.translateToThriftCriteria(criteria), timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.getKeysCriteriaTime(Collections.toList(keys), Language.translateToThriftCriteria(criteria), timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap("Record");
            for (Map.Entry<Long, Map<String, TObject>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapValues(entry.getValue(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<String, T> get(Collection<String> keys, long record) {
        return this.execute(() -> {
            Map<String, TObject> raw = this.client.getKeysRecord(Collections.toList(keys), record, this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap<String, Object> pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Key", "Value");
            for (Map.Entry<String, TObject> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Convert.thriftToJava(entry.getValue()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<String, T> get(Collection<String> keys, long record, Timestamp timestamp) {
        return this.execute(() -> {
            Map<String, TObject> raw = timestamp.isString() ? this.client.getKeysRecordTimestr(Collections.toList(keys), record, timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.getKeysRecordTime(Collections.toList(keys), record, timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap<String, Object> pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Key", "Value");
            for (Map.Entry<String, TObject> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Convert.thriftToJava(entry.getValue()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, Map<String, T>> get(Collection<String> keys, Object criteria) {
        if (criteria instanceof BuildableState) {
            return this.get(keys, ((BuildableState)criteria).build());
        }
        throw new IllegalArgumentException(criteria + " is not a valid argument for the get method");
    }

    @Override
    public <T> Map<Long, Map<String, T>> get(Collection<String> keys, Object criteria, Timestamp timestamp) {
        if (criteria instanceof BuildableState) {
            return this.get(keys, ((BuildableState)criteria).build(), timestamp);
        }
        throw new IllegalArgumentException(criteria + " is not a valid argument for the get method");
    }

    @Override
    public <T> Map<Long, Map<String, T>> get(Collection<String> keys, String ccl) {
        return this.execute(() -> {
            Map<Long, Map<String, TObject>> raw = this.client.getKeysCcl(Collections.toList(keys), ccl, this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap("Record");
            for (Map.Entry<Long, Map<String, TObject>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapValues(entry.getValue(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, Map<String, T>> get(Collection<String> keys, String ccl, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, Map<String, TObject>> raw = timestamp.isString() ? this.client.getKeysCclTimestr(Collections.toList(keys), ccl, timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.getKeysCclTime(Collections.toList(keys), ccl, timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap("Record");
            for (Map.Entry<Long, Map<String, TObject>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapValues(entry.getValue(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, Map<String, T>> get(Criteria criteria) {
        return this.execute(() -> {
            Map<Long, Map<String, TObject>> raw = this.client.getCriteria(Language.translateToThriftCriteria(criteria), this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap("Record");
            for (Map.Entry<Long, Map<String, TObject>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapValues(entry.getValue(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, Map<String, T>> get(Criteria criteria, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, Map<String, TObject>> raw = timestamp.isString() ? this.client.getCriteriaTimestr(Language.translateToThriftCriteria(criteria), timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.getCriteriaTime(Language.translateToThriftCriteria(criteria), timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap("Record");
            for (Map.Entry<Long, Map<String, TObject>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapValues(entry.getValue(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, Map<String, T>> get(Object criteria) {
        if (criteria instanceof BuildableState) {
            return this.get(((BuildableState)criteria).build());
        }
        throw new IllegalArgumentException(criteria + " is not a valid argument for the get method");
    }

    @Override
    public <T> Map<Long, Map<String, T>> get(Object criteria, Timestamp timestamp) {
        if (criteria instanceof BuildableState) {
            return this.get(((BuildableState)criteria).build(), timestamp);
        }
        throw new IllegalArgumentException(criteria + " is not a valid argument for the get method");
    }

    @Override
    public <T> Map<Long, Map<String, T>> get(String ccl) {
        return this.execute(() -> {
            Map<Long, Map<String, TObject>> raw = this.client.getCcl(ccl, this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap("Record");
            for (Map.Entry<Long, Map<String, TObject>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapValues(entry.getValue(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, T> get(String key, Collection<Long> records) {
        return this.execute(() -> {
            Map<Long, TObject> raw = this.client.getKeyRecords(key, Collections.toLongList(records), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap<Long, Object> pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", key);
            for (Map.Entry<Long, TObject> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Convert.thriftToJava(entry.getValue()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, T> get(String key, Collection<Long> records, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, TObject> raw = timestamp.isString() ? this.client.getKeyRecordsTimestr(key, Collections.toLongList(records), timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.getKeyRecordsTime(key, Collections.toLongList(records), timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap<Long, Object> pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", key);
            for (Map.Entry<Long, TObject> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Convert.thriftToJava(entry.getValue()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, T> get(String key, Criteria criteria) {
        return this.execute(() -> {
            Map<Long, TObject> raw = this.client.getKeyCriteria(key, Language.translateToThriftCriteria(criteria), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap<Long, Object> pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", key);
            for (Map.Entry<Long, TObject> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Convert.thriftToJava(entry.getValue()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, T> get(String key, Criteria criteria, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, TObject> raw = timestamp.isString() ? this.client.getKeyCriteriaTimestr(key, Language.translateToThriftCriteria(criteria), timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.getKeyCriteriaTime(key, Language.translateToThriftCriteria(criteria), timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap<Long, Object> pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", key);
            for (Map.Entry<Long, TObject> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Convert.thriftToJava(entry.getValue()));
            }
            return pretty;
        });
    }

    @Override
    public <T> T get(String key, long record) {
        return (T)this.execute(() -> {
            TObject raw = this.client.getKeyRecord(key, record, this.creds, this.transaction, this.environment);
            return raw == TObject.NULL ? null : Convert.thriftToJava(raw);
        });
    }

    @Override
    public <T> T get(String key, long record, Timestamp timestamp) {
        return (T)this.execute(() -> {
            TObject raw = timestamp.isString() ? this.client.getKeyRecordTimestr(key, record, timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.getKeyRecordTime(key, record, timestamp.getMicros(), this.creds, this.transaction, this.environment);
            return raw == TObject.NULL ? null : Convert.thriftToJava(raw);
        });
    }

    @Override
    public <T> Map<Long, T> get(String key, Object criteria) {
        if (criteria instanceof BuildableState) {
            return this.get(key, ((BuildableState)criteria).build());
        }
        throw new IllegalArgumentException(criteria + " is not a valid argument for the get method");
    }

    @Override
    public <T> Map<Long, T> get(String key, Object criteria, Timestamp timestamp) {
        if (criteria instanceof BuildableState) {
            return this.get(key, ((BuildableState)criteria).build(), timestamp);
        }
        throw new IllegalArgumentException(criteria + " is not a valid argument for the get method");
    }

    @Override
    public <T> Map<Long, T> get(String key, String ccl) {
        return this.execute(() -> {
            Map<Long, TObject> raw = this.client.getKeyCcl(key, ccl, this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap<Long, Object> pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", key);
            for (Map.Entry<Long, TObject> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Convert.thriftToJava(entry.getValue()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, T> get(String key, String ccl, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, TObject> raw = timestamp.isString() ? this.client.getKeyCclTimestr(key, ccl, timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.getKeyCclTime(key, ccl, timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap<Long, Object> pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", key);
            for (Map.Entry<Long, TObject> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Convert.thriftToJava(entry.getValue()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, Map<String, T>> get(String ccl, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, Map<String, TObject>> raw = timestamp.isString() ? this.client.getCclTimestr(ccl, timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.getCclTime(ccl, timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap("Record");
            for (Map.Entry<Long, Map<String, TObject>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapValues(entry.getValue(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public String getServerEnvironment() {
        return this.execute(() -> this.client.getServerEnvironment(this.creds, this.transaction, this.environment));
    }

    @Override
    public String getServerVersion() {
        return this.execute(() -> this.client.getServerVersion());
    }

    @Override
    public Set<Long> insert(String json) {
        return this.execute(() -> this.client.insertJson(json, this.creds, this.transaction, this.environment));
    }

    @Override
    public Map<Long, Boolean> insert(String json, Collection<Long> records) {
        return this.execute(() -> this.client.insertJsonRecords(json, Collections.toLongList(records), this.creds, this.transaction, this.environment));
    }

    @Override
    public boolean insert(String json, long record) {
        return this.execute(() -> this.client.insertJsonRecord(json, record, this.creds, this.transaction, this.environment));
    }

    @Override
    public Set<Long> inventory() {
        return this.execute(() -> this.client.inventory(this.creds, this.transaction, this.environment));
    }

    @Override
    public <T> T invokePlugin(String id, String method, Object ... args) {
        return (T)this.execute(() -> {
            ArrayList params = Lists.newArrayListWithCapacity((int)args.length);
            for (Object arg : args) {
                params.add(ComplexTObject.fromJavaObject(arg));
            }
            ComplexTObject result = this.client.invokePlugin(id, method, params, this.creds, this.transaction, this.environment);
            return result.getJavaObject();
        });
    }

    @Override
    public String jsonify(Collection<Long> records) {
        return this.jsonify(records, true);
    }

    @Override
    public String jsonify(Collection<Long> records, boolean includeId) {
        return this.execute(() -> this.client.jsonifyRecords(Collections.toLongList(records), includeId, this.creds, this.transaction, this.environment));
    }

    @Override
    public String jsonify(Collection<Long> records, Timestamp timestamp) {
        return this.jsonify(records, timestamp, true);
    }

    @Override
    public String jsonify(Collection<Long> records, Timestamp timestamp, boolean includeId) {
        return this.execute(() -> {
            if (timestamp.isString()) {
                return this.client.jsonifyRecordsTimestr(Collections.toLongList(records), timestamp.toString(), includeId, this.creds, this.transaction, this.environment);
            }
            return this.client.jsonifyRecordsTime(Collections.toLongList(records), timestamp.getMicros(), includeId, this.creds, this.transaction, this.environment);
        });
    }

    @Override
    public String jsonify(long record) {
        return this.jsonify(java.util.Collections.singletonList(record), true);
    }

    @Override
    public String jsonify(long record, boolean includeId) {
        return this.jsonify(java.util.Collections.singletonList(record), includeId);
    }

    @Override
    public String jsonify(long record, Timestamp timestamp) {
        return this.jsonify(java.util.Collections.singletonList(record), timestamp, true);
    }

    @Override
    public String jsonify(long record, Timestamp timestamp, boolean includeId) {
        return this.jsonify(java.util.Collections.singletonList(record), timestamp, includeId);
    }

    @Override
    public Map<Long, Boolean> link(String key, Collection<Long> destinations, long source) {
        PrettyLinkedHashMap<Long, Boolean> result = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", "Result");
        for (long destination : destinations) {
            result.put(destination, this.link(key, destination, source));
        }
        return result;
    }

    @Override
    public boolean link(String key, long destination, long source) {
        return this.add(key, Link.to(destination), source);
    }

    @Override
    public <T> Map<Long, Map<String, Set<T>>> navigate(Collection<String> keys, Collection<Long> records) {
        return this.execute(() -> {
            Map<Long, Map<String, Set<TObject>>> raw = this.client.navigateKeysRecords(Collections.toList(keys), Collections.toLongList(records), this.creds, this.transaction, this.environment);
            return Thrift.transformRecordsKeysValues(raw);
        });
    }

    @Override
    public <T> Map<Long, Map<String, Set<T>>> navigate(Collection<String> keys, Collection<Long> records, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, Map<String, Set<TObject>>> raw = this.client.navigateKeysRecordsTime(Collections.toList(keys), Collections.toLongList(records), timestamp.getMicros(), this.creds, this.transaction, this.environment);
            return Thrift.transformRecordsKeysValues(raw);
        });
    }

    @Override
    public <T> Map<Long, Map<String, Set<T>>> navigate(Collection<String> keys, Criteria criteria) {
        return this.execute(() -> {
            Map<Long, Map<String, Set<TObject>>> raw = this.client.navigateKeysCriteria(Collections.toList(keys), Language.translateToThriftCriteria(criteria), this.creds, this.transaction, this.environment);
            return Thrift.transformRecordsKeysValues(raw);
        });
    }

    @Override
    public <T> Map<Long, Map<String, Set<T>>> navigate(Collection<String> keys, Criteria criteria, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, Map<String, Set<TObject>>> raw = timestamp.isString() ? this.client.navigateKeysCriteriaTimestr(Collections.toList(keys), Language.translateToThriftCriteria(criteria), timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.navigateKeysCriteriaTime(Collections.toList(keys), Language.translateToThriftCriteria(criteria), timestamp.getMicros(), this.creds, this.transaction, this.environment);
            return Thrift.transformRecordsKeysValues(raw);
        });
    }

    @Override
    public <T> Map<Long, Map<String, Set<T>>> navigate(Collection<String> keys, long record) {
        return this.execute(() -> {
            Map<Long, Map<String, Set<TObject>>> raw = this.client.navigateKeysRecord(Collections.toList(keys), record, this.creds, this.transaction, this.environment);
            return Thrift.transformRecordsKeysValues(raw);
        });
    }

    @Override
    public <T> Map<Long, Map<String, Set<T>>> navigate(Collection<String> keys, long record, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, Map<String, Set<TObject>>> raw = timestamp.isString() ? this.client.navigateKeysRecordTimestr(Collections.toList(keys), record, timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.navigateKeysRecordTime(Collections.toList(keys), record, timestamp.getMicros(), this.creds, this.transaction, this.environment);
            return Thrift.transformRecordsKeysValues(raw);
        });
    }

    @Override
    public <T> Map<Long, Map<String, Set<T>>> navigate(Collection<String> keys, String ccl) {
        return this.execute(() -> {
            Map<Long, Map<String, Set<TObject>>> raw = this.client.navigateKeysCcl(Collections.toList(keys), ccl, this.creds, this.transaction, this.environment);
            return Thrift.transformRecordsKeysValues(raw);
        });
    }

    @Override
    public <T> Map<Long, Map<String, Set<T>>> navigate(Collection<String> keys, String ccl, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, Map<String, Set<TObject>>> raw = timestamp.isString() ? this.client.navigateKeysCclTimestr(Collections.toList(keys), ccl, timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.navigateKeysCclTime(Collections.toList(keys), ccl, timestamp.getMicros(), this.creds, this.transaction, this.environment);
            return Thrift.transformRecordsKeysValues(raw);
        });
    }

    @Override
    public <T> Map<Long, Set<T>> navigate(String key, Collection<Long> records) {
        return this.execute(() -> {
            Map<Long, Set<TObject>> raw = this.client.navigateKeyRecords(key, Collections.toLongList(records), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", LinkNavigation.getNavigationSchemeDestination(key));
            return Thrift.transformRecordsValues(raw, pretty);
        });
    }

    @Override
    public <T> Map<Long, Set<T>> navigate(String key, Collection<Long> records, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, Set<TObject>> raw = timestamp.isString() ? this.client.navigateKeyRecordsTimestr(key, Collections.toLongList(records), timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.navigateKeyRecordsTime(key, Collections.toLongList(records), timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", LinkNavigation.getNavigationSchemeDestination(key));
            return Thrift.transformRecordsValues(raw, pretty);
        });
    }

    @Override
    public <T> Map<Long, Set<T>> navigate(String key, Criteria criteria) {
        return this.execute(() -> {
            Map<Long, Set<TObject>> raw = this.client.navigateKeyCriteria(key, Language.translateToThriftCriteria(criteria), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", LinkNavigation.getNavigationSchemeDestination(key));
            return Thrift.transformRecordsValues(raw, pretty);
        });
    }

    @Override
    public <T> Map<Long, Set<T>> navigate(String key, Criteria criteria, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, Set<TObject>> raw = timestamp.isString() ? this.client.navigateKeyCriteriaTimestr(key, Language.translateToThriftCriteria(criteria), timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.navigateKeyCriteriaTime(key, Language.translateToThriftCriteria(criteria), timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", LinkNavigation.getNavigationSchemeDestination(key));
            return Thrift.transformRecordsValues(raw, pretty);
        });
    }

    @Override
    public <T> Map<Long, Set<T>> navigate(String key, long record) {
        return this.execute(() -> {
            Map<Long, Set<TObject>> raw = this.client.navigateKeyRecord(key, record, this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", LinkNavigation.getNavigationSchemeDestination(key));
            return Thrift.transformRecordsValues(raw, pretty);
        });
    }

    @Override
    public <T> Map<Long, Set<T>> navigate(String key, long record, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, Set<TObject>> raw = timestamp.isString() ? this.client.navigateKeyRecordTimestr(key, record, timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.navigateKeyRecordTime(key, record, timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", LinkNavigation.getNavigationSchemeDestination(key));
            return Thrift.transformRecordsValues(raw, pretty);
        });
    }

    @Override
    public <T> Map<Long, Set<T>> navigate(String key, String ccl) {
        return this.execute(() -> {
            Map<Long, Set<TObject>> raw = this.client.navigateKeyCcl(key, ccl, this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", LinkNavigation.getNavigationSchemeDestination(key));
            return Thrift.transformRecordsValues(raw, pretty);
        });
    }

    @Override
    public <T> Map<Long, Set<T>> navigate(String key, String ccl, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, Set<TObject>> raw = timestamp.isString() ? this.client.navigateKeyCclTimestr(key, ccl, timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.navigateKeyCclTime(key, ccl, timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", LinkNavigation.getNavigationSchemeDestination(key));
            return Thrift.transformRecordsValues(raw, pretty);
        });
    }

    @Override
    public Map<Long, Boolean> ping(Collection<Long> records) {
        return this.execute(() -> this.client.pingRecords(Collections.toLongList(records), this.creds, this.transaction, this.environment));
    }

    @Override
    public boolean ping(long record) {
        return this.execute(() -> this.client.pingRecord(record, this.creds, this.transaction, this.environment));
    }

    @Override
    public <T> void reconcile(String key, long record, Collection<T> values) {
        this.execute(() -> {
            HashSet valueSet = Sets.newHashSetWithExpectedSize((int)values.size());
            for (Object value : values) {
                valueSet.add(Convert.javaToThrift(value));
            }
            this.client.reconcileKeyRecordValues(key, record, valueSet, this.creds, this.transaction, this.environment);
            return null;
        });
    }

    @Override
    public <T> Map<Long, Boolean> remove(String key, T value, Collection<Long> records) {
        return this.execute(() -> {
            Map<Long, Boolean> raw = this.client.removeKeyValueRecords(key, Convert.javaToThrift(value), Collections.toLongList(records), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap<Long, Boolean> pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", "Result");
            Iterator iterator = records.iterator();
            while (iterator.hasNext()) {
                long record = (Long)iterator.next();
                pretty.put(record, raw.get(record));
            }
            return pretty;
        });
    }

    @Override
    public <T> boolean remove(String key, T value, long record) {
        return this.execute(() -> this.client.removeKeyValueRecord(key, Convert.javaToThrift(value), record, this.creds, this.transaction, this.environment));
    }

    @Override
    public void revert(Collection<String> keys, Collection<Long> records, Timestamp timestamp) {
        this.execute(() -> {
            if (timestamp.isString()) {
                this.client.revertKeysRecordsTimestr(Collections.toList(keys), Collections.toLongList(records), timestamp.toString(), this.creds, this.transaction, this.environment);
            } else {
                this.client.revertKeysRecordsTime(Collections.toList(keys), Collections.toLongList(records), timestamp.getMicros(), this.creds, this.transaction, this.environment);
            }
            return null;
        });
    }

    @Override
    public void revert(Collection<String> keys, long record, Timestamp timestamp) {
        this.execute(() -> {
            if (timestamp.isString()) {
                this.client.revertKeysRecordTimestr(Collections.toList(keys), record, timestamp.toString(), this.creds, this.transaction, this.environment);
            } else {
                this.client.revertKeysRecordTime(Collections.toList(keys), record, timestamp.getMicros(), this.creds, this.transaction, this.environment);
            }
            return null;
        });
    }

    @Override
    public void revert(String key, Collection<Long> records, Timestamp timestamp) {
        this.execute(() -> {
            if (timestamp.isString()) {
                this.client.revertKeyRecordsTimestr(key, Collections.toLongList(records), timestamp.toString(), this.creds, this.transaction, this.environment);
            } else {
                this.client.revertKeyRecordsTime(key, Collections.toLongList(records), timestamp.getMicros(), this.creds, this.transaction, this.environment);
            }
            return null;
        });
    }

    @Override
    public void revert(String key, long record, Timestamp timestamp) {
        this.execute(() -> {
            if (timestamp.isString()) {
                this.client.revertKeyRecordTimestr(key, record, timestamp.toString(), this.creds, this.transaction, this.environment);
            } else {
                this.client.revertKeyRecordTime(key, record, timestamp.getMicros(), this.creds, this.transaction, this.environment);
            }
            return null;
        });
    }

    @Override
    public Set<Long> search(String key, String query) {
        return this.execute(() -> this.client.search(key, query, this.creds, this.transaction, this.environment));
    }

    @Override
    public Map<Long, Map<String, Set<Object>>> select(Collection<Long> records) {
        return this.execute(() -> {
            Map<Long, Map<String, Set<TObject>>> raw = this.client.selectRecords(Collections.toLongList(records), this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap("Record");
            for (Map.Entry<Long, Map<String, Set<TObject>>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapSet(entry.getValue(), Conversions.none(), Conversions.thriftToJava()));
            }
            return pretty;
        });
    }

    @Override
    public Map<Long, Map<String, Set<Object>>> select(Collection<Long> records, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, Map<String, Set<TObject>>> raw = timestamp.isString() ? this.client.selectRecordsTimestr(Collections.toLongList(records), timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.selectRecordsTime(Collections.toLongList(records), timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap("Record");
            for (Map.Entry<Long, Map<String, Set<TObject>>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapSet(entry.getValue(), Conversions.none(), Conversions.thriftToJava()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, Map<String, Set<T>>> select(Collection<String> keys, Collection<Long> records) {
        return this.execute(() -> {
            Map<Long, Map<String, Set<TObject>>> raw = this.client.selectKeysRecords(Collections.toList(keys), Collections.toLongList(records), this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap("Record");
            for (Map.Entry<Long, Map<String, Set<TObject>>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapSet(entry.getValue(), Conversions.none(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, Map<String, Set<T>>> select(Collection<String> keys, Collection<Long> records, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, Map<String, Set<TObject>>> raw = timestamp.isString() ? this.client.selectKeysRecordsTimestr(Collections.toList(keys), Collections.toLongList(records), timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.selectKeysRecordsTime(Collections.toList(keys), Collections.toLongList(records), timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap("Record");
            for (Map.Entry<Long, Map<String, Set<TObject>>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapSet(entry.getValue(), Conversions.none(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, Map<String, Set<T>>> select(Collection<String> keys, Criteria criteria) {
        return this.execute(() -> {
            Map<Long, Map<String, Set<TObject>>> raw = this.client.selectKeysCriteria(Collections.toList(keys), Language.translateToThriftCriteria(criteria), this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap("Record");
            for (Map.Entry<Long, Map<String, Set<TObject>>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapSet(entry.getValue(), Conversions.none(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, Map<String, Set<T>>> select(Collection<String> keys, Criteria criteria, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, Map<String, Set<TObject>>> raw = timestamp.isString() ? this.client.selectKeysCriteriaTimestr(Collections.toList(keys), Language.translateToThriftCriteria(criteria), timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.selectKeysCriteriaTime(Collections.toList(keys), Language.translateToThriftCriteria(criteria), timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap("Record");
            for (Map.Entry<Long, Map<String, Set<TObject>>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapSet(entry.getValue(), Conversions.none(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<String, Set<T>> select(Collection<String> keys, long record) {
        return this.execute(() -> {
            Map<String, Set<TObject>> raw = this.client.selectKeysRecord(Collections.toList(keys), record, this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Key", "Values");
            for (Map.Entry<String, Set<TObject>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformSetLazily(entry.getValue(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<String, Set<T>> select(Collection<String> keys, long record, Timestamp timestamp) {
        return this.execute(() -> {
            Map<String, Set<TObject>> raw = timestamp.isString() ? this.client.selectKeysRecordTimestr(Collections.toList(keys), record, timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.selectKeysRecordTime(Collections.toList(keys), record, timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Key", "Values");
            for (Map.Entry<String, Set<TObject>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformSetLazily(entry.getValue(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, Map<String, Set<T>>> select(Collection<String> keys, Object criteria) {
        if (criteria instanceof BuildableState) {
            return this.select(keys, ((BuildableState)criteria).build());
        }
        throw new IllegalArgumentException(criteria + " is not a valid argument for the select method");
    }

    @Override
    public <T> Map<Long, Map<String, Set<T>>> select(Collection<String> keys, Object criteria, Timestamp timestamp) {
        if (criteria instanceof BuildableState) {
            return this.select(keys, ((BuildableState)criteria).build(), timestamp);
        }
        throw new IllegalArgumentException(criteria + " is not a valid argument for the select method");
    }

    @Override
    public <T> Map<Long, Map<String, Set<T>>> select(Collection<String> keys, String ccl) {
        return this.execute(() -> {
            Map<Long, Map<String, Set<TObject>>> raw = this.client.selectKeysCcl(Collections.toList(keys), ccl, this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap("Record");
            for (Map.Entry<Long, Map<String, Set<TObject>>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapSet(entry.getValue(), Conversions.none(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, Map<String, Set<T>>> select(Collection<String> keys, String ccl, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, Map<String, Set<TObject>>> raw = timestamp.isString() ? this.client.selectKeysCclTimestr(Collections.toList(keys), ccl, timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.selectKeysCclTime(Collections.toList(keys), ccl, timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap("Record");
            for (Map.Entry<Long, Map<String, Set<TObject>>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapSet(entry.getValue(), Conversions.none(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, Map<String, Set<T>>> select(Criteria criteria) {
        return this.execute(() -> {
            Map<Long, Map<String, Set<TObject>>> raw = this.client.selectCriteria(Language.translateToThriftCriteria(criteria), this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap("Record");
            for (Map.Entry<Long, Map<String, Set<TObject>>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapSet(entry.getValue(), Conversions.none(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, Map<String, Set<T>>> select(Criteria criteria, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, Map<String, Set<TObject>>> raw = timestamp.isString() ? this.client.selectCriteriaTimestr(Language.translateToThriftCriteria(criteria), timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.selectCriteriaTime(Language.translateToThriftCriteria(criteria), timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap("Record");
            for (Map.Entry<Long, Map<String, Set<TObject>>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapSet(entry.getValue(), Conversions.none(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public Map<String, Set<Object>> select(long record) {
        return this.execute(() -> {
            Map<String, Set<TObject>> raw = this.client.selectRecord(record, this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap<String, Set<Object>> pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Key", "Values");
            for (Map.Entry<String, Set<TObject>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformSetLazily(entry.getValue(), Conversions.thriftToJava()));
            }
            return pretty;
        });
    }

    @Override
    public Map<String, Set<Object>> select(long record, Timestamp timestamp) {
        return this.execute(() -> {
            Map<String, Set<TObject>> raw = timestamp.isString() ? this.client.selectRecordTimestr(record, timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.selectRecordTime(record, timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap<String, Set<Object>> pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Key", "Values");
            for (Map.Entry<String, Set<TObject>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformSetLazily(entry.getValue(), Conversions.thriftToJava()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, Map<String, Set<T>>> select(Object criteria) {
        if (criteria instanceof BuildableState) {
            return this.select(((BuildableState)criteria).build());
        }
        throw new IllegalArgumentException(criteria + " is not a valid argument for the get method");
    }

    @Override
    public <T> Map<Long, Map<String, Set<T>>> select(Object criteria, Timestamp timestamp) {
        if (criteria instanceof BuildableState) {
            return this.select(((BuildableState)criteria).build(), timestamp);
        }
        throw new IllegalArgumentException(criteria + " is not a valid argument for the get method");
    }

    @Override
    public <T> Map<Long, Map<String, Set<T>>> select(String ccl) {
        return this.execute(() -> {
            Map<Long, Map<String, Set<TObject>>> raw = this.client.selectCcl(ccl, this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap("Record");
            for (Map.Entry<Long, Map<String, Set<TObject>>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapSet(entry.getValue(), Conversions.none(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, Set<T>> select(String key, Collection<Long> records) {
        return this.execute(() -> {
            Map<Long, Set<TObject>> raw = this.client.selectKeyRecords(key, Collections.toLongList(records), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", key);
            for (Map.Entry<Long, Set<TObject>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformSetLazily(entry.getValue(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, Set<T>> select(String key, Collection<Long> records, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, Set<TObject>> raw = timestamp.isString() ? this.client.selectKeyRecordsTimestr(key, Collections.toLongList(records), timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.selectKeyRecordsTime(key, Collections.toLongList(records), timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", key);
            for (Map.Entry<Long, Set<TObject>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformSetLazily(entry.getValue(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, Set<T>> select(String key, Criteria criteria) {
        return this.execute(() -> {
            Map<Long, Set<TObject>> raw = this.client.selectKeyCriteria(key, Language.translateToThriftCriteria(criteria), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", key);
            for (Map.Entry<Long, Set<TObject>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformSetLazily(entry.getValue(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, Set<T>> select(String key, Criteria criteria, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, Set<TObject>> raw = timestamp.isString() ? this.client.selectKeyCriteriaTimestr(key, Language.translateToThriftCriteria(criteria), timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.selectKeyCriteriaTime(key, Language.translateToThriftCriteria(criteria), timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", key);
            for (Map.Entry<Long, Set<TObject>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformSetLazily(entry.getValue(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Set<T> select(String key, long record) {
        return this.execute(() -> {
            Set<TObject> values = this.client.selectKeyRecord(key, record, this.creds, this.transaction, this.environment);
            return Transformers.transformSetLazily(values, Conversions.thriftToJavaCasted());
        });
    }

    @Override
    public <T> Set<T> select(String key, long record, Timestamp timestamp) {
        return this.execute(() -> {
            Set<TObject> values = timestamp.isString() ? this.client.selectKeyRecordTimestr(key, record, timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.selectKeyRecordTime(key, record, timestamp.getMicros(), this.creds, this.transaction, this.environment);
            return Transformers.transformSetLazily(values, Conversions.thriftToJavaCasted());
        });
    }

    @Override
    public <T> Map<Long, Set<T>> select(String key, Object criteria) {
        if (criteria instanceof BuildableState) {
            return this.select(key, ((BuildableState)criteria).build());
        }
        throw new IllegalArgumentException(criteria + " is not a valid argument for the select method");
    }

    @Override
    public <T> Map<Long, Set<T>> select(String key, Object criteria, Timestamp timestamp) {
        if (criteria instanceof BuildableState) {
            return this.select(key, ((BuildableState)criteria).build(), timestamp);
        }
        throw new IllegalArgumentException(criteria + " is not a valid argument for the select method");
    }

    @Override
    public <T> Map<Long, Set<T>> select(String key, String ccl) {
        return this.execute(() -> {
            Map<Long, Set<TObject>> raw = this.client.selectKeyCcl(key, ccl, this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", key);
            for (Map.Entry<Long, Set<TObject>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformSetLazily(entry.getValue(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, Set<T>> select(String key, String ccl, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, Set<TObject>> raw = timestamp.isString() ? this.client.selectKeyCclTimestr(key, ccl, timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.selectKeyCclTime(key, ccl, timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedHashMap pretty = PrettyLinkedHashMap.newPrettyLinkedHashMap("Record", key);
            for (Map.Entry<Long, Set<TObject>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformSetLazily(entry.getValue(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public <T> Map<Long, Map<String, Set<T>>> select(String ccl, Timestamp timestamp) {
        return this.execute(() -> {
            Map<Long, Map<String, Set<TObject>>> raw = timestamp.isString() ? this.client.selectCclTimestr(ccl, timestamp.toString(), this.creds, this.transaction, this.environment) : this.client.selectCclTime(ccl, timestamp.getMicros(), this.creds, this.transaction, this.environment);
            PrettyLinkedTableMap pretty = PrettyLinkedTableMap.newPrettyLinkedTableMap("Record");
            for (Map.Entry<Long, Map<String, Set<TObject>>> entry : raw.entrySet()) {
                pretty.put(entry.getKey(), Transformers.transformMapSet(entry.getValue(), Conversions.none(), Conversions.thriftToJavaCasted()));
            }
            return pretty;
        });
    }

    @Override
    public void set(String key, Object value, Collection<Long> records) {
        this.execute(() -> {
            this.client.setKeyValueRecords(key, Convert.javaToThrift(value), Collections.toLongList(records), this.creds, this.transaction, this.environment);
            return null;
        });
    }

    @Override
    public <T> void set(String key, T value, long record) {
        this.execute(() -> {
            this.client.setKeyValueRecord(key, Convert.javaToThrift(value), record, this.creds, this.transaction, this.environment);
            return null;
        });
    }

    @Override
    public void stage() throws com.cinchapi.concourse.TransactionException {
        this.execute(() -> {
            this.transaction = this.client.stage(this.creds, this.environment);
            return null;
        });
    }

    @Override
    public Timestamp time() {
        return this.execute(() -> Timestamp.fromMicros(this.client.time(this.creds, this.transaction, this.environment)));
    }

    @Override
    public Timestamp time(String phrase) {
        return this.execute(() -> Timestamp.fromMicros(this.client.timePhrase(phrase, this.creds, this.transaction, this.environment)));
    }

    public String toString() {
        return "Connected to " + this.host + ":" + this.port + " as " + new String(ClientSecurity.decrypt(this.username).array());
    }

    @Override
    public boolean unlink(String key, long destination, long source) {
        return this.remove(key, Link.to(destination), source);
    }

    @Override
    public boolean verify(String key, Object value, long record) {
        return this.execute(() -> this.client.verifyKeyValueRecord(key, Convert.javaToThrift(value), record, this.creds, this.transaction, this.environment));
    }

    @Override
    public boolean verify(String key, Object value, long record, Timestamp timestamp) {
        return this.execute(() -> {
            if (timestamp.isString()) {
                return this.client.verifyKeyValueRecordTimestr(key, Convert.javaToThrift(value), record, timestamp.toString(), this.creds, this.transaction, this.environment);
            }
            return this.client.verifyKeyValueRecordTime(key, Convert.javaToThrift(value), record, timestamp.getMicros(), this.creds, this.transaction, this.environment);
        });
    }

    @Override
    public boolean verifyAndSwap(String key, Object expected, long record, Object replacement) {
        return this.execute(() -> this.client.verifyAndSwap(key, Convert.javaToThrift(expected), record, Convert.javaToThrift(replacement), this.creds, this.transaction, this.environment));
    }

    @Override
    public void verifyOrSet(String key, Object value, long record) {
        this.execute(() -> {
            this.client.verifyOrSet(key, Convert.javaToThrift(value), record, this.creds, this.transaction, this.environment);
            return null;
        });
    }

    AccessToken creds() {
        return this.creds;
    }

    String environment() {
        return this.environment;
    }

    <T> T execute(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (SecurityException e) {
            this.authenticate();
            return this.execute(callable);
        }
        catch (TransactionException e) {
            throw new com.cinchapi.concourse.TransactionException();
        }
        catch (DuplicateEntryException e) {
            throw new com.cinchapi.concourse.DuplicateEntryException(e);
        }
        catch (com.cinchapi.concourse.thrift.InvalidArgumentException e) {
            throw new InvalidArgumentException(e);
        }
        catch (com.cinchapi.concourse.thrift.ParseException e) {
            throw new ParseException(e);
        }
        catch (com.cinchapi.concourse.thrift.PermissionException e) {
            throw new PermissionException(e);
        }
        catch (com.cinchapi.concourse.thrift.ManagementException e) {
            throw new ManagementException(e);
        }
        catch (Exception e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    ConcourseService.Client thrift() {
        return this.client;
    }

    @Nullable
    TransactionToken transaction() {
        return this.transaction;
    }

    @Override
    protected Concourse copyConnection() {
        return new ConcourseThriftDriver(this.host, this.port, ByteBuffers.getString(ClientSecurity.decrypt(this.username)), ByteBuffers.getString(ClientSecurity.decrypt(this.password)), this.environment);
    }

    private void authenticate() {
        try {
            this.creds = this.client.login(ClientSecurity.decrypt(this.username), ClientSecurity.decrypt(this.password), this.environment);
        }
        catch (TException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)((Object)e));
        }
    }

    private Set<Long> executeFind(String key, Object operator, Object ... values) {
        List tValues = Lists.transform((List)Lists.newArrayList((Object[])values), Conversions.javaToThrift());
        return this.execute(() -> {
            if (operator instanceof Operator) {
                return this.client.findKeyOperatorValues(key, (Operator)((Object)((Object)operator)), tValues, this.creds, this.transaction, this.environment);
            }
            return this.client.findKeyOperatorstrValues(key, operator.toString(), tValues, this.creds, this.transaction, this.environment);
        });
    }

    private Set<Long> executeFind(Timestamp timestamp, String key, Object operator, Object ... values) {
        List tValues = Lists.transform((List)Lists.newArrayList((Object[])values), Conversions.javaToThrift());
        return this.execute(() -> {
            if (operator instanceof Operator) {
                return this.client.findKeyOperatorValuesTime(key, (Operator)((Object)((Object)operator)), tValues, timestamp.getMicros(), this.creds, this.transaction, this.environment);
            }
            return this.client.findKeyOperatorstrValuesTime(key, operator.toString(), tValues, timestamp.getMicros(), this.creds, this.transaction, this.environment);
        });
    }

    static {
        ConcourseClientPreferences config;
        try {
            config = ConcourseClientPreferences.open("concourse_client.prefs");
        }
        catch (Exception e) {
            config = null;
        }
        SERVER_HOST = "localhost";
        SERVER_PORT = 1717;
        USERNAME = "admin";
        PASSWORD = "admin";
        ENVIRONMENT = "";
        if (config != null) {
            SERVER_HOST = config.getString("host", SERVER_HOST);
            SERVER_PORT = config.getInt("port", SERVER_PORT);
            USERNAME = config.getString("username", USERNAME);
            PASSWORD = config.getString("password", PASSWORD);
            ENVIRONMENT = config.getString("environment", ENVIRONMENT);
        }
    }
}

