/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse;

import com.cinchapi.concourse.CachedConnectionPool;
import com.cinchapi.concourse.Concourse;
import com.cinchapi.concourse.FixedConnectionPool;
import com.cinchapi.concourse.config.ConcourseClientPreferences;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class ConnectionPool
implements AutoCloseable {
    protected static final int DEFAULT_POOL_SIZE = 10;
    private static final String DEFAULT_PREFS_FILE = "concourse_client.prefs";
    protected final Queue<Concourse> available;
    private final Set<Concourse> leased;
    private AtomicBoolean open = new AtomicBoolean(true);

    public static ConnectionPool newCachedConnectionPool() {
        return ConnectionPool.newCachedConnectionPool(DEFAULT_PREFS_FILE);
    }

    public static ConnectionPool newCachedConnectionPool(String prefs) {
        ConcourseClientPreferences cp = ConcourseClientPreferences.open(prefs);
        return new CachedConnectionPool(cp.getHost(), cp.getPort(), cp.getUsername(), new String(cp.getPassword()), cp.getEnvironment(), 10);
    }

    public static ConnectionPool newCachedConnectionPool(String host, int port, String username, String password) {
        return new CachedConnectionPool(host, port, username, password, 10);
    }

    public static ConnectionPool newCachedConnectionPool(String host, int port, String username, String password, String environment) {
        return new CachedConnectionPool(host, port, username, password, environment, 10);
    }

    @Deprecated
    public static ConnectionPool newConnectionPool(String prefs) {
        return ConnectionPool.newFixedConnectionPool(prefs, 10);
    }

    @Deprecated
    public static ConnectionPool newConnectionPool(String prefs, int poolSize) {
        return ConnectionPool.newFixedConnectionPool(prefs, poolSize);
    }

    @Deprecated
    public static ConnectionPool newConnectionPool(String host, int port, String username, String password) {
        return ConnectionPool.newFixedConnectionPool(host, port, username, password, 10);
    }

    @Deprecated
    public static ConnectionPool newConnectionPool(String host, int port, String username, String password, int poolSize) {
        return ConnectionPool.newFixedConnectionPool(host, port, username, password, poolSize);
    }

    public static ConnectionPool newFixedConnectionPool(int poolSize) {
        return ConnectionPool.newFixedConnectionPool(DEFAULT_PREFS_FILE, poolSize);
    }

    public static ConnectionPool newFixedConnectionPool(String prefs, int poolSize) {
        ConcourseClientPreferences cp = ConcourseClientPreferences.open(prefs);
        return new FixedConnectionPool(cp.getHost(), cp.getPort(), cp.getUsername(), new String(cp.getPassword()), cp.getEnvironment(), poolSize);
    }

    public static ConnectionPool newFixedConnectionPool(String host, int port, String username, String password, int poolSize) {
        return new FixedConnectionPool(host, port, username, password, poolSize);
    }

    public static ConnectionPool newFixedConnectionPool(String host, int port, String username, String password, String environment, int poolSize) {
        return new FixedConnectionPool(host, port, username, password, environment, poolSize);
    }

    protected ConnectionPool(String host, int port, String username, String password, int poolSize) {
        this(host, port, username, password, "", poolSize);
    }

    protected ConnectionPool(String host, int port, String username, String password, String environment, int poolSize) {
        this.available = this.buildQueue(poolSize);
        this.leased = Collections.newSetFromMap(Maps.newConcurrentMap());
        for (int i = 0; i < poolSize; ++i) {
            this.available.offer(Concourse.connect(host, port, username, password, environment));
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                ConnectionPool.this.forceClose();
            }
        }));
    }

    @Override
    public void close() throws Exception {
        Preconditions.checkState((boolean)this.isClosable(), (Object)"Cannot shutdown the connection pool until all the connections have been returned");
        if (!this.open.compareAndSet(true, false)) {
            throw new IllegalStateException("Connection pool is closed");
        }
        this.exitAllConnections();
    }

    public boolean hasAvailableConnection() {
        this.verifyOpenState();
        return this.available.peek() != null;
    }

    public boolean isClosed() {
        return !this.open.get();
    }

    public void release(Concourse connection) {
        this.verifyOpenState();
        this.verifyValidOrigin(connection);
        this.available.offer(connection);
        this.leased.remove(connection);
    }

    public Concourse request() {
        this.verifyOpenState();
        Concourse connection = this.getConnection();
        this.leased.add(connection);
        return connection;
    }

    protected abstract Queue<Concourse> buildQueue(int var1);

    protected void forceClose() {
        if (this.open.compareAndSet(true, false)) {
            this.exitConnections(this.available);
            this.exitConnections(this.leased);
        }
    }

    protected abstract Concourse getConnection();

    private void exitAllConnections() {
        this.exitConnections(this.available);
    }

    private void exitConnections(Iterable<Concourse> connections) {
        for (Concourse concourse : connections) {
            boolean exited = false;
            while (!exited) {
                try {
                    concourse.exit();
                    exited = true;
                }
                catch (Exception e) {
                    exited = false;
                }
            }
        }
    }

    private boolean isClosable() {
        return this.leased.isEmpty();
    }

    private void verifyOpenState() {
        Preconditions.checkState((boolean)this.open.get(), (Object)"Connection pool is closed");
    }

    private void verifyValidOrigin(Concourse connection) {
        if (!this.leased.contains(connection)) {
            throw new IllegalArgumentException("Cannot release the connection because it was not previously requested from this pool");
        }
    }
}

