/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse;

import com.cinchapi.common.base.CheckedExceptions;
import com.cinchapi.concourse.Concourse;
import com.cinchapi.concourse.ConnectionPool;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

class FixedConnectionPool
extends ConnectionPool {
    protected FixedConnectionPool(String host, int port, String username, String password, int poolSize) {
        super(host, port, username, password, poolSize);
    }

    protected FixedConnectionPool(String host, int port, String username, String password, String environment, int poolSize) {
        super(host, port, username, password, environment, poolSize);
    }

    @Override
    protected Queue<Concourse> buildQueue(int size) {
        return new ArrayBlockingQueue<Concourse>(size);
    }

    @Override
    protected Concourse getConnection() {
        try {
            return (Concourse)((BlockingQueue)this.available).take();
        }
        catch (InterruptedException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }
}

