/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse;

import com.cinchapi.concourse.lang.BuildableState;
import com.cinchapi.concourse.lang.Criteria;
import com.cinchapi.concourse.util.Convert;
import com.cinchapi.concourse.util.Strings;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import com.google.common.primitives.UnsignedLongs;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Link
extends Number
implements Comparable<Link> {
    private static final long serialVersionUID = 1L;
    private final long record;

    public static Link to(long record) {
        return new Link(record);
    }

    public static String toWhere(String ccl) {
        return Convert.stringToResolvableLinkInstruction(ccl);
    }

    public static String toWhere(Criteria criteria) {
        return Link.toWhere(criteria.getCclString());
    }

    public static String toWhere(Object criteria) {
        Preconditions.checkArgument((boolean)(criteria instanceof BuildableState), (Object)Strings.format("{} is not a valid criteria", criteria));
        return Link.toWhere(((BuildableState)criteria).build());
    }

    private Link(long record) {
        this.record = record;
    }

    @Override
    public int compareTo(Link other) {
        return UnsignedLongs.compare((long)this.longValue(), (long)other.longValue());
    }

    @Override
    public double doubleValue() {
        return this.record;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Link) {
            Link other = (Link)obj;
            return UnsignedLongs.compare((long)this.record, (long)other.record) == 0;
        }
        return false;
    }

    @Override
    public float floatValue() {
        return this.record;
    }

    public int hashCode() {
        return Longs.hashCode((long)this.record);
    }

    @Override
    public int intValue() {
        return (int)this.record;
    }

    @Override
    public long longValue() {
        return this.record;
    }

    public String toString() {
        return "@" + UnsignedLongs.toString((long)this.longValue());
    }
}

