/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse;

import com.cinchapi.concourse.annotate.PackagePrivate;
import com.cinchapi.concourse.time.Time;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Immutable
@ThreadSafe
public final class Timestamp {
    public static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormat.forPattern((String)"E MMM dd, yyyy @ h:mm:ss:SS a z");
    public static final DateTimeFormatter DEFAULT_DATE_ONLY_FORMATTER = DateTimeFormat.forPattern((String)"E MMM dd, yyyy");
    private final String description;
    private final DateTime joda;
    private final long microseconds;

    public static Timestamp epoch() {
        return Timestamp.fromMicros(-1L);
    }

    public static Timestamp fromJoda(DateTime joda) {
        return new Timestamp(joda);
    }

    public static Timestamp fromMicros(long microseconds) {
        return new Timestamp(microseconds);
    }

    public static Timestamp fromString(String description) {
        return new Timestamp(description);
    }

    public static Timestamp fromInstant(Instant instant) {
        return new Timestamp(TimeUnit.MILLISECONDS.toMicros(instant.toEpochMilli()));
    }

    public static Timestamp now() {
        return new Timestamp(Time.now());
    }

    public static Timestamp now(Chronology chronology) {
        long microseconds = Time.now();
        return new Timestamp(microseconds, new DateTime(TimeUnit.MILLISECONDS.convert(microseconds, TimeUnit.MICROSECONDS), chronology));
    }

    public static Timestamp now(DateTimeZone zone) {
        long microseconds = Time.now();
        return new Timestamp(microseconds, new DateTime(TimeUnit.MILLISECONDS.convert(microseconds, TimeUnit.MICROSECONDS), zone));
    }

    public static Timestamp parse(String str, DateTimeFormatter formatter) {
        return new Timestamp(DateTime.parse((String)str, (DateTimeFormatter)formatter));
    }

    public static Timestamp parse(String str, String format) {
        return Timestamp.parse(str, DateTimeFormat.forPattern((String)format));
    }

    private Timestamp(DateTime joda) {
        this.joda = joda;
        this.microseconds = TimeUnit.MICROSECONDS.convert(joda.getMillis(), TimeUnit.MILLISECONDS);
        this.description = null;
    }

    private Timestamp(long microseconds) {
        this.microseconds = microseconds;
        this.joda = new DateTime(TimeUnit.MILLISECONDS.convert(microseconds, TimeUnit.MICROSECONDS));
        this.description = null;
    }

    private Timestamp(long microseconds, DateTime joda) {
        this.microseconds = microseconds;
        this.joda = joda;
        this.description = null;
    }

    private Timestamp(String description) {
        this.microseconds = 0L;
        this.joda = null;
        this.description = description;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Timestamp && !this.isString()) {
            return Longs.compare((long)this.microseconds, (long)((Timestamp)obj).microseconds) == 0;
        }
        return false;
    }

    public DateTime getJoda() {
        Preconditions.checkState((!this.isString() ? 1 : 0) != 0, (Object)"Only Concourse Server can parse a DateTime from a Timestamp created from a string.");
        return this.joda;
    }

    public long getMicros() {
        Preconditions.checkState((!this.isString() ? 1 : 0) != 0, (Object)"Only Concourse Server can parse microseconds from a Timestamp created from a string.");
        return this.microseconds;
    }

    public Instant getInstant() {
        return Instant.ofEpochMilli(TimeUnit.MICROSECONDS.toMillis(this.microseconds));
    }

    public int hashCode() {
        return this.isString() ? this.description.hashCode() : Longs.hashCode((long)this.microseconds);
    }

    public boolean isDateOnly() {
        DateTime joda = this.getJoda();
        return joda.getMillisOfDay() == 0;
    }

    public String toString() {
        return this.isString() ? this.description : this.joda.toString(this.isDateOnly() ? DEFAULT_DATE_ONLY_FORMATTER : DEFAULT_FORMATTER);
    }

    @PackagePrivate
    boolean isString() {
        return this.description != null;
    }
}

