/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.cache;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import javax.annotation.Nullable;

public class ReferenceCache<T> {
    private static final int INITIAL_CAPACITY = 500000;
    private static final int CONCURRENCY_LEVEL = 16;
    private final Cache<HashCode, T> cache = CacheBuilder.newBuilder().initialCapacity(500000).concurrencyLevel(16).softValues().build();

    @Nullable
    public T get(Object ... args) {
        HashCode id = this.getCacheKey(args);
        return (T)this.cache.getIfPresent((Object)id);
    }

    public void put(T value, Object ... args) {
        Preconditions.checkNotNull(value);
        Preconditions.checkNotNull((Object)args);
        Preconditions.checkArgument((args.length > 0 ? 1 : 0) != 0, (Object)"You must specify at least one key");
        HashCode id = this.getCacheKey(args);
        this.cache.put((Object)id, value);
    }

    public void remove(Object ... args) {
        this.cache.invalidate((Object)this.getCacheKey(args));
    }

    private HashCode getCacheKey(Object ... args) {
        StringBuilder key = new StringBuilder();
        for (Object o : args) {
            key.append(o.hashCode());
            key.append(o.getClass().getName());
        }
        return Hashing.md5().hashUnencodedChars((CharSequence)key.toString());
    }
}

