/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.config;

import com.cinchapi.common.base.CheckedExceptions;
import com.cinchapi.concourse.config.PreferencesHandler;
import com.cinchapi.concourse.util.Logging;
import org.apache.commons.configuration.ConfigurationException;

public class ConcourseClientPreferences
extends PreferencesHandler {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 1717;
    private static final String DEFAULT_USERNAME = "admin";
    private static final String DEFAULT_PASSWORD = "admin";
    private static final String DEFAULT_ENVIRONMENT = "";
    protected static final char[] NO_PASSWORD_DEFINED;

    public static ConcourseClientPreferences open(String file) {
        try {
            return new ConcourseClientPreferences(file);
        }
        catch (ConfigurationException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)((Object)e));
        }
    }

    private ConcourseClientPreferences(String file) throws ConfigurationException {
        super(file);
    }

    public String getEnvironment() {
        return this.getString("environment", DEFAULT_ENVIRONMENT);
    }

    public String getHost() {
        return this.getString("host", DEFAULT_HOST);
    }

    public char[] getPassword() {
        return this.getString("password", "admin").toCharArray();
    }

    public char[] getPasswordExplicit() {
        String password = this.getString("password");
        if (password != null) {
            return password.toCharArray();
        }
        return NO_PASSWORD_DEFINED;
    }

    public int getPort() {
        return this.getInt("port", 1717);
    }

    public String getUsername() {
        return this.getString("username", "admin");
    }

    public void setEnvironment(String environment) {
        this.setProperty("environment", environment);
    }

    public void setHost(String host) {
        this.setProperty("host", host);
    }

    public void setPassword(char[] password) {
        this.setProperty("password", new String(password));
    }

    public void setPort(int port) {
        this.setProperty("port", port);
    }

    public void setUsername(String username) {
        this.setProperty("username", username);
    }

    static {
        Logging.disable(ConcourseClientPreferences.class);
        NO_PASSWORD_DEFINED = new char[0];
    }
}

