/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.config;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.cinchapi.common.base.CheckedExceptions;
import com.cinchapi.concourse.config.PreferencesHandler;
import java.io.File;
import org.apache.commons.configuration.ConfigurationException;
import org.slf4j.LoggerFactory;

public class ConcourseServerPreferences
extends PreferencesHandler {
    private static String DEFAULT_DATA_HOME;
    private static String DEFAULT_BUFFER_DIRECTORY;
    private static String DEFAULT_DATABASE_DIRECTORY;
    private static int DEFAULT_BUFFER_PAGE_SIZE;
    private static Level DEFAULT_LOG_LEVEL;
    private static boolean DEFAULT_ENABLE_CONSOLE_LOGGING;
    private static int DEFAULT_CLIENT_PORT;
    private static int DEFAULT_SHUTDOWN_PORT;
    private static int DEFAULT_JMX_PORT;
    private static String DEFAULT_DEFAULT_ENVIRONMENT;

    public static ConcourseServerPreferences open(String file) {
        try {
            return new ConcourseServerPreferences(file);
        }
        catch (ConfigurationException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)((Object)e));
        }
    }

    private ConcourseServerPreferences(String file) throws ConfigurationException {
        super(file);
    }

    public String getBufferDirectory() {
        return this.getString("buffer_directory", DEFAULT_BUFFER_DIRECTORY);
    }

    public long getBufferPageSize() {
        return this.getSize("buffer_page_size", DEFAULT_BUFFER_PAGE_SIZE);
    }

    public int getClientPort() {
        return this.getInt("client_port", DEFAULT_CLIENT_PORT);
    }

    public String getDatabaseDirectory() {
        return this.getString("database_directory", DEFAULT_DATABASE_DIRECTORY);
    }

    public String getDefaultEnvironment() {
        return this.getString("default_environment", DEFAULT_DEFAULT_ENVIRONMENT);
    }

    public boolean getEnableConsoleLogging() {
        return this.getBoolean("enable_console_logging", DEFAULT_ENABLE_CONSOLE_LOGGING);
    }

    public int getJmxPort() {
        return this.getInt("jmx_port", DEFAULT_JMX_PORT);
    }

    public Level getLogLevel() {
        return Level.valueOf((String)this.getString("log_level", DEFAULT_LOG_LEVEL.toString()));
    }

    public int getShutdownPort() {
        return this.getInt("shutdown_port", DEFAULT_SHUTDOWN_PORT);
    }

    public void setBufferDirectory(String bufferDirectory) {
        this.setProperty("buffer_directory", bufferDirectory);
    }

    public void setBufferPageSize(long sizeInBytes) {
        this.setProperty("buffer_page_size", sizeInBytes);
    }

    public void setClientPort(int clientPort) {
        this.setProperty("client_port", clientPort);
    }

    public void setDatabaseDirectory(String databaseDirectory) {
        this.setProperty("database_directory", databaseDirectory);
    }

    public void setDefaultEnvironment(String defaultEnvironment) {
        this.setProperty("default_environment", defaultEnvironment);
    }

    public void setEnableConsoleLogging(boolean enableConsoleLogging) {
        this.setProperty("enable_console_logging", enableConsoleLogging);
    }

    public void setJmxPort(int port) {
        this.setProperty("jmx_port", port);
    }

    public void setLogLevel(Level level) {
        this.setProperty("log_level", level.toString());
    }

    public void setShutdownPort(int shutdownPort) {
        this.setProperty("shutdown_port", shutdownPort);
    }

    static {
        ((Logger)LoggerFactory.getLogger(ConcourseServerPreferences.class)).setLevel(Level.OFF);
        DEFAULT_DATA_HOME = System.getProperty("user.home") + File.separator + "concourse" + File.separator;
        DEFAULT_BUFFER_DIRECTORY = DEFAULT_DATA_HOME + "buffer";
        DEFAULT_DATABASE_DIRECTORY = DEFAULT_DATA_HOME + "db";
        DEFAULT_BUFFER_PAGE_SIZE = 8192;
        DEFAULT_LOG_LEVEL = Level.INFO;
        DEFAULT_ENABLE_CONSOLE_LOGGING = false;
        DEFAULT_CLIENT_PORT = 1717;
        DEFAULT_SHUTDOWN_PORT = 3434;
        DEFAULT_JMX_PORT = 9010;
        DEFAULT_DEFAULT_ENVIRONMENT = "default";
    }
}

