/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.config;

import com.cinchapi.concourse.util.Logging;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.DefaultFileSystem;
import org.apache.commons.configuration.PropertiesConfiguration;

public class PreferencesHandler
extends PropertiesConfiguration {
    private static Map<String, Integer> multipliers = new HashMap<String, Integer>(){
        private static final long serialVersionUID = 1L;

        @Override
        public Integer get(Object key) {
            if (key instanceof String) {
                key = ((String)key).toLowerCase();
            }
            return (Integer)super.get(key);
        }

        @Override
        public Integer put(String key, Integer value) {
            key = key.toLowerCase();
            return super.put(key, value);
        }
    };

    protected PreferencesHandler(String file) throws ConfigurationException {
        super(file);
        this.setAutoSave(true);
    }

    public long getSize(String key, long defaultValue) {
        String value = this.getString(key, null);
        if (value != null) {
            String[] parts = value.split("(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)");
            long base = Long.parseLong(parts[0]);
            int multiplier = parts.length > 1 ? multipliers.get(parts[1]).intValue() : multipliers.get("b").intValue();
            return base * (long)multiplier;
        }
        return defaultValue;
    }

    public <T extends Enum<T>> T getEnum(String key, T defaultValue) {
        String value = this.getString(key, null);
        if (value != null) {
            try {
                defaultValue = Enum.valueOf(defaultValue.getClass(), value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    static {
        multipliers.put("b", (int)Math.pow(1024.0, 0.0));
        multipliers.put("k", (int)Math.pow(1024.0, 1.0));
        multipliers.put("kb", (int)Math.pow(1024.0, 1.0));
        multipliers.put("m", (int)Math.pow(1024.0, 2.0));
        multipliers.put("mb", (int)Math.pow(1024.0, 2.0));
        multipliers.put("g", (int)Math.pow(1024.0, 3.0));
        multipliers.put("gb", (int)Math.pow(1024.0, 3.0));
        Logging.disable(PreferencesHandler.class);
        Logging.disable(ConfigurationUtils.class);
        Logging.disable(DefaultFileSystem.class);
    }
}

