/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.lang;

import com.cinchapi.ccl.Parser;
import com.cinchapi.ccl.Parsing;
import com.cinchapi.ccl.SyntaxException;
import com.cinchapi.ccl.grammar.Expression;
import com.cinchapi.ccl.grammar.ParenthesisSymbol;
import com.cinchapi.ccl.grammar.Symbol;
import com.cinchapi.ccl.grammar.TimestampSymbol;
import com.cinchapi.common.base.CheckedExceptions;
import com.cinchapi.common.reflect.Reflection;
import com.cinchapi.concourse.ParseException;
import com.cinchapi.concourse.Timestamp;
import com.cinchapi.concourse.lang.StartState;
import com.cinchapi.concourse.util.Parsers;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Criteria
implements Symbol {
    private boolean built = false;
    private List<Symbol> symbols = Lists.newArrayList();

    public static Criteria parse(String ccl) {
        Parser parser = Parsers.create(ccl);
        Criteria criteria = new Criteria();
        try {
            criteria.symbols = Lists.newArrayList((Iterable)parser.tokenize());
            return criteria;
        }
        catch (Exception e) {
            if (e instanceof SyntaxException || e instanceof IllegalStateException || e.getCause() != null && e.getCause() instanceof com.cinchapi.ccl.v2.generated.ParseException) {
                throw new ParseException(new com.cinchapi.concourse.thrift.ParseException(e.getMessage()));
            }
            throw CheckedExceptions.throwAsRuntimeException((Exception)e);
        }
    }

    public static StartState where() {
        return new StartState(new Criteria());
    }

    protected Criteria() {
    }

    public Criteria at(Timestamp timestamp) {
        Parser parser = Parsers.create(this.getCclString());
        List symbols = Parsing.groupExpressions((List)parser.tokenize());
        TimestampSymbol ts = new TimestampSymbol(timestamp.getMicros());
        symbols.forEach(symbol -> {
            if (symbol instanceof Expression) {
                Expression expression = (Expression)symbol;
                Reflection.set((String)"timestamp", (Object)ts, (Object)expression);
            }
        });
        Criteria criteria = new Criteria();
        criteria.symbols = symbols = Parsing.ungroupExpressions((List)symbols);
        return criteria;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Criteria) {
            return Objects.equals(this.symbols, ((Criteria)obj).symbols);
        }
        return false;
    }

    public String getCclString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Symbol symbol : this.symbols) {
            if (!first) {
                sb.append(" ");
            }
            sb.append(symbol);
            first = false;
        }
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.symbols);
    }

    public String toString() {
        return this.getCclString();
    }

    protected void add(Symbol symbol) {
        Preconditions.checkState((!this.built ? 1 : 0) != 0, (Object)"Cannot add a symbol to a built Criteria");
        this.symbols.add(symbol);
    }

    protected void close() {
        this.built = !this.built ? true : this.built;
        ArrayList expanded = Lists.newArrayList();
        this.expand(this.symbols, expanded);
        this.symbols = expanded;
    }

    protected List<Symbol> getSymbols() {
        return Collections.unmodifiableList(this.symbols);
    }

    private void expand(List<Symbol> symbols, List<Symbol> expanded) {
        for (Symbol symbol : symbols) {
            if (symbol instanceof Criteria) {
                expanded.add((Symbol)ParenthesisSymbol.LEFT);
                this.expand(((Criteria)symbol).symbols, expanded);
                expanded.add((Symbol)ParenthesisSymbol.RIGHT);
                continue;
            }
            expanded.add(symbol);
        }
    }
}

