/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.lang;

import com.cinchapi.ccl.grammar.ConjunctionSymbol;
import com.cinchapi.ccl.grammar.KeySymbol;
import com.cinchapi.ccl.grammar.OperatorSymbol;
import com.cinchapi.ccl.grammar.ParenthesisSymbol;
import com.cinchapi.ccl.grammar.Symbol;
import com.cinchapi.ccl.grammar.TimestampSymbol;
import com.cinchapi.ccl.grammar.ValueSymbol;
import com.cinchapi.ccl.type.Operator;
import com.cinchapi.concourse.lang.Criteria;
import com.cinchapi.concourse.thrift.TCriteria;
import com.cinchapi.concourse.thrift.TSymbol;
import com.cinchapi.concourse.thrift.TSymbolType;
import com.cinchapi.concourse.util.Convert;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;

public final class Language {
    public static Symbol translateFromThriftSymbol(TSymbol tsymbol) {
        if (tsymbol.getType() == TSymbolType.CONJUNCTION) {
            return ConjunctionSymbol.valueOf((String)tsymbol.getSymbol().toUpperCase());
        }
        if (tsymbol.getType() == TSymbolType.KEY) {
            return new KeySymbol(tsymbol.getSymbol());
        }
        if (tsymbol.getType() == TSymbolType.VALUE) {
            return new ValueSymbol(Convert.stringToJava(tsymbol.getSymbol()));
        }
        if (tsymbol.getType() == TSymbolType.PARENTHESIS) {
            return ParenthesisSymbol.parse((String)tsymbol.getSymbol());
        }
        if (tsymbol.getType() == TSymbolType.OPERATOR) {
            return new OperatorSymbol((Operator)Convert.stringToOperator(tsymbol.getSymbol()));
        }
        if (tsymbol.getType() == TSymbolType.TIMESTAMP) {
            long micros = Long.parseLong(tsymbol.getSymbol().replace("at ", ""));
            return new TimestampSymbol(micros);
        }
        throw new IllegalArgumentException("Unrecognized TSymbol " + tsymbol);
    }

    public static TCriteria translateToThriftCriteria(Criteria criteria) {
        ArrayList symbols = Lists.newArrayList();
        for (Symbol symbol : criteria.getSymbols()) {
            symbols.add(Language.translateToThriftSymbol(symbol));
        }
        return new TCriteria(symbols);
    }

    public static Criteria translateFromThriftCriteria(TCriteria tcriteria) {
        Criteria criteria = new Criteria();
        for (TSymbol tsymbol : tcriteria.getSymbols()) {
            criteria.add(Language.translateFromThriftSymbol(tsymbol));
        }
        return criteria;
    }

    public static TSymbol translateToThriftSymbol(Symbol symbol) {
        if (symbol.getClass() == ConjunctionSymbol.class) {
            return new TSymbol(TSymbolType.CONJUNCTION, symbol.toString());
        }
        if (symbol.getClass() == KeySymbol.class) {
            return new TSymbol(TSymbolType.KEY, symbol.toString());
        }
        if (symbol.getClass() == ValueSymbol.class) {
            return new TSymbol(TSymbolType.VALUE, symbol.toString());
        }
        if (symbol.getClass() == ParenthesisSymbol.class) {
            return new TSymbol(TSymbolType.PARENTHESIS, symbol.toString());
        }
        if (symbol.getClass() == OperatorSymbol.class) {
            return new TSymbol(TSymbolType.OPERATOR, symbol.toString());
        }
        if (symbol.getClass() == TimestampSymbol.class) {
            return new TSymbol(TSymbolType.TIMESTAMP, symbol.toString());
        }
        throw new IllegalArgumentException(MessageFormat.format("Cannot translate {0} to Thrift", symbol));
    }

    private Language() {
    }
}

