/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.security;

import com.cinchapi.common.base.CheckedExceptions;
import com.cinchapi.concourse.util.ByteBuffers;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class ClientSecurity {
    private static final SecureRandom srand = new SecureRandom();
    private static final byte[] DEFAULT_KEY = ClientSecurity.generateSecretKey();

    public static ByteBuffer decrypt(ByteBuffer data) {
        return ClientSecurity.decrypt(data, DEFAULT_KEY);
    }

    public static ByteBuffer decrypt(ByteBuffer data, byte[] key) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            cipher.init(2, secretKey);
            return ByteBuffer.wrap(cipher.doFinal(ByteBuffers.toByteArray(data)));
        }
        catch (Exception e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    public static ByteBuffer encrypt(byte[] data, byte[] key) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            cipher.init(1, secretKey);
            return ByteBuffer.wrap(cipher.doFinal(data));
        }
        catch (Exception e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    public static ByteBuffer encrypt(ByteBuffer data, byte[] key) {
        return ClientSecurity.encrypt(ByteBuffers.toByteArray(data), key);
    }

    public static ByteBuffer encrypt(String data) {
        return ClientSecurity.encrypt(data, DEFAULT_KEY);
    }

    public static ByteBuffer encrypt(String data, byte[] key) {
        return ClientSecurity.encrypt(data.getBytes(), key);
    }

    public static byte[] generateSecretKey() {
        byte[] key = new byte[16];
        srand.nextBytes(key);
        return key;
    }
}

