/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.thrift;

import com.cinchapi.common.base.CheckedExceptions;
import com.cinchapi.concourse.thrift.ComplexTObjectType;
import com.cinchapi.concourse.thrift.TCriteria;
import com.cinchapi.concourse.thrift.TObject;
import com.cinchapi.concourse.thrift.TSymbol;
import com.cinchapi.concourse.thrift.TSymbolType;
import com.cinchapi.concourse.thrift.Type;
import com.cinchapi.concourse.util.ByteBuffers;
import com.cinchapi.concourse.util.Convert;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.SetMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class ComplexTObject
implements TBase<ComplexTObject, _Fields>,
Serializable,
Cloneable,
Comparable<ComplexTObject> {
    private static final TStruct STRUCT_DESC = new TStruct("ComplexTObject");
    private static final TField TYPE_FIELD_DESC = new TField("type", 8, 1);
    private static final TField TSCALAR_FIELD_DESC = new TField("tscalar", 12, 2);
    private static final TField TMAP_FIELD_DESC = new TField("tmap", 13, 3);
    private static final TField TLIST_FIELD_DESC = new TField("tlist", 15, 4);
    private static final TField TSET_FIELD_DESC = new TField("tset", 14, 5);
    private static final TField TOBJECT_FIELD_DESC = new TField("tobject", 12, 6);
    private static final TField TCRITERIA_FIELD_DESC = new TField("tcriteria", 12, 7);
    private static final TField TBINARY_FIELD_DESC = new TField("tbinary", 11, 8);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public ComplexTObjectType type;
    public TObject tscalar;
    public Map<ComplexTObject, ComplexTObject> tmap;
    public List<ComplexTObject> tlist;
    public Set<ComplexTObject> tset;
    public TObject tobject;
    public TCriteria tcriteria;
    public ByteBuffer tbinary;
    private transient Object cached;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public static ComplexTObject fromByteBuffer(ByteBuffer buffer) {
        ComplexTObjectType type = ComplexTObjectType.values()[buffer.get()];
        ComplexTObject obj = new ComplexTObject();
        obj.type = type;
        if (type == ComplexTObjectType.MAP) {
            obj.tmap = Maps.newLinkedHashMap();
            while (buffer.hasRemaining()) {
                int keyLength = buffer.getInt();
                ComplexTObject key = ComplexTObject.fromByteBuffer(ByteBuffers.get(buffer, keyLength));
                int valueLength = buffer.getInt();
                ComplexTObject value = ComplexTObject.fromByteBuffer(ByteBuffers.get(buffer, valueLength));
                obj.tmap.put(key, value);
            }
        } else if (type == ComplexTObjectType.LIST || type == ComplexTObjectType.SET) {
            AbstractCollection collection;
            AbstractCollection abstractCollection;
            if (type == ComplexTObjectType.LIST) {
                obj.tlist = Lists.newArrayList();
                abstractCollection = obj.tlist;
            } else {
                obj.tset = Sets.newLinkedHashSet();
                abstractCollection = collection = obj.tset;
            }
            while (buffer.hasRemaining()) {
                int length = buffer.getInt();
                ComplexTObject item = ComplexTObject.fromByteBuffer(ByteBuffers.get(buffer, length));
                collection.add(item);
            }
        } else if (type == ComplexTObjectType.TCRITERIA) {
            ArrayList symbols = Lists.newArrayList();
            while (buffer.hasRemaining()) {
                int length = buffer.getInt();
                TSymbolType symbolType = TSymbolType.values()[buffer.get()];
                String symbol = ByteBuffers.getString(ByteBuffers.get(buffer, length));
                symbols.add(new TSymbol(symbolType, symbol));
            }
            obj.tcriteria = new TCriteria(symbols);
        } else if (type == ComplexTObjectType.BINARY) {
            obj.tbinary = ByteBuffers.get(buffer, buffer.remaining());
        } else {
            Type ttype = Type.values()[buffer.get()];
            TObject ref = new TObject(ByteBuffers.getRemaining(buffer), ttype);
            if (type == ComplexTObjectType.SCALAR) {
                obj.tscalar = ref;
            } else {
                obj.tobject = ref;
            }
        }
        return obj;
    }

    public static <T> ComplexTObject fromJavaObject(T object) {
        ComplexTObject complex = new ComplexTObject();
        if (object instanceof Map) {
            Map map = (Map)object;
            complex.setType(ComplexTObjectType.MAP);
            LinkedHashMap tmap = Maps.newLinkedHashMap();
            for (Map.Entry entry : map.entrySet()) {
                tmap.put(ComplexTObject.fromJavaObject(entry.getKey()), ComplexTObject.fromJavaObject(entry.getValue()));
            }
            complex.setTmap(tmap);
        } else if (object instanceof List) {
            List list = (List)object;
            complex.setType(ComplexTObjectType.LIST);
            ArrayList tlist = Lists.newArrayList();
            for (Object elt : list) {
                tlist.add(ComplexTObject.fromJavaObject(elt));
            }
            complex.setTlist(tlist);
        } else if (object instanceof Set) {
            Set set = (Set)object;
            complex.setType(ComplexTObjectType.SET);
            LinkedHashSet tset = Sets.newLinkedHashSet();
            for (Object elt : set) {
                tset.add(ComplexTObject.fromJavaObject(elt));
            }
            complex.setTset(tset);
        } else if (object instanceof TObject) {
            complex.setType(ComplexTObjectType.TOBJECT);
            complex.setTobject((TObject)object);
        } else if (object instanceof TCriteria) {
            complex.setType(ComplexTObjectType.TCRITERIA);
            complex.setTcriteria((TCriteria)object);
        } else if (object instanceof byte[] || object instanceof ByteBuffer) {
            complex.setType(ComplexTObjectType.BINARY);
            if (object instanceof ByteBuffer) {
                complex.setTbinary((ByteBuffer)object);
            } else {
                complex.setTbinary(ByteBuffer.wrap((byte[])object));
            }
        } else {
            complex.setType(ComplexTObjectType.SCALAR);
            complex.setTscalar(Convert.javaToThrift(object));
        }
        return complex;
    }

    public ComplexTObject() {
    }

    public ComplexTObject(ComplexTObjectType type) {
        this();
        this.type = type;
    }

    public ComplexTObject(ComplexTObject other) {
        if (other.isSetType()) {
            this.type = other.type;
        }
        if (other.isSetTscalar()) {
            this.tscalar = new TObject(other.tscalar);
        }
        if (other.isSetTmap()) {
            LinkedHashMap<ComplexTObject, ComplexTObject> __this__tmap = new LinkedHashMap<ComplexTObject, ComplexTObject>(other.tmap.size());
            for (Map.Entry entry : other.tmap.entrySet()) {
                ComplexTObject other_element_key = (ComplexTObject)entry.getKey();
                ComplexTObject other_element_value = (ComplexTObject)entry.getValue();
                ComplexTObject __this__tmap_copy_key = other_element_key;
                ComplexTObject __this__tmap_copy_value = other_element_value;
                __this__tmap.put(__this__tmap_copy_key, __this__tmap_copy_value);
            }
            this.tmap = __this__tmap;
        }
        if (other.isSetTlist()) {
            ArrayList<ComplexTObject> __this__tlist = new ArrayList<ComplexTObject>(other.tlist.size());
            for (ComplexTObject complexTObject : other.tlist) {
                __this__tlist.add(complexTObject);
            }
            this.tlist = __this__tlist;
        }
        if (other.isSetTset()) {
            HashSet<ComplexTObject> __this__tset = new HashSet<ComplexTObject>(other.tset.size());
            for (ComplexTObject complexTObject : other.tset) {
                __this__tset.add(complexTObject);
            }
            this.tset = __this__tset;
        }
        if (other.isSetTobject()) {
            this.tobject = new TObject(other.tobject);
        }
        if (other.isSetTcriteria()) {
            this.tcriteria = new TCriteria(other.tcriteria);
        }
        if (other.isSetTbinary()) {
            this.tbinary = TBaseHelper.copyBinary((ByteBuffer)other.tbinary);
        }
    }

    public ByteBuffer toByteBuffer() {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ByteBuffer size = ByteBuffer.allocate(4);
        bytes.write(this.type.ordinal());
        if (this.type == ComplexTObjectType.MAP) {
            this.tmap.entrySet().forEach(entry -> {
                try {
                    byte[] key = ((ComplexTObject)entry.getKey()).toByteBuffer().array();
                    bytes.write((byte[])size.putInt(key.length).flip().array());
                    bytes.write(key);
                    byte[] value = ((ComplexTObject)entry.getValue()).toByteBuffer().array();
                    bytes.write((byte[])size.putInt(value.length).flip().array());
                    bytes.write(value);
                }
                catch (IOException e) {
                    throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
                }
            });
        } else if (this.type == ComplexTObjectType.LIST || this.type == ComplexTObjectType.SET) {
            Collection<ComplexTObject> collection = this.type == ComplexTObjectType.LIST ? this.tlist : this.tset;
            collection.forEach(item -> {
                try {
                    byte[] itemBytes = item.toByteBuffer().array();
                    bytes.write((byte[])size.putInt(itemBytes.length).flip().array());
                    bytes.write(itemBytes);
                }
                catch (IOException e) {
                    throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
                }
            });
        } else if (this.type == ComplexTObjectType.TCRITERIA) {
            this.tcriteria.symbols.forEach(item -> {
                try {
                    byte[] symbolBytes = item.symbol.getBytes(StandardCharsets.UTF_8);
                    int length = symbolBytes.length;
                    bytes.write((byte[])size.putInt(length).flip().array());
                    bytes.write(item.type.ordinal());
                    bytes.write(symbolBytes);
                }
                catch (IOException e) {
                    throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
                }
            });
        } else {
            if (this.type == ComplexTObjectType.BINARY) {
                try {
                    bytes.write(this.tbinary.array());
                }
                catch (IOException e) {
                    throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
                }
            }
            TObject obj = (TObject)MoreObjects.firstNonNull((Object)this.tobject, (Object)this.tscalar);
            try {
                bytes.write(obj.type.ordinal());
                bytes.write(obj.getData());
            }
            catch (IOException e) {
                throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
            }
        }
        return ByteBuffer.wrap(bytes.toByteArray());
    }

    public <T> T getJavaObject() {
        if (this.cached == null) {
            if (this.type == ComplexTObjectType.MAP) {
                Map<ComplexTObject, ComplexTObject> tmap = this.getTmap();
                LinkedHashMap map = Maps.newLinkedHashMap();
                for (Map.Entry<ComplexTObject, ComplexTObject> entry : tmap.entrySet()) {
                    map.put(entry.getKey().getJavaObject(), entry.getValue().getJavaObject());
                }
                this.cached = map;
            } else if (this.type == ComplexTObjectType.LIST) {
                List<ComplexTObject> tlist = this.getTlist();
                ArrayList list = Lists.newArrayListWithCapacity((int)tlist.size());
                for (ComplexTObject elt : tlist) {
                    list.add(elt.getJavaObject());
                }
                this.cached = list;
            } else if (this.type == ComplexTObjectType.SET) {
                Set<ComplexTObject> tset = this.getTset();
                LinkedHashSet set = Sets.newLinkedHashSetWithExpectedSize((int)tset.size());
                for (ComplexTObject elt : tset) {
                    set.add(elt.getJavaObject());
                }
                this.cached = set;
            } else if (this.type == ComplexTObjectType.TOBJECT) {
                this.cached = this.getTobject();
            } else if (this.type == ComplexTObjectType.TCRITERIA) {
                this.cached = this.getTcriteria();
            } else {
                if (this.type == ComplexTObjectType.BINARY) {
                    return (T)this.bufferForTbinary();
                }
                TObject tscalar = this.getTscalar();
                this.cached = Convert.thriftToJava(tscalar);
            }
        }
        return (T)this.cached;
    }

    public ComplexTObject deepCopy() {
        return new ComplexTObject(this);
    }

    public void clear() {
        this.type = null;
        this.tscalar = null;
        this.tmap = null;
        this.tlist = null;
        this.tset = null;
        this.tobject = null;
        this.tcriteria = null;
        this.tbinary = null;
    }

    public ComplexTObjectType getType() {
        return this.type;
    }

    public ComplexTObject setType(ComplexTObjectType type) {
        this.type = type;
        return this;
    }

    public void unsetType() {
        this.type = null;
    }

    public boolean isSetType() {
        return this.type != null;
    }

    public void setTypeIsSet(boolean value) {
        if (!value) {
            this.type = null;
        }
    }

    public TObject getTscalar() {
        return this.tscalar;
    }

    public ComplexTObject setTscalar(TObject tscalar) {
        this.tscalar = tscalar;
        return this;
    }

    public void unsetTscalar() {
        this.tscalar = null;
    }

    public boolean isSetTscalar() {
        return this.tscalar != null;
    }

    public void setTscalarIsSet(boolean value) {
        if (!value) {
            this.tscalar = null;
        }
    }

    public int getTmapSize() {
        return this.tmap == null ? 0 : this.tmap.size();
    }

    public void putToTmap(ComplexTObject key, ComplexTObject val) {
        if (this.tmap == null) {
            this.tmap = new LinkedHashMap<ComplexTObject, ComplexTObject>();
        }
        this.tmap.put(key, val);
    }

    public Map<ComplexTObject, ComplexTObject> getTmap() {
        return this.tmap;
    }

    public ComplexTObject setTmap(Map<ComplexTObject, ComplexTObject> tmap) {
        this.tmap = tmap;
        return this;
    }

    public void unsetTmap() {
        this.tmap = null;
    }

    public boolean isSetTmap() {
        return this.tmap != null;
    }

    public void setTmapIsSet(boolean value) {
        if (!value) {
            this.tmap = null;
        }
    }

    public int getTlistSize() {
        return this.tlist == null ? 0 : this.tlist.size();
    }

    public Iterator<ComplexTObject> getTlistIterator() {
        return this.tlist == null ? null : this.tlist.iterator();
    }

    public void addToTlist(ComplexTObject elem) {
        if (this.tlist == null) {
            this.tlist = new ArrayList<ComplexTObject>();
        }
        this.tlist.add(elem);
    }

    public List<ComplexTObject> getTlist() {
        return this.tlist;
    }

    public ComplexTObject setTlist(List<ComplexTObject> tlist) {
        this.tlist = tlist;
        return this;
    }

    public void unsetTlist() {
        this.tlist = null;
    }

    public boolean isSetTlist() {
        return this.tlist != null;
    }

    public void setTlistIsSet(boolean value) {
        if (!value) {
            this.tlist = null;
        }
    }

    public int getTsetSize() {
        return this.tset == null ? 0 : this.tset.size();
    }

    public Iterator<ComplexTObject> getTsetIterator() {
        return this.tset == null ? null : this.tset.iterator();
    }

    public void addToTset(ComplexTObject elem) {
        if (this.tset == null) {
            this.tset = new HashSet<ComplexTObject>();
        }
        this.tset.add(elem);
    }

    public Set<ComplexTObject> getTset() {
        return this.tset;
    }

    public ComplexTObject setTset(Set<ComplexTObject> tset) {
        this.tset = tset;
        return this;
    }

    public void unsetTset() {
        this.tset = null;
    }

    public boolean isSetTset() {
        return this.tset != null;
    }

    public void setTsetIsSet(boolean value) {
        if (!value) {
            this.tset = null;
        }
    }

    public TObject getTobject() {
        return this.tobject;
    }

    public ComplexTObject setTobject(TObject tobject) {
        this.tobject = tobject;
        return this;
    }

    public void unsetTobject() {
        this.tobject = null;
    }

    public boolean isSetTobject() {
        return this.tobject != null;
    }

    public void setTobjectIsSet(boolean value) {
        if (!value) {
            this.tobject = null;
        }
    }

    public TCriteria getTcriteria() {
        return this.tcriteria;
    }

    public ComplexTObject setTcriteria(TCriteria tcriteria) {
        this.tcriteria = tcriteria;
        return this;
    }

    public void unsetTcriteria() {
        this.tcriteria = null;
    }

    public boolean isSetTcriteria() {
        return this.tcriteria != null;
    }

    public void setTcriteriaIsSet(boolean value) {
        if (!value) {
            this.tcriteria = null;
        }
    }

    public byte[] getTbinary() {
        this.setTbinary(TBaseHelper.rightSize((ByteBuffer)this.tbinary));
        return this.tbinary == null ? null : this.tbinary.array();
    }

    public ByteBuffer bufferForTbinary() {
        return TBaseHelper.copyBinary((ByteBuffer)this.tbinary);
    }

    public ComplexTObject setTbinary(byte[] tbinary) {
        this.tbinary = tbinary == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(tbinary, tbinary.length));
        return this;
    }

    public ComplexTObject setTbinary(ByteBuffer tbinary) {
        this.tbinary = TBaseHelper.copyBinary((ByteBuffer)tbinary);
        return this;
    }

    public void unsetTbinary() {
        this.tbinary = null;
    }

    public boolean isSetTbinary() {
        return this.tbinary != null;
    }

    public void setTbinaryIsSet(boolean value) {
        if (!value) {
            this.tbinary = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case TYPE: {
                if (value == null) {
                    this.unsetType();
                    break;
                }
                this.setType((ComplexTObjectType)((Object)value));
                break;
            }
            case TSCALAR: {
                if (value == null) {
                    this.unsetTscalar();
                    break;
                }
                this.setTscalar((TObject)value);
                break;
            }
            case TMAP: {
                if (value == null) {
                    this.unsetTmap();
                    break;
                }
                this.setTmap((Map)value);
                break;
            }
            case TLIST: {
                if (value == null) {
                    this.unsetTlist();
                    break;
                }
                this.setTlist((List)value);
                break;
            }
            case TSET: {
                if (value == null) {
                    this.unsetTset();
                    break;
                }
                this.setTset((Set)value);
                break;
            }
            case TOBJECT: {
                if (value == null) {
                    this.unsetTobject();
                    break;
                }
                this.setTobject((TObject)value);
                break;
            }
            case TCRITERIA: {
                if (value == null) {
                    this.unsetTcriteria();
                    break;
                }
                this.setTcriteria((TCriteria)value);
                break;
            }
            case TBINARY: {
                if (value == null) {
                    this.unsetTbinary();
                    break;
                }
                this.setTbinary((ByteBuffer)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TYPE: {
                return this.getType();
            }
            case TSCALAR: {
                return this.getTscalar();
            }
            case TMAP: {
                return this.getTmap();
            }
            case TLIST: {
                return this.getTlist();
            }
            case TSET: {
                return this.getTset();
            }
            case TOBJECT: {
                return this.getTobject();
            }
            case TCRITERIA: {
                return this.getTcriteria();
            }
            case TBINARY: {
                return this.getTbinary();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TYPE: {
                return this.isSetType();
            }
            case TSCALAR: {
                return this.isSetTscalar();
            }
            case TMAP: {
                return this.isSetTmap();
            }
            case TLIST: {
                return this.isSetTlist();
            }
            case TSET: {
                return this.isSetTset();
            }
            case TOBJECT: {
                return this.isSetTobject();
            }
            case TCRITERIA: {
                return this.isSetTcriteria();
            }
            case TBINARY: {
                return this.isSetTbinary();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof ComplexTObject) {
            return this.equals((ComplexTObject)that);
        }
        return false;
    }

    public boolean equals(ComplexTObject that) {
        if (that == null) {
            return false;
        }
        boolean this_present_type = this.isSetType();
        boolean that_present_type = that.isSetType();
        if (this_present_type || that_present_type) {
            if (!this_present_type || !that_present_type) {
                return false;
            }
            if (!this.type.equals((Object)that.type)) {
                return false;
            }
        }
        boolean this_present_tscalar = this.isSetTscalar();
        boolean that_present_tscalar = that.isSetTscalar();
        if (this_present_tscalar || that_present_tscalar) {
            if (!this_present_tscalar || !that_present_tscalar) {
                return false;
            }
            if (!this.tscalar.equals(that.tscalar)) {
                return false;
            }
        }
        boolean this_present_tmap = this.isSetTmap();
        boolean that_present_tmap = that.isSetTmap();
        if (this_present_tmap || that_present_tmap) {
            if (!this_present_tmap || !that_present_tmap) {
                return false;
            }
            if (!this.tmap.equals(that.tmap)) {
                return false;
            }
        }
        boolean this_present_tlist = this.isSetTlist();
        boolean that_present_tlist = that.isSetTlist();
        if (this_present_tlist || that_present_tlist) {
            if (!this_present_tlist || !that_present_tlist) {
                return false;
            }
            if (!this.tlist.equals(that.tlist)) {
                return false;
            }
        }
        boolean this_present_tset = this.isSetTset();
        boolean that_present_tset = that.isSetTset();
        if (this_present_tset || that_present_tset) {
            if (!this_present_tset || !that_present_tset) {
                return false;
            }
            if (!this.tset.equals(that.tset)) {
                return false;
            }
        }
        boolean this_present_tobject = this.isSetTobject();
        boolean that_present_tobject = that.isSetTobject();
        if (this_present_tobject || that_present_tobject) {
            if (!this_present_tobject || !that_present_tobject) {
                return false;
            }
            if (!this.tobject.equals(that.tobject)) {
                return false;
            }
        }
        boolean this_present_tcriteria = this.isSetTcriteria();
        boolean that_present_tcriteria = that.isSetTcriteria();
        if (this_present_tcriteria || that_present_tcriteria) {
            if (!this_present_tcriteria || !that_present_tcriteria) {
                return false;
            }
            if (!this.tcriteria.equals(that.tcriteria)) {
                return false;
            }
        }
        boolean this_present_tbinary = this.isSetTbinary();
        boolean that_present_tbinary = that.isSetTbinary();
        if (this_present_tbinary || that_present_tbinary) {
            if (!this_present_tbinary || !that_present_tbinary) {
                return false;
            }
            if (!this.tbinary.equals(that.tbinary)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_type = this.isSetType();
        list.add(present_type);
        if (present_type) {
            list.add(this.type.getValue());
        }
        boolean present_tscalar = this.isSetTscalar();
        list.add(present_tscalar);
        if (present_tscalar) {
            list.add(this.tscalar);
        }
        boolean present_tmap = this.isSetTmap();
        list.add(present_tmap);
        if (present_tmap) {
            list.add(this.tmap);
        }
        boolean present_tlist = this.isSetTlist();
        list.add(present_tlist);
        if (present_tlist) {
            list.add(this.tlist);
        }
        boolean present_tset = this.isSetTset();
        list.add(present_tset);
        if (present_tset) {
            list.add(this.tset);
        }
        boolean present_tobject = this.isSetTobject();
        list.add(present_tobject);
        if (present_tobject) {
            list.add(this.tobject);
        }
        boolean present_tcriteria = this.isSetTcriteria();
        list.add(present_tcriteria);
        if (present_tcriteria) {
            list.add(this.tcriteria);
        }
        boolean present_tbinary = this.isSetTbinary();
        list.add(present_tbinary);
        if (present_tbinary) {
            list.add(this.tbinary);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(ComplexTObject other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetType()).compareTo(other.isSetType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.type), (Comparable)((Object)other.type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTscalar()).compareTo(other.isSetTscalar());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTscalar() && (lastComparison = TBaseHelper.compareTo((Comparable)this.tscalar, (Comparable)other.tscalar)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTmap()).compareTo(other.isSetTmap());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTmap() && (lastComparison = TBaseHelper.compareTo(this.tmap, other.tmap)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTlist()).compareTo(other.isSetTlist());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTlist() && (lastComparison = TBaseHelper.compareTo(this.tlist, other.tlist)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTset()).compareTo(other.isSetTset());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTset() && (lastComparison = TBaseHelper.compareTo(this.tset, other.tset)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTobject()).compareTo(other.isSetTobject());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTobject() && (lastComparison = TBaseHelper.compareTo((Comparable)this.tobject, (Comparable)other.tobject)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTcriteria()).compareTo(other.isSetTcriteria());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTcriteria() && (lastComparison = TBaseHelper.compareTo((Comparable)this.tcriteria, (Comparable)other.tcriteria)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTbinary()).compareTo(other.isSetTbinary());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTbinary() && (lastComparison = TBaseHelper.compareTo((Comparable)this.tbinary, (Comparable)other.tbinary)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ComplexTObject(");
        boolean first = true;
        sb.append("type:");
        if (this.type == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.type);
        }
        first = false;
        if (this.isSetTscalar()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("tscalar:");
            if (this.tscalar == null) {
                sb.append("null");
            } else {
                sb.append(this.tscalar);
            }
            first = false;
        }
        if (this.isSetTmap()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("tmap:");
            if (this.tmap == null) {
                sb.append("null");
            } else {
                sb.append(this.tmap);
            }
            first = false;
        }
        if (this.isSetTlist()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("tlist:");
            if (this.tlist == null) {
                sb.append("null");
            } else {
                sb.append(this.tlist);
            }
            first = false;
        }
        if (this.isSetTset()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("tset:");
            if (this.tset == null) {
                sb.append("null");
            } else {
                sb.append(this.tset);
            }
            first = false;
        }
        if (this.isSetTobject()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("tobject:");
            if (this.tobject == null) {
                sb.append("null");
            } else {
                sb.append(this.tobject);
            }
            first = false;
        }
        if (this.isSetTcriteria()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("tcriteria:");
            if (this.tcriteria == null) {
                sb.append("null");
            } else {
                sb.append(this.tcriteria);
            }
            first = false;
        }
        if (this.isSetTbinary()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("tbinary:");
            if (this.tbinary == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString((ByteBuffer)this.tbinary, (StringBuilder)sb);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.type == null) {
            throw new TProtocolException("Required field 'type' was not present! Struct: " + this.toString());
        }
        if (this.tscalar != null) {
            this.tscalar.validate();
        }
        if (this.tobject != null) {
            this.tobject.validate();
        }
        if (this.tcriteria != null) {
            this.tcriteria.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new ComplexTObjectStandardSchemeFactory());
        schemes.put(TupleScheme.class, new ComplexTObjectTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.TSCALAR, _Fields.TMAP, _Fields.TLIST, _Fields.TSET, _Fields.TOBJECT, _Fields.TCRITERIA, _Fields.TBINARY};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TYPE, new FieldMetaData("type", 1, (FieldValueMetaData)new EnumMetaData(16, ComplexTObjectType.class)));
        tmpMap.put(_Fields.TSCALAR, new FieldMetaData("tscalar", 2, (FieldValueMetaData)new StructMetaData(12, TObject.class)));
        tmpMap.put(_Fields.TMAP, new FieldMetaData("tmap", 2, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(12, "ComplexTObject"), new FieldValueMetaData(12, "ComplexTObject"))));
        tmpMap.put(_Fields.TLIST, new FieldMetaData("tlist", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(12, "ComplexTObject"))));
        tmpMap.put(_Fields.TSET, new FieldMetaData("tset", 2, (FieldValueMetaData)new SetMetaData(14, new FieldValueMetaData(12, "ComplexTObject"))));
        tmpMap.put(_Fields.TOBJECT, new FieldMetaData("tobject", 2, (FieldValueMetaData)new StructMetaData(12, TObject.class)));
        tmpMap.put(_Fields.TCRITERIA, new FieldMetaData("tcriteria", 2, (FieldValueMetaData)new StructMetaData(12, TCriteria.class)));
        tmpMap.put(_Fields.TBINARY, new FieldMetaData("tbinary", 2, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(ComplexTObject.class, metaDataMap);
    }

    private static class ComplexTObjectTupleScheme
    extends TupleScheme<ComplexTObject> {
        private ComplexTObjectTupleScheme() {
        }

        public void write(TProtocol prot, ComplexTObject struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.type.getValue());
            BitSet optionals = new BitSet();
            if (struct.isSetTscalar()) {
                optionals.set(0);
            }
            if (struct.isSetTmap()) {
                optionals.set(1);
            }
            if (struct.isSetTlist()) {
                optionals.set(2);
            }
            if (struct.isSetTset()) {
                optionals.set(3);
            }
            if (struct.isSetTobject()) {
                optionals.set(4);
            }
            if (struct.isSetTcriteria()) {
                optionals.set(5);
            }
            if (struct.isSetTbinary()) {
                optionals.set(6);
            }
            oprot.writeBitSet(optionals, 7);
            if (struct.isSetTscalar()) {
                struct.tscalar.write((TProtocol)oprot);
            }
            if (struct.isSetTmap()) {
                oprot.writeI32(struct.tmap.size());
                for (Map.Entry entry : struct.tmap.entrySet()) {
                    ((ComplexTObject)entry.getKey()).write((TProtocol)oprot);
                    ((ComplexTObject)entry.getValue()).write((TProtocol)oprot);
                }
            }
            if (struct.isSetTlist()) {
                oprot.writeI32(struct.tlist.size());
                for (ComplexTObject complexTObject : struct.tlist) {
                    complexTObject.write((TProtocol)oprot);
                }
            }
            if (struct.isSetTset()) {
                oprot.writeI32(struct.tset.size());
                for (ComplexTObject complexTObject : struct.tset) {
                    complexTObject.write((TProtocol)oprot);
                }
            }
            if (struct.isSetTobject()) {
                struct.tobject.write((TProtocol)oprot);
            }
            if (struct.isSetTcriteria()) {
                struct.tcriteria.write((TProtocol)oprot);
            }
            if (struct.isSetTbinary()) {
                oprot.writeBinary(struct.tbinary);
            }
        }

        public void read(TProtocol prot, ComplexTObject struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.type = ComplexTObjectType.findByValue(iprot.readI32());
            struct.setTypeIsSet(true);
            BitSet incoming = iprot.readBitSet(7);
            if (incoming.get(0)) {
                struct.tscalar = new TObject();
                struct.tscalar.read((TProtocol)iprot);
                struct.setTscalarIsSet(true);
            }
            if (incoming.get(1)) {
                TMap _map16 = new TMap(12, 12, iprot.readI32());
                struct.tmap = new LinkedHashMap<ComplexTObject, ComplexTObject>(2 * _map16.size);
                for (int _i19 = 0; _i19 < _map16.size; ++_i19) {
                    ComplexTObject _key17 = new ComplexTObject();
                    _key17.read((TProtocol)iprot);
                    ComplexTObject _val18 = new ComplexTObject();
                    _val18.read((TProtocol)iprot);
                    struct.tmap.put(_key17, _val18);
                }
                struct.setTmapIsSet(true);
            }
            if (incoming.get(2)) {
                TList _list20 = new TList(12, iprot.readI32());
                struct.tlist = new ArrayList<ComplexTObject>(_list20.size);
                for (int _i22 = 0; _i22 < _list20.size; ++_i22) {
                    ComplexTObject _elem21 = new ComplexTObject();
                    _elem21.read((TProtocol)iprot);
                    struct.tlist.add(_elem21);
                }
                struct.setTlistIsSet(true);
            }
            if (incoming.get(3)) {
                TSet _set23 = new TSet(12, iprot.readI32());
                struct.tset = new HashSet<ComplexTObject>(2 * _set23.size);
                for (int _i25 = 0; _i25 < _set23.size; ++_i25) {
                    ComplexTObject _elem24 = new ComplexTObject();
                    _elem24.read((TProtocol)iprot);
                    struct.tset.add(_elem24);
                }
                struct.setTsetIsSet(true);
            }
            if (incoming.get(4)) {
                struct.tobject = new TObject();
                struct.tobject.read((TProtocol)iprot);
                struct.setTobjectIsSet(true);
            }
            if (incoming.get(5)) {
                struct.tcriteria = new TCriteria();
                struct.tcriteria.read((TProtocol)iprot);
                struct.setTcriteriaIsSet(true);
            }
            if (incoming.get(6)) {
                struct.tbinary = iprot.readBinary();
                struct.setTbinaryIsSet(true);
            }
        }
    }

    private static class ComplexTObjectTupleSchemeFactory
    implements SchemeFactory {
        private ComplexTObjectTupleSchemeFactory() {
        }

        public ComplexTObjectTupleScheme getScheme() {
            return new ComplexTObjectTupleScheme();
        }
    }

    private static class ComplexTObjectStandardScheme
    extends StandardScheme<ComplexTObject> {
        private ComplexTObjectStandardScheme() {
        }

        public void read(TProtocol iprot, ComplexTObject struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 8) {
                            struct.type = ComplexTObjectType.findByValue(iprot.readI32());
                            struct.setTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 12) {
                            struct.tscalar = new TObject();
                            struct.tscalar.read(iprot);
                            struct.setTscalarIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 13) {
                            TMap _map0 = iprot.readMapBegin();
                            struct.tmap = new LinkedHashMap<ComplexTObject, ComplexTObject>(2 * _map0.size);
                            for (int _i3 = 0; _i3 < _map0.size; ++_i3) {
                                ComplexTObject _key1 = new ComplexTObject();
                                _key1.read(iprot);
                                ComplexTObject _val2 = new ComplexTObject();
                                _val2.read(iprot);
                                struct.tmap.put(_key1, _val2);
                            }
                            iprot.readMapEnd();
                            struct.setTmapIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 15) {
                            TList _list4 = iprot.readListBegin();
                            struct.tlist = new ArrayList<ComplexTObject>(_list4.size);
                            for (int _i6 = 0; _i6 < _list4.size; ++_i6) {
                                ComplexTObject _elem5 = new ComplexTObject();
                                _elem5.read(iprot);
                                struct.tlist.add(_elem5);
                            }
                            iprot.readListEnd();
                            struct.setTlistIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 14) {
                            TSet _set7 = iprot.readSetBegin();
                            struct.tset = new HashSet<ComplexTObject>(2 * _set7.size);
                            for (int _i9 = 0; _i9 < _set7.size; ++_i9) {
                                ComplexTObject _elem8 = new ComplexTObject();
                                _elem8.read(iprot);
                                struct.tset.add(_elem8);
                            }
                            iprot.readSetEnd();
                            struct.setTsetIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 12) {
                            struct.tobject = new TObject();
                            struct.tobject.read(iprot);
                            struct.setTobjectIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 12) {
                            struct.tcriteria = new TCriteria();
                            struct.tcriteria.read(iprot);
                            struct.setTcriteriaIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 11) {
                            struct.tbinary = iprot.readBinary();
                            struct.setTbinaryIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, ComplexTObject struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.type != null) {
                oprot.writeFieldBegin(TYPE_FIELD_DESC);
                oprot.writeI32(struct.type.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.tscalar != null && struct.isSetTscalar()) {
                oprot.writeFieldBegin(TSCALAR_FIELD_DESC);
                struct.tscalar.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.tmap != null && struct.isSetTmap()) {
                oprot.writeFieldBegin(TMAP_FIELD_DESC);
                oprot.writeMapBegin(new TMap(12, 12, struct.tmap.size()));
                for (Map.Entry entry : struct.tmap.entrySet()) {
                    ((ComplexTObject)entry.getKey()).write(oprot);
                    ((ComplexTObject)entry.getValue()).write(oprot);
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.tlist != null && struct.isSetTlist()) {
                oprot.writeFieldBegin(TLIST_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.tlist.size()));
                for (ComplexTObject complexTObject : struct.tlist) {
                    complexTObject.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.tset != null && struct.isSetTset()) {
                oprot.writeFieldBegin(TSET_FIELD_DESC);
                oprot.writeSetBegin(new TSet(12, struct.tset.size()));
                for (ComplexTObject complexTObject : struct.tset) {
                    complexTObject.write(oprot);
                }
                oprot.writeSetEnd();
                oprot.writeFieldEnd();
            }
            if (struct.tobject != null && struct.isSetTobject()) {
                oprot.writeFieldBegin(TOBJECT_FIELD_DESC);
                struct.tobject.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.tcriteria != null && struct.isSetTcriteria()) {
                oprot.writeFieldBegin(TCRITERIA_FIELD_DESC);
                struct.tcriteria.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.tbinary != null && struct.isSetTbinary()) {
                oprot.writeFieldBegin(TBINARY_FIELD_DESC);
                oprot.writeBinary(struct.tbinary);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class ComplexTObjectStandardSchemeFactory
    implements SchemeFactory {
        private ComplexTObjectStandardSchemeFactory() {
        }

        public ComplexTObjectStandardScheme getScheme() {
            return new ComplexTObjectStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TYPE(1, "type"),
        TSCALAR(2, "tscalar"),
        TMAP(3, "tmap"),
        TLIST(4, "tlist"),
        TSET(5, "tset"),
        TOBJECT(6, "tobject"),
        TCRITERIA(7, "tcriteria"),
        TBINARY(8, "tbinary");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TYPE;
                }
                case 2: {
                    return TSCALAR;
                }
                case 3: {
                    return TMAP;
                }
                case 4: {
                    return TLIST;
                }
                case 5: {
                    return TSET;
                }
                case 6: {
                    return TOBJECT;
                }
                case 7: {
                    return TCRITERIA;
                }
                case 8: {
                    return TBINARY;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

