/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.thrift;

import com.cinchapi.concourse.Link;
import com.cinchapi.concourse.Timestamp;
import com.cinchapi.concourse.annotate.DoNotInvoke;
import com.cinchapi.concourse.thrift.Operator;
import com.cinchapi.concourse.thrift.Type;
import com.cinchapi.concourse.util.ByteBuffers;
import com.cinchapi.concourse.util.Convert;
import com.cinchapi.concourse.util.Numbers;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TObject
implements TBase<TObject, _Fields>,
Serializable,
Cloneable,
Comparable<TObject> {
    private static final TObject POSITIVE_INFINITY = Convert.javaToThrift(Long.MAX_VALUE);
    private static final TObject NEGATIVE_INFINITY = Convert.javaToThrift(Long.MIN_VALUE);
    public static final Map<_Fields, FieldMetaData> metaDataMap;
    public static final TObject NULL;
    private static final TField DATA_FIELD_DESC;
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes;
    private static final TStruct STRUCT_DESC;
    private static final TField TYPE_FIELD_DESC;
    private static byte WHITESPACE;
    public ByteBuffer data;
    public Type type;
    private Object java = null;
    private Object serverWrapper = null;

    public static Comparator<TObject> comparator() {
        return (v1, v2) -> {
            if (v1 == POSITIVE_INFINITY && v2 == POSITIVE_INFINITY || v1 == NEGATIVE_INFINITY && v2 == NEGATIVE_INFINITY) {
                return 0;
            }
            if (v1 == POSITIVE_INFINITY) {
                return 1;
            }
            if (v2 == POSITIVE_INFINITY) {
                return -1;
            }
            if (v1 == NEGATIVE_INFINITY) {
                return -1;
            }
            if (v2 == NEGATIVE_INFINITY) {
                return 1;
            }
            Object o1 = Convert.thriftToJava(v1);
            Object o2 = Convert.thriftToJava(v2);
            if (o1 instanceof Number && o2 instanceof Number && (!(o1 instanceof Link) && !(o2 instanceof Link) || o1 instanceof Link && o2 instanceof Link)) {
                return Numbers.compare((Number)o1, (Number)o2);
            }
            if (o1 instanceof Number) {
                return -1;
            }
            if (o2 instanceof Number) {
                return 1;
            }
            if (o1 instanceof Timestamp && o2 instanceof Timestamp) {
                return Longs.compare((long)((Timestamp)o1).getMicros(), (long)((Timestamp)o2).getMicros());
            }
            String o1s = o1 instanceof Timestamp ? Long.toString(((Timestamp)o1).getMicros()) : o1.toString();
            String o2s = o2 instanceof Timestamp ? Long.toString(((Timestamp)o2).getMicros()) : o2.toString();
            return o1s.compareToIgnoreCase(o2s);
        };
    }

    public TObject() {
        this.type = Type.STRING;
    }

    public TObject(ByteBuffer data, Type type) {
        this.data = data;
        this.type = type;
    }

    public TObject(TObject other) {
        if (other.isSetData()) {
            this.data = TBaseHelper.copyBinary((ByteBuffer)other.data);
        }
        if (other.isSetType()) {
            this.type = other.type;
        }
    }

    public ByteBuffer bufferForData() {
        return ByteBuffers.asReadOnlyBuffer(this.data);
    }

    @DoNotInvoke
    public TObject cacheServerWrapper(Object serverValue) {
        this.serverWrapper = serverValue;
        return this;
    }

    public void clear() {
        this.data = null;
        this.type = Type.STRING;
    }

    @Override
    public int compareTo(TObject other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetData()).compareTo(other.isSetData());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetData() && (lastComparison = TBaseHelper.compareTo((Comparable)this.data, (Comparable)other.data)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetType()).compareTo(other.isSetType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.type), (Comparable)((Object)other.type))) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public TObject deepCopy() {
        return new TObject(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TObject) {
            TObject other = (TObject)obj;
            return this.bufferForData().equals(other.bufferForData()) && this.getInternalType() == other.getInternalType();
        }
        return false;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public byte[] getData() {
        this.setData(TBaseHelper.rightSize((ByteBuffer)this.data));
        return this.data == null ? null : this.data.array();
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case DATA: {
                return this.getData();
            }
            case TYPE: {
                return this.getType();
            }
        }
        throw new IllegalStateException();
    }

    @Nullable
    public Object getJavaFormat() {
        return this.java;
    }

    @Nullable
    @DoNotInvoke
    public Object getServerWrapper() {
        return this.serverWrapper;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        return Arrays.hashCode(new int[]{this.data.hashCode(), this.getInternalType().ordinal()});
    }

    public boolean is(Operator operator, TObject ... values) {
        TObject v1 = values[0];
        switch (operator) {
            case EQUALS: {
                return TObject.comparator().compare(this, v1) == 0;
            }
            case NOT_EQUALS: {
                return TObject.comparator().compare(this, v1) != 0;
            }
            case GREATER_THAN: {
                return TObject.comparator().compare(this, v1) > 0;
            }
            case GREATER_THAN_OR_EQUALS: {
                return TObject.comparator().compare(this, v1) >= 0;
            }
            case LESS_THAN: {
                return TObject.comparator().compare(this, v1) < 0;
            }
            case LESS_THAN_OR_EQUALS: {
                return TObject.comparator().compare(this, v1) <= 0;
            }
            case BETWEEN: {
                Preconditions.checkArgument((values.length > 1 ? 1 : 0) != 0);
                TObject v2 = values[1];
                return TObject.comparator().compare(v1, this) <= 0 && TObject.comparator().compare(v2, this) > 0;
            }
            case REGEX: {
                return Convert.thriftToJava(this).toString().matches(Convert.thriftToJava(v1).toString());
            }
            case NOT_REGEX: {
                return !Convert.thriftToJava(this).toString().matches(Convert.thriftToJava(v1).toString());
            }
        }
        throw new UnsupportedOperationException();
    }

    public boolean isBlank() {
        if (this == NULL || this.type == Type.NULL) {
            return true;
        }
        if (this.data.capacity() == 0) {
            return true;
        }
        if (this.type == Type.STRING || this.type == Type.TAG) {
            byte[] bytes = ByteBuffers.toByteArray(this.data);
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] == WHITESPACE) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case DATA: {
                return this.isSetData();
            }
            case TYPE: {
                return this.isSetType();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSetData() {
        return this.data != null;
    }

    public boolean isSetType() {
        return this.type != null;
    }

    public boolean matches(TObject other) {
        return this.type == other.type && this.equals(other);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public TObject setData(byte[] data) {
        this.setData(data == null ? (ByteBuffer)null : ByteBuffer.wrap(data));
        return this;
    }

    public TObject setData(ByteBuffer data) {
        this.data = data;
        return this;
    }

    public void setDataIsSet(boolean value) {
        if (!value) {
            this.data = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case DATA: {
                if (value == null) {
                    this.unsetData();
                    break;
                }
                this.setData((ByteBuffer)value);
                break;
            }
            case TYPE: {
                if (value == null) {
                    this.unsetType();
                    break;
                }
                this.setType((Type)((Object)value));
            }
        }
    }

    public TObject setJavaFormat(Object java) {
        this.java = java;
        return this;
    }

    public TObject setType(Type type) {
        this.type = type;
        return this;
    }

    public void setTypeIsSet(boolean value) {
        if (!value) {
            this.type = null;
        }
    }

    public String toString() {
        if (this.type == Type.NULL) {
            return "null";
        }
        return Convert.thriftToJava(this).toString();
    }

    public void unsetData() {
        this.data = null;
    }

    public void unsetType() {
        this.type = null;
    }

    public void validate() throws TException {
        if (this.data == null) {
            throw new TProtocolException("Required field 'data' was not present! Struct: " + this.toString());
        }
        if (this.type == null) {
            throw new TProtocolException("Required field 'type' was not present! Struct: " + this.toString());
        }
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    protected Type getInternalType() {
        if (this.type == Type.TAG) {
            return Type.STRING;
        }
        return this.getType();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        NULL = new TObject(ByteBuffer.allocate(1), Type.NULL);
        DATA_FIELD_DESC = new TField("data", 11, 1);
        schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        STRUCT_DESC = new TStruct("TObject");
        TYPE_FIELD_DESC = new TField("type", 8, 2);
        WHITESPACE = " ".getBytes(StandardCharsets.UTF_8)[0];
        schemes.put(StandardScheme.class, new TObjectStandardSchemeFactory());
        schemes.put(TupleScheme.class, new TObjectTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.DATA, new FieldMetaData("data", 1, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.TYPE, new FieldMetaData("type", 1, (FieldValueMetaData)new EnumMetaData(16, Type.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TObject.class, metaDataMap);
    }

    private static class TObjectTupleSchemeFactory
    implements SchemeFactory {
        private TObjectTupleSchemeFactory() {
        }

        public TObjectTupleScheme getScheme() {
            return new TObjectTupleScheme();
        }
    }

    private static class TObjectTupleScheme
    extends TupleScheme<TObject> {
        private TObjectTupleScheme() {
        }

        public void read(TProtocol prot, TObject struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.data = iprot.readBinary();
            struct.setDataIsSet(true);
            struct.type = Type.findByValue(iprot.readI32());
            struct.setTypeIsSet(true);
        }

        public void write(TProtocol prot, TObject struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeBinary(struct.data);
            oprot.writeI32(struct.type.getValue());
        }
    }

    private static class TObjectStandardSchemeFactory
    implements SchemeFactory {
        private TObjectStandardSchemeFactory() {
        }

        public TObjectStandardScheme getScheme() {
            return new TObjectStandardScheme();
        }
    }

    private static class TObjectStandardScheme
    extends StandardScheme<TObject> {
        private TObjectStandardScheme() {
        }

        public void read(TProtocol iprot, TObject struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.data = iprot.readBinary();
                            struct.setDataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 8) {
                            struct.type = Type.findByValue(iprot.readI32());
                            struct.setTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TObject struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.data != null) {
                oprot.writeFieldBegin(DATA_FIELD_DESC);
                oprot.writeBinary(struct.data);
                oprot.writeFieldEnd();
            }
            if (struct.type != null) {
                oprot.writeFieldBegin(TYPE_FIELD_DESC);
                oprot.writeI32(struct.type.getValue());
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        DATA(1, "data"),
        TYPE(2, "type");

        private static final Map<String, _Fields> byName;
        private final String _fieldName;
        private final short _thriftId;

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return DATA;
                }
                case 2: {
                    return TYPE;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

