/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import com.cinchapi.common.base.CheckedExceptions;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class ByteBuffers {
    private static final String CHARSET = StandardCharsets.UTF_8.name();
    private static final ConcurrentLinkedQueue<CharsetDecoder> DECODERS = new ConcurrentLinkedQueue();
    private static final int NUM_DECODERS = 10;

    public static ByteBuffer asReadOnlyBuffer(ByteBuffer source) {
        int position = source.position();
        source.rewind();
        ByteBuffer duplicate = source.asReadOnlyBuffer();
        duplicate.order(source.order());
        source.position(position);
        duplicate.rewind();
        return duplicate;
    }

    public static ByteBuffer clone(ByteBuffer buffer) {
        ByteBuffer clone = ByteBuffer.allocate(buffer.capacity());
        int position = buffer.position();
        int limit = buffer.limit();
        buffer.rewind();
        clone.put(buffer);
        buffer.position(position);
        clone.position(position);
        buffer.limit(limit);
        clone.limit(limit);
        return clone;
    }

    public static void copyAndRewindSource(ByteBuffer source, ByteBuffer destination) {
        int position = source.position();
        destination.put(source);
        source.position(position);
    }

    public static ByteBuffer decodeFromHex(String hex) {
        return ByteBuffer.wrap(BaseEncoding.base16().decode((CharSequence)hex));
    }

    public static String encodeAsHex(ByteBuffer bytes) {
        bytes.rewind();
        return BaseEncoding.base16().encode(ByteBuffers.toByteArray(bytes));
    }

    public static String encodeAsHexString(ByteBuffer buffer) {
        StringBuilder sb = new StringBuilder();
        buffer.mark();
        while (buffer.hasRemaining()) {
            sb.append(String.format("%02x", buffer.get()));
        }
        buffer.reset();
        return sb.toString();
    }

    public static ByteBuffer expand(ByteBuffer destination, ByteBuffer source) {
        destination = ByteBuffers.ensureRemainingCapacity(destination, source.remaining());
        int newLimit = destination.position() + source.remaining();
        if (destination.limit() < newLimit) {
            destination.limit(newLimit);
        }
        destination.put(source);
        return destination;
    }

    public static ByteBuffer expandInt(ByteBuffer destination, int value) {
        destination = ByteBuffers.ensureRemainingCapacity(destination, 4);
        int newLimit = destination.position() + 4;
        if (destination.limit() < newLimit) {
            destination.limit(newLimit);
        }
        destination.putInt(value);
        return destination;
    }

    public static ByteBuffer fromString(String string) {
        try {
            return ByteBuffer.wrap(string.getBytes(CHARSET));
        }
        catch (Exception e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    public static ByteBuffer get(ByteBuffer buffer, int length) {
        Preconditions.checkArgument((buffer.remaining() >= length ? 1 : 0) != 0, (Object)"The number of bytes remaining in the buffer cannot be less than length");
        byte[] backingArray = new byte[length];
        buffer.get(backingArray);
        return ByteBuffer.wrap(backingArray);
    }

    public static boolean getBoolean(ByteBuffer buffer) {
        return buffer.get() > 0;
    }

    public static <T extends Enum<?>> T getEnum(ByteBuffer buffer, Class<T> clazz) {
        return (T)((Enum[])clazz.getEnumConstants())[buffer.getInt()];
    }

    public static ByteBuffer getRemaining(ByteBuffer buffer) {
        return ByteBuffers.get(buffer, buffer.remaining());
    }

    public static String getString(ByteBuffer buffer) {
        return ByteBuffers.getString(buffer, StandardCharsets.UTF_8);
    }

    public static String getString(ByteBuffer buffer, Charset charset) {
        CharsetDecoder decoder = null;
        try {
            if (charset == StandardCharsets.UTF_8) {
                while (decoder == null) {
                    decoder = DECODERS.poll();
                }
            } else {
                decoder = charset.newDecoder();
            }
            decoder.onMalformedInput(CodingErrorAction.IGNORE);
            String string = decoder.decode(buffer).toString();
            return string;
        }
        catch (CharacterCodingException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
        finally {
            if (decoder != null && charset == StandardCharsets.UTF_8) {
                DECODERS.offer(decoder);
            }
        }
    }

    public static ByteBuffer nullByteBuffer() {
        ByteBuffer nullByte = ByteBuffer.allocate(1);
        nullByte.put((byte)0);
        nullByte.rewind();
        return nullByte;
    }

    public static void putString(String source, ByteBuffer destination) {
        try {
            byte[] bytes = source.getBytes(CHARSET);
            destination.put(bytes);
        }
        catch (Exception e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    public static ByteBuffer rewind(ByteBuffer buffer) {
        buffer.rewind();
        return buffer;
    }

    public static ByteBuffer slice(ByteBuffer buffer, int length) {
        return ByteBuffers.slice(buffer, buffer.position(), length);
    }

    public static ByteBuffer slice(ByteBuffer buffer, int position, int length) {
        int oldPosition = buffer.position();
        int oldLimit = buffer.limit();
        buffer.position(position);
        buffer.limit(position + length);
        ByteBuffer slice = buffer.slice();
        buffer.limit(oldLimit);
        buffer.position(oldPosition);
        return slice;
    }

    public static byte[] toByteArray(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            return buffer.array();
        }
        buffer.mark();
        byte[] array = new byte[buffer.remaining()];
        buffer.get(array);
        buffer.reset();
        return array;
    }

    public static CharBuffer toCharBuffer(ByteBuffer buffer) {
        return ByteBuffers.toCharBuffer(buffer, StandardCharsets.UTF_8);
    }

    public static CharBuffer toCharBuffer(ByteBuffer buffer, Charset charset) {
        buffer.mark();
        CharBuffer chars = charset.decode(buffer);
        buffer.reset();
        return chars;
    }

    private static ByteBuffer ensureRemainingCapacity(ByteBuffer buffer, int capacity) {
        if (buffer.capacity() - buffer.position() < capacity) {
            ByteBuffer copy = ByteBuffer.allocate((buffer.capacity() + capacity) * 3 / 2 + 1);
            buffer.limit(buffer.position());
            buffer.rewind();
            copy.put(buffer);
            buffer = copy;
        }
        return buffer;
    }

    static {
        try {
            for (int i = 0; i < 10; ++i) {
                DECODERS.add(StandardCharsets.UTF_8.newDecoder());
            }
        }
        catch (Exception e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }
}

