/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import com.cinchapi.common.base.CheckedExceptions;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ConcurrentLoadingQueue<E>
extends ConcurrentLinkedQueue<E> {
    private static final long serialVersionUID = 1L;
    private final Callable<E> supplier;

    public static <E> ConcurrentLoadingQueue<E> create(Callable<E> supplier) {
        return new ConcurrentLoadingQueue<E>(supplier);
    }

    public static <E> ConcurrentLoadingQueue<E> create(Collection<E> collection, Callable<E> supplier) {
        ConcurrentLoadingQueue<E> queue = ConcurrentLoadingQueue.create(supplier);
        for (E element : collection) {
            queue.offer(element);
        }
        return queue;
    }

    private ConcurrentLoadingQueue(Callable<E> supplier) {
        this.supplier = supplier;
    }

    @Override
    public E peek() {
        Object element = super.peek();
        if (element == null) {
            this.loadElement();
            return super.peek();
        }
        return element;
    }

    @Override
    public E poll() {
        Object element = super.poll();
        if (element == null) {
            this.loadElement();
            return super.poll();
        }
        return element;
    }

    private void loadElement() {
        try {
            E element = this.supplier.call();
            this.offer(element);
        }
        catch (Exception e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }
}

