/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import com.cinchapi.common.base.CheckedExceptions;
import java.util.concurrent.ConcurrentMap;

public final class ConcurrentMaps {
    protected static int SPIN_THRESHOLD_IN_MILLIS = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> V putAndSignal(ConcurrentMap<K, V> map, K key, V value) {
        String hashCode;
        V ret = map.put(key, value);
        String string = hashCode = String.valueOf(key.hashCode()).intern();
        synchronized (string) {
            hashCode.notifyAll();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> V waitAndRemove(ConcurrentMap<K, V> map, K key) {
        long start = System.currentTimeMillis();
        V value = null;
        while (true) {
            String hashCode;
            Object v = map.remove(key);
            value = v;
            if (v != null) break;
            if (System.currentTimeMillis() - start < (long)SPIN_THRESHOLD_IN_MILLIS) continue;
            String string = hashCode = String.valueOf(key.hashCode()).intern();
            synchronized (string) {
                Object v2 = map.remove(key);
                value = v2;
                if (v2 == null) {
                    try {
                        hashCode.wait();
                    }
                    catch (InterruptedException e) {
                        throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
                    }
                } else {
                    break;
                }
            }
        }
        return value;
    }
}

