/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import com.cinchapi.concourse.Timestamp;
import com.cinchapi.concourse.thrift.TObject;
import com.cinchapi.concourse.util.Convert;
import com.google.common.base.Function;
import com.google.common.base.Functions;

public final class Conversions {
    private static final Function<Object, TObject> JAVA_TO_THRIFT_FUNCTION = new Function<Object, TObject>(){

        public TObject apply(Object input) {
            return Convert.javaToThrift(input);
        }
    };
    private static final Function<TObject, Object> THRIFT_TO_JAVA_FUNCTION = new Function<TObject, Object>(){

        public Object apply(TObject input) {
            return Convert.thriftToJava(input);
        }
    };
    private static final Function<Object, Object> POSSIBLE_THRIFT_TO_JAVA_FUNCTION = new Function<Object, Object>(){

        public Object apply(Object input) {
            return Convert.possibleThriftToJava(input);
        }
    };
    private static final Function<Long, Timestamp> TIMESTAMP_TO_MICROS = new Function<Long, Timestamp>(){

        public Timestamp apply(Long input) {
            return Timestamp.fromMicros(input);
        }
    };

    public static Function<Object, TObject> javaToThrift() {
        return JAVA_TO_THRIFT_FUNCTION;
    }

    public static <T> Function<T, T> none() {
        return Functions.identity();
    }

    public static Function<Object, Object> possibleThriftToJava() {
        return POSSIBLE_THRIFT_TO_JAVA_FUNCTION;
    }

    public static Function<TObject, Object> thriftToJava() {
        return THRIFT_TO_JAVA_FUNCTION;
    }

    public static <T> Function<TObject, T> thriftToJavaCasted() {
        return new Function<TObject, T>(){

            public T apply(TObject input) {
                return Conversions.thriftToJava().apply((Object)input);
            }
        };
    }

    public static Function<Long, Timestamp> timestampToMicros() {
        return TIMESTAMP_TO_MICROS;
    }

    private Conversions() {
    }
}

