/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import com.cinchapi.ccl.util.NaturalLanguage;
import com.cinchapi.common.base.CheckedExceptions;
import com.cinchapi.concourse.Link;
import com.cinchapi.concourse.Tag;
import com.cinchapi.concourse.Timestamp;
import com.cinchapi.concourse.annotate.PackagePrivate;
import com.cinchapi.concourse.annotate.UtilityClass;
import com.cinchapi.concourse.thrift.Operator;
import com.cinchapi.concourse.thrift.TObject;
import com.cinchapi.concourse.thrift.Type;
import com.cinchapi.concourse.util.ByteBuffers;
import com.cinchapi.concourse.util.Conversions;
import com.cinchapi.concourse.util.DataServices;
import com.cinchapi.concourse.util.Strings;
import com.cinchapi.concourse.util.Transformers;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.primitives.Longs;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@UtilityClass
public final class Convert {
    @PackagePrivate
    static Map<String, Operator> OPERATOR_STRINGS = Maps.newHashMap();
    @PackagePrivate
    static final String RAW_RESOLVABLE_LINK_SYMBOL_APPEND = "@";
    @PackagePrivate
    static final String RAW_RESOLVABLE_LINK_SYMBOL_PREPEND = "@";
    private static Set<Class<?>> CLASSES_WITH_ENCODED_STRING_REPR;
    private static final Pattern STRING_RESOLVABLE_LINK_REGEX;

    public static List<Multimap<String, Object>> anyJsonToJava(String json) {
        ArrayList result;
        block18: {
            result = Lists.newArrayList();
            try (JsonReader reader = new JsonReader((Reader)new StringReader(json));){
                reader.setLenient(true);
                if (reader.peek() == JsonToken.BEGIN_ARRAY) {
                    try {
                        reader.beginArray();
                        while (reader.peek() != JsonToken.END_ARRAY) {
                            result.add(Convert.jsonToJava(reader));
                        }
                        reader.endArray();
                        break block18;
                    }
                    catch (IllegalStateException e) {
                        throw new JsonParseException(e.getMessage());
                    }
                }
                result.add(Convert.jsonToJava(reader));
            }
            catch (IOException e) {
                throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
            }
        }
        return result;
    }

    public static List<TObject> javaListToThrift(List<Object> objects) {
        ArrayList thrift = Lists.newArrayListWithCapacity((int)objects.size());
        Convert.javaCollectionToThrift(objects, thrift);
        return thrift;
    }

    public static <K> Map<K, TObject> javaMapToThrift(Map<K, Object> objects) {
        LinkedHashMap thrift = Maps.newLinkedHashMap();
        for (Map.Entry<K, Object> entry : objects.entrySet()) {
            K key = entry.getKey();
            TObject value = Convert.javaToThrift(entry.getValue());
            thrift.put(key, value);
        }
        return thrift;
    }

    public static Set<TObject> javaSetToThrift(Set<Object> objects) {
        LinkedHashSet thrift = Sets.newLinkedHashSetWithExpectedSize((int)objects.size());
        Convert.javaCollectionToThrift(objects, thrift);
        return thrift;
    }

    public static TObject javaToThrift(Object object) {
        ByteBuffer bytes;
        if (object == null) {
            return TObject.NULL;
        }
        Type type = null;
        if (object instanceof Boolean) {
            bytes = ByteBuffer.allocate(1);
            bytes.put((Boolean)object != false ? (byte)1 : 0);
            type = Type.BOOLEAN;
        } else if (object instanceof Double) {
            bytes = ByteBuffer.allocate(8);
            bytes.putDouble((Double)object);
            type = Type.DOUBLE;
        } else if (object instanceof Float) {
            bytes = ByteBuffer.allocate(4);
            bytes.putFloat(((Float)object).floatValue());
            type = Type.FLOAT;
        } else if (object instanceof Link) {
            bytes = ByteBuffer.allocate(8);
            bytes.putLong(((Link)object).longValue());
            type = Type.LINK;
        } else if (object instanceof Long) {
            bytes = ByteBuffer.allocate(8);
            bytes.putLong((Long)object);
            type = Type.LONG;
        } else if (object instanceof Integer) {
            bytes = ByteBuffer.allocate(4);
            bytes.putInt((Integer)object);
            type = Type.INTEGER;
        } else if (object instanceof BigDecimal) {
            bytes = ByteBuffer.allocate(8);
            bytes.putDouble(((BigDecimal)object).doubleValue());
            type = Type.DOUBLE;
        } else if (object instanceof Tag) {
            bytes = ByteBuffer.wrap(object.toString().getBytes(StandardCharsets.UTF_8));
            type = Type.TAG;
        } else if (object instanceof Timestamp) {
            try {
                bytes = ByteBuffer.allocate(8);
                bytes.putLong(((Timestamp)object).getMicros());
                type = Type.TIMESTAMP;
            }
            catch (IllegalStateException e) {
                throw new UnsupportedOperationException("Cannot convert string based Timestamp to a TObject");
            }
        } else {
            bytes = ByteBuffer.wrap(object.toString().getBytes(StandardCharsets.UTF_8));
            type = Type.STRING;
        }
        bytes.rewind();
        return new TObject(bytes, type).setJavaFormat(object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Multimap<String, Object> jsonToJava(String json) {
        try (JsonReader reader = new JsonReader((Reader)new StringReader(json));){
            reader.setLenient(true);
            Multimap<String, Object> multimap = Convert.jsonToJava(reader);
            return multimap;
        }
        catch (IOException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    public static String mapsToJson(Collection<Multimap<String, Object>> list) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Multimap<String, Object> map : list) {
            Object map0;
            if (map instanceof Multimap) {
                map0 = map;
                sb.append(Convert.mapToJson(map0));
                sb.append(",");
                continue;
            }
            if (map instanceof Map) {
                map0 = (Map)map;
                sb.append(Convert.mapToJson(map0));
                sb.append(",");
                continue;
            }
            map.getClass();
        }
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    public static String mapToJson(Map<String, ?> map) {
        return DataServices.gson().toJson(map);
    }

    public static String mapToJson(Multimap<String, Object> map) {
        return Convert.mapToJson(map.asMap());
    }

    public static String operatorToString(Operator operator) {
        String string = "";
        switch (operator) {
            case EQUALS: {
                string = "=";
                break;
            }
            case NOT_EQUALS: {
                string = "!=";
                break;
            }
            case GREATER_THAN: {
                string = ">";
                break;
            }
            case GREATER_THAN_OR_EQUALS: {
                string = ">=";
                break;
            }
            case LESS_THAN: {
                string = "<";
                break;
            }
            case LESS_THAN_OR_EQUALS: {
                string = "<=";
                break;
            }
            case BETWEEN: {
                string = "><";
                break;
            }
            default: {
                string = operator.name();
            }
        }
        return string;
    }

    public static <T> T possibleThriftToJava(Object tobject) {
        if (tobject instanceof TObject) {
            return (T)Convert.thriftToJava((TObject)tobject);
        }
        if (tobject instanceof List) {
            return (T)Lists.transform((List)((List)tobject), Conversions.possibleThriftToJava());
        }
        if (tobject instanceof Set) {
            return (T)Transformers.transformSetLazily((Set)tobject, Conversions.possibleThriftToJava());
        }
        if (tobject instanceof Map) {
            return (T)Transformers.transformMapEntries((Map)tobject, Conversions.possibleThriftToJava(), Conversions.possibleThriftToJava());
        }
        return (T)tobject;
    }

    public static Object stringToJava(String value) {
        Long record;
        if (value.isEmpty()) {
            return value;
        }
        char first = value.charAt(0);
        char last = value.charAt(value.length() - 1);
        if (Strings.isWithinQuotes(value)) {
            return value.substring(1, value.length() - 1);
        }
        if (first == '@' && (record = Longs.tryParse((String)value.substring(1, value.length()))) != null) {
            return Link.to(record);
        }
        if (first == '@' && last == '@' && STRING_RESOLVABLE_LINK_REGEX.matcher(value).matches()) {
            String ccl = value.substring(1, value.length() - 1);
            return ResolvableLink.create(ccl);
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        if (first == '`' && last == '`') {
            return Tag.create(value.substring(1, value.length() - 1));
        }
        if (first == '|' && last == '|') {
            Timestamp timestamp;
            String[] toks = (value = value.substring(1, value.length() - 1)).split("\\|");
            if (toks.length == 1) {
                timestamp = Timestamp.fromMicros(NaturalLanguage.parseMicros((String)value));
            } else {
                DateTimeFormatter formatter = DateTimeFormat.forPattern((String)toks[1]);
                timestamp = Timestamp.parse(toks[0], formatter);
            }
            return timestamp;
        }
        return MoreObjects.firstNonNull((Object)Strings.tryParseNumber(value), (Object)value);
    }

    public static Operator stringToOperator(String symbol) {
        Operator operator = OPERATOR_STRINGS.get(symbol);
        if (operator == null) {
            throw new IllegalStateException("Cannot parse " + symbol + " into an operator");
        }
        return operator;
    }

    public static String stringToResolvableLinkInstruction(String ccl) {
        return Strings.joinSimple("@", ccl, "@");
    }

    @Deprecated
    public static String stringToResolvableLinkSpecification(String key, String rawValue) {
        return Convert.stringToResolvableLinkInstruction(Strings.joinWithSpace(key, "=", rawValue));
    }

    public static Set<Object> thriftSetToJava(Set<TObject> tobjects) {
        LinkedHashSet java = Sets.newLinkedHashSetWithExpectedSize((int)tobjects.size());
        Convert.thriftCollectionToJava(tobjects, java);
        return java;
    }

    public static Object thriftToJava(TObject object) {
        Preconditions.checkState((object.getType() != null ? 1 : 0) != 0, (Object)"Cannot read value because it has been created with a newer version of Concourse Server. Please upgrade this client.");
        Object java = object.getJavaFormat();
        if (java == null) {
            ByteBuffer buffer = object.bufferForData();
            switch (object.getType()) {
                case BOOLEAN: {
                    java = ByteBuffers.getBoolean(buffer);
                    break;
                }
                case DOUBLE: {
                    java = buffer.getDouble();
                    break;
                }
                case FLOAT: {
                    java = Float.valueOf(buffer.getFloat());
                    break;
                }
                case INTEGER: {
                    java = buffer.getInt();
                    break;
                }
                case LINK: {
                    java = Link.to(buffer.getLong());
                    break;
                }
                case LONG: {
                    java = buffer.getLong();
                    break;
                }
                case TAG: {
                    java = ByteBuffers.getString(buffer);
                    break;
                }
                case TIMESTAMP: {
                    java = Timestamp.fromMicros(buffer.getLong());
                    break;
                }
                case NULL: {
                    java = null;
                    break;
                }
                default: {
                    java = ByteBuffers.getString(buffer);
                }
            }
            buffer.rewind();
        }
        return java;
    }

    private static void javaCollectionToThrift(Collection<Object> input, Collection<TObject> output) {
        for (Object elt : input) {
            output.add(Convert.javaToThrift(elt));
        }
    }

    private static Multimap<String, Object> jsonToJava(JsonReader reader) {
        HashMultimap data = HashMultimap.create();
        try {
            JsonToken peek0;
            reader.beginObject();
            while ((peek0 = reader.peek()) != JsonToken.END_OBJECT) {
                Object value;
                String key = reader.nextName();
                peek0 = reader.peek();
                if (peek0 == JsonToken.BEGIN_ARRAY) {
                    reader.beginArray();
                    JsonToken peek = reader.peek();
                    do {
                        Object value2;
                        if (peek == JsonToken.BOOLEAN) {
                            value2 = reader.nextBoolean();
                        } else if (peek == JsonToken.NUMBER) {
                            value2 = Convert.stringToJava(reader.nextString());
                        } else if (peek == JsonToken.STRING) {
                            String orig = reader.nextString();
                            value2 = Convert.stringToJava(orig);
                            if (orig.isEmpty()) {
                                value2 = orig;
                            } else if (orig.charAt(orig.length() - 1) != 'D' && !CLASSES_WITH_ENCODED_STRING_REPR.contains(value2.getClass())) {
                                value2 = value2.toString();
                            }
                        } else {
                            if (peek == JsonToken.NULL) {
                                reader.skipValue();
                                continue;
                            }
                            throw new JsonParseException("Cannot parse nested object or array within an array");
                        }
                        data.put((Object)key, value2);
                    } while ((peek = reader.peek()) != JsonToken.END_ARRAY);
                    reader.endArray();
                    continue;
                }
                if (peek0 == JsonToken.BOOLEAN) {
                    value = reader.nextBoolean();
                } else if (peek0 == JsonToken.NUMBER) {
                    value = Convert.stringToJava(reader.nextString());
                } else if (peek0 == JsonToken.STRING) {
                    String orig = reader.nextString();
                    value = Convert.stringToJava(orig);
                    if (orig.isEmpty()) {
                        value = orig;
                    } else if (orig.charAt(orig.length() - 1) != 'D' && !CLASSES_WITH_ENCODED_STRING_REPR.contains(value.getClass())) {
                        value = value.toString();
                    }
                } else {
                    if (peek0 == JsonToken.NULL) {
                        reader.skipValue();
                        continue;
                    }
                    throw new JsonParseException("Cannot parse nested object to value");
                }
                data.put((Object)key, value);
            }
            reader.endObject();
            return data;
        }
        catch (IOException | IllegalStateException e) {
            throw new JsonParseException(e.getMessage());
        }
    }

    private static void thriftCollectionToJava(Collection<TObject> input, Collection<Object> output) {
        for (TObject elt : input) {
            output.add(Convert.thriftToJava(elt));
        }
    }

    private Convert() {
    }

    static {
        OPERATOR_STRINGS.put("==", Operator.EQUALS);
        OPERATOR_STRINGS.put("=", Operator.EQUALS);
        OPERATOR_STRINGS.put("eq", Operator.EQUALS);
        OPERATOR_STRINGS.put("!=", Operator.NOT_EQUALS);
        OPERATOR_STRINGS.put("ne", Operator.NOT_EQUALS);
        OPERATOR_STRINGS.put(">", Operator.GREATER_THAN);
        OPERATOR_STRINGS.put("gt", Operator.GREATER_THAN);
        OPERATOR_STRINGS.put(">=", Operator.GREATER_THAN_OR_EQUALS);
        OPERATOR_STRINGS.put("gte", Operator.GREATER_THAN_OR_EQUALS);
        OPERATOR_STRINGS.put("<", Operator.LESS_THAN);
        OPERATOR_STRINGS.put("lt", Operator.LESS_THAN);
        OPERATOR_STRINGS.put("<=", Operator.LESS_THAN_OR_EQUALS);
        OPERATOR_STRINGS.put("lte", Operator.LESS_THAN_OR_EQUALS);
        OPERATOR_STRINGS.put("><", Operator.BETWEEN);
        OPERATOR_STRINGS.put("bw", Operator.BETWEEN);
        OPERATOR_STRINGS.put("->", Operator.LINKS_TO);
        OPERATOR_STRINGS.put("lnks2", Operator.LINKS_TO);
        OPERATOR_STRINGS.put("lnk2", Operator.LINKS_TO);
        OPERATOR_STRINGS.put("regex", Operator.REGEX);
        OPERATOR_STRINGS.put("nregex", Operator.NOT_REGEX);
        OPERATOR_STRINGS.put("like", Operator.LIKE);
        OPERATOR_STRINGS.put("nlike", Operator.NOT_LIKE);
        for (Operator operator : Operator.values()) {
            OPERATOR_STRINGS.put(operator.name(), operator);
            OPERATOR_STRINGS.put(operator.symbol(), operator);
        }
        OPERATOR_STRINGS = ImmutableMap.copyOf(OPERATOR_STRINGS);
        CLASSES_WITH_ENCODED_STRING_REPR = Sets.newHashSet((Object[])new Class[]{Link.class, Tag.class, ResolvableLink.class, Timestamp.class});
        STRING_RESOLVABLE_LINK_REGEX = Pattern.compile("^@(?=.*[ ]).+@$");
    }

    @Immutable
    public static final class ResolvableLink {
        @Deprecated
        protected final String key;
        @Deprecated
        protected final Object value;
        private final String ccl;

        @PackagePrivate
        static ResolvableLink create(String ccl) {
            return new ResolvableLink(ccl);
        }

        @Deprecated
        @PackagePrivate
        static ResolvableLink newResolvableLink(String key, Object value) {
            return new ResolvableLink(key, value);
        }

        private ResolvableLink(String ccl) {
            this.ccl = ccl;
            this.key = null;
            this.value = null;
        }

        @Deprecated
        private ResolvableLink(String key, Object value) {
            this.ccl = key + " = " + value;
            this.key = key;
            this.value = value;
        }

        public String getCcl() {
            return this.ccl;
        }

        @Deprecated
        public String getKey() {
            return this.key;
        }

        @Deprecated
        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return Strings.format("{} for {}", this.getClass().getSimpleName(), this.ccl);
        }
    }
}

