/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import com.cinchapi.common.base.CheckedExceptions;
import com.cinchapi.concourse.util.Random;
import com.cinchapi.concourse.util.ReadOnlyIterator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.FileWriteMode;
import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.imca_cat.pollingwatchservice.PollingWatchService;

public class FileOps {
    private static boolean IS_WATCH_SERVICE_SETUP = false;
    private static List<WatchService> FILE_CHANGE_WATCHERS = Lists.newArrayListWithCapacity((int)2);
    @VisibleForTesting
    protected static Set<Watchable> REGISTERED_WATCHER_PATHS = Sets.newConcurrentHashSet();
    private static String USER_HOME = System.getProperty("user.home");
    private static WatchEvent.Kind<?>[] WATCH_EVENT_KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY};
    private static SensitivityWatchEventModifier[] WATCH_EVENT_MODIFIERS = new SensitivityWatchEventModifier[]{SensitivityWatchEventModifier.HIGH};
    private static String WORKING_DIRECTORY = System.getProperty("user.dir");
    private static Path BASE_PATH = FileSystems.getDefault().getPath(WORKING_DIRECTORY, new String[0]);

    public static void append(String content, String file) {
        try {
            com.google.common.io.Files.asCharSink((File)new File(file), (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}).write((CharSequence)content);
        }
        catch (IOException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    public static void awaitChange(String file) {
        try {
            FileOps.awaitChangeInterruptibly(file);
        }
        catch (InterruptedException e) {
            throw CheckedExceptions.throwAsRuntimeException((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void awaitChangeInterruptibly(String file) throws InterruptedException {
        String mutex;
        if (!IS_WATCH_SERVICE_SETUP) {
            try {
                PollingWatchService pollingWatchService = new PollingWatchService(Runtime.getRuntime().availableProcessors(), 1000L, TimeUnit.MILLISECONDS);
                pollingWatchService.start();
                FILE_CHANGE_WATCHERS.add(pollingWatchService);
                FILE_CHANGE_WATCHERS.add(FileSystems.getDefault().newWatchService());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            FILE_CHANGE_WATCHERS.forEach(watcher -> FileOps.setupWatchService(watcher));
            IS_WATCH_SERVICE_SETUP = true;
        }
        long methodStartTime = System.currentTimeMillis();
        methodStartTime = TimeUnit.SECONDS.convert(methodStartTime, TimeUnit.MILLISECONDS);
        Path path = Paths.get(FileOps.expandPath(file), new String[0]);
        Preconditions.checkArgument((boolean)Files.isRegularFile(path, new LinkOption[0]));
        String string = mutex = path.toString().intern();
        synchronized (string) {
            Path parent = path.getParent().toAbsolutePath();
            if (!REGISTERED_WATCHER_PATHS.contains(parent)) {
                for (int i = 0; i < FILE_CHANGE_WATCHERS.size(); ++i) {
                    WatchService watcher2 = FILE_CHANGE_WATCHERS.get(i);
                    try {
                        if (watcher2 instanceof PollingWatchService) {
                            ((PollingWatchService)watcher2).register(parent, WATCH_EVENT_KINDS, WATCH_EVENT_MODIFIERS);
                            break;
                        }
                        parent.register(watcher2, WATCH_EVENT_KINDS, WATCH_EVENT_MODIFIERS);
                        break;
                    }
                    catch (IOException e) {
                        if (i < FILE_CHANGE_WATCHERS.size()) continue;
                        throw CheckedExceptions.throwAsRuntimeException((Exception)e);
                    }
                }
                REGISTERED_WATCHER_PATHS.add(parent);
            }
            try {
                long modified = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
                modified = TimeUnit.SECONDS.convert(modified, TimeUnit.MILLISECONDS);
                if (modified >= methodStartTime) {
                    return;
                }
                mutex.wait();
            }
            catch (IOException e) {
                throw CheckedExceptions.throwAsRuntimeException((Exception)e);
            }
        }
    }

    public static String expandPath(String path) {
        return FileOps.expandPath(path, null);
    }

    public static String expandPath(String path, String cwd) {
        path = path.replaceAll("~", USER_HOME);
        Path base = Strings.isNullOrEmpty((String)cwd) ? BASE_PATH : FileSystems.getDefault().getPath(cwd, new String[0]);
        return base.resolve(path).normalize().toString();
    }

    public static String getUserHome() {
        return USER_HOME;
    }

    public static String getWorkingDirectory() {
        return WORKING_DIRECTORY;
    }

    public static boolean isDirectory(String path) {
        return Files.isDirectory(Paths.get(path, new String[0]), new LinkOption[0]);
    }

    public static void mkdirs(String path) {
        try {
            Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    public static DirectoryStream<Path> newDirectoryStream(Path dir) {
        try {
            return Files.newDirectoryStream(dir);
        }
        catch (IOException e) {
            throw CheckedExceptions.throwAsRuntimeException((Exception)e);
        }
    }

    public static String read(String file) {
        try {
            return com.google.common.io.Files.asCharSource((File)new File(file), (Charset)StandardCharsets.UTF_8).read();
        }
        catch (IOException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    public static List<String> readLines(String file) {
        return FileOps.readLines(file, null);
    }

    public static List<String> readLines(final String file, String cwd) {
        final String rwd = (String)MoreObjects.firstNonNull((Object)cwd, (Object)WORKING_DIRECTORY);
        return new AbstractList<String>(){

            @Override
            public String get(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<String> iterator() {
                return new ReadOnlyIterator<String>(){
                    String line = null;
                    BufferedReader reader;
                    {
                        try {
                            this.reader = new BufferedReader(new FileReader(FileOps.expandPath(file, rwd)));
                            this.line = this.reader.readLine();
                        }
                        catch (IOException e) {
                            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.line != null;
                    }

                    @Override
                    public String next() {
                        String result = this.line;
                        try {
                            this.line = this.reader.readLine();
                            if (this.line == null) {
                                this.reader.close();
                            }
                            return result;
                        }
                        catch (IOException e) {
                            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
                        }
                    }
                };
            }

            @Override
            public int size() {
                int size = 0;
                Iterator<String> it = this.iterator();
                while (it.hasNext()) {
                    ++size;
                    it.next();
                }
                return size;
            }
        };
    }

    public static String tempDir(String prefix) {
        try {
            return Files.createTempDirectory(prefix, new FileAttribute[0]).toString();
        }
        catch (IOException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    public static String tempFile() {
        return FileOps.tempFile("cnch", null);
    }

    public static String tempFile(String prefix) {
        return FileOps.tempFile(prefix, null);
    }

    public static String tempFile(String prefix, String suffix) {
        return FileOps.tempFile(null, prefix, suffix);
    }

    public static String tempFile(String dir, String prefix, String suffix) {
        prefix = prefix == null ? "cnch" : prefix;
        prefix = prefix.trim();
        while (prefix.length() < 3) {
            prefix = prefix + Random.getString().charAt(0);
        }
        try {
            if (dir != null) {
                FileOps.mkdirs(dir);
            }
            return dir == null ? Files.createTempFile(prefix, suffix, new FileAttribute[0]).toAbsolutePath().toString() : Files.createTempFile(Paths.get(dir, new String[0]), prefix, suffix, new FileAttribute[0]).toAbsolutePath().toString();
        }
        catch (IOException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    public static String touch(String file) {
        try {
            com.google.common.io.Files.touch((File)new File(file));
            return file;
        }
        catch (IOException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    public static URL toURL(String path) {
        try {
            return new File(path).toURI().toURL();
        }
        catch (IOException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    public static void write(String content, String file) {
        try {
            com.google.common.io.Files.asCharSink((File)new File(file), (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)content);
        }
        catch (IOException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    private static void setupWatchService(WatchService service) {
        Thread t = new Thread(() -> {
            try {
                try {
                    while (true) {
                        WatchKey key = service.take();
                        for (WatchEvent<?> event : key.pollEvents()) {
                            String sync;
                            Path parent = (Path)key.watchable();
                            WatchEvent.Kind<?> kind = event.kind();
                            if (kind != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                            Path abspath = parent.resolve((Path)event.context()).toAbsolutePath();
                            String string = sync = abspath.toString().intern();
                            synchronized (string) {
                                sync.notifyAll();
                            }
                        }
                        key.reset();
                    }
                }
                catch (InterruptedException e) {
                    throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
                }
            }
            catch (Throwable throwable) {
                try {
                    service.close();
                }
                catch (IOException e) {
                    throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
                }
                throw throwable;
            }
        });
        t.setName("watch-service-daemon-" + service.getClass());
        t.setDaemon(true);
        t.start();
    }

    protected FileOps() {
    }
}

