/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import com.cinchapi.common.base.CheckedExceptions;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Random;

public final class Networking {
    public static final String IP_REGEX = "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)";
    private static final int MAX_PORT = 65535;
    private static final int MIN_PORT = 49152;
    private static final int PORT_RANGE = 16383;
    private static final Random RAND = new Random();

    public static int getCompanionPort(int port) {
        return port < 16383 ? 49152 + port : port % 16383 + 49152;
    }

    public static int getCompanionPort(int port, int rounds) {
        for (int i = 0; i < rounds; ++i) {
            port = Networking.getCompanionPort(port);
        }
        return port;
    }

    public static String getIpAddress(String host) {
        try {
            if (host.equalsIgnoreCase("localhost") || host.equalsIgnoreCase("127.0.0.1") || host.equalsIgnoreCase("0.0.0.0")) {
                return InetAddress.getLocalHost().getHostAddress();
            }
            if (host.startsWith("http") || host.startsWith("https")) {
                host = new URL(host).getHost();
            }
            return InetAddress.getByName(host).getHostAddress();
        }
        catch (MalformedURLException | UnknownHostException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    public static int getOpenPort() {
        int port = RAND.nextInt(49152) + 16383;
        return Networking.isOpenPort(port) ? port : Networking.getOpenPort();
    }

    public static boolean isLocalHost(String host) {
        try {
            InetAddress inet = InetAddress.getByName(host);
            if (inet.isAnyLocalAddress() || inet.isLoopbackAddress()) {
                return true;
            }
            return NetworkInterface.getByInetAddress(inet) != null;
        }
        catch (SocketException | UnknownHostException e) {
            return false;
        }
    }

    private static boolean isOpenPort(int port) {
        try {
            new ServerSocket(port).close();
            return true;
        }
        catch (SocketException e) {
            return false;
        }
        catch (IOException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    private Networking() {
    }
}

