/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import com.cinchapi.concourse.Link;
import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedLongs;
import java.math.BigDecimal;
import java.math.RoundingMode;

public abstract class Numbers {
    private static final int DEFAULT_DIVISION_NUMBER_DECIMAL_PLACES = 10;
    private static final int DIVISION_NUMBER_DECIMAL_PLACES = Integer.parseInt(System.getProperty("com.cinchapi.concourse.calculation.divisionNumberDecimalPlaces", Integer.toString(10)));

    public static Number add(Number a, Number b) {
        if (Numbers.isFloatingPoint(a) || Numbers.isFloatingPoint(b)) {
            BigDecimal a0 = Numbers.toBigDecimal(a);
            BigDecimal b0 = Numbers.toBigDecimal(b);
            return a0.add(b0);
        }
        try {
            return Math.addExact(a.intValue(), b.intValue());
        }
        catch (ArithmeticException e) {
            return Math.addExact(a.longValue(), b.longValue());
        }
    }

    public static int compare(Number a, Number b) {
        Class<?> aClass = a.getClass();
        Class<?> bClass = b.getClass();
        if (!(aClass != Integer.TYPE && aClass != Integer.class || bClass != Integer.TYPE && bClass != Integer.class)) {
            return Integer.compare(a.intValue(), b.intValue());
        }
        if (!(aClass != Long.TYPE && aClass != Long.class || bClass != Long.TYPE && bClass != Long.class)) {
            return Long.compare(a.longValue(), b.longValue());
        }
        if (!(aClass != Float.TYPE && aClass != Float.class || bClass != Float.TYPE && bClass != Float.class)) {
            return Float.compare(a.floatValue(), b.floatValue());
        }
        if (!(aClass != Double.TYPE && aClass != Double.class || bClass != Double.TYPE && bClass != Double.class)) {
            return Double.compare(a.doubleValue(), b.doubleValue());
        }
        if (!(aClass != Short.TYPE && aClass != Short.class || bClass != Short.TYPE && bClass != Short.class)) {
            return Short.compare(a.shortValue(), b.shortValue());
        }
        if (!(aClass != Byte.TYPE && aClass != Byte.class || bClass != Byte.TYPE && bClass != Byte.class)) {
            return Byte.compare(a.byteValue(), b.byteValue());
        }
        String fa = aClass == Link.class ? UnsignedLongs.toString((long)a.longValue()) : a.toString();
        String sb = bClass == Link.class ? UnsignedLongs.toString((long)b.longValue()) : b.toString();
        BigDecimal first = new BigDecimal(fa);
        BigDecimal second = new BigDecimal(sb);
        return first.compareTo(second);
    }

    public static Number divide(Number a, Number b) {
        BigDecimal a0 = Numbers.toBigDecimal(a);
        BigDecimal b0 = Numbers.toBigDecimal(b);
        return a0.divide(b0, DIVISION_NUMBER_DECIMAL_PLACES, RoundingMode.HALF_UP);
    }

    public static Number incrementalAverage(Number running, Number number, int count) {
        Number sum = Numbers.multiply(running, count - 1);
        sum = Numbers.add(sum, number);
        return Numbers.divide(sum, count);
    }

    public static boolean areEqual(Number a, Number b) {
        return Numbers.compare(a, b) == 0;
    }

    @Deprecated
    public static boolean isEqualTo(Number a, Number b) {
        return Numbers.areEqual(a, b);
    }

    public static boolean areEqualCastSafe(Object a, Object b) {
        if (a instanceof Number && b instanceof Number) {
            return Numbers.isEqualTo((Number)a, (Number)b);
        }
        return false;
    }

    @Deprecated
    public static boolean isEqualToCastSafe(Object a, Object b) {
        if (a instanceof Number && b instanceof Number) {
            return Numbers.areEqual((Number)a, (Number)b);
        }
        return false;
    }

    public static boolean isEven(Number number) {
        return number.intValue() % 2 == 0;
    }

    public static boolean isFloatingPoint(Number number) {
        return number instanceof Float || number instanceof Double || number instanceof BigDecimal;
    }

    public static boolean isGreaterThan(Number a, Number b) {
        return Numbers.compare(a, b) > 0;
    }

    public static boolean isGreaterThanOrEqualTo(Number a, Number b) {
        return Numbers.compare(a, b) >= 0;
    }

    public static boolean isLessThan(Number a, Number b) {
        return Numbers.compare(a, b) < 0;
    }

    public static boolean isLessThanOrEqualTo(Number a, Number b) {
        return Numbers.compare(a, b) <= 0;
    }

    public static boolean isOdd(Number number) {
        return !Numbers.isEven(number);
    }

    public static Number max(Number ... numbers) {
        Number max = numbers[0];
        for (Number number : numbers) {
            max = Numbers.isGreaterThan(max, number) ? (Number)max : (Number)number;
        }
        return max;
    }

    public static Number min(Number ... numbers) {
        Number min = numbers[0];
        for (Number number : numbers) {
            min = Numbers.isLessThan(min, number) ? (Number)min : (Number)number;
        }
        return min;
    }

    public static Number multiply(Number a, Number b) {
        if (Numbers.isFloatingPoint(a) || Numbers.isFloatingPoint(b)) {
            BigDecimal a0 = Numbers.toBigDecimal(a);
            BigDecimal b0 = Numbers.toBigDecimal(b);
            return a0.multiply(b0);
        }
        try {
            return Math.multiplyExact(a.intValue(), b.intValue());
        }
        catch (ArithmeticException e) {
            return Math.multiplyExact(a.longValue(), b.longValue());
        }
    }

    public static double percent(Number numerator, Number denominator) {
        return numerator.doubleValue() * 100.0 / denominator.doubleValue();
    }

    public static double round(Number value, int places) {
        Preconditions.checkArgument((places > 0 ? 1 : 0) != 0);
        return new BigDecimal(value.doubleValue()).setScale(places, RoundingMode.HALF_UP).doubleValue();
    }

    public static Number scale(Number number, Number rawMin, Number rawMax, Number scaledMin, Number scaledMax) {
        Preconditions.checkArgument((Numbers.isGreaterThanOrEqualTo(number, rawMin) && Numbers.isLessThanOrEqualTo(number, rawMax) ? 1 : 0) != 0);
        double x = number.doubleValue();
        double min = rawMin.doubleValue();
        double max = rawMax.doubleValue();
        double a = scaledMin.doubleValue();
        double b = scaledMax.doubleValue();
        return (b - a) * (x - min) / (max - min) + a;
    }

    public static BigDecimal toBigDecimal(Number number) {
        if (number == null) {
            return null;
        }
        if (number instanceof Integer) {
            return new BigDecimal(number.intValue());
        }
        if (number instanceof Double) {
            return new BigDecimal(number.doubleValue());
        }
        if (number instanceof Float) {
            return new BigDecimal(number.floatValue());
        }
        if (number instanceof Long) {
            return new BigDecimal(number.longValue());
        }
        if (number instanceof Byte) {
            return new BigDecimal(number.byteValue());
        }
        if (number instanceof Short) {
            return new BigDecimal(number.shortValue());
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        return null;
    }
}

