/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import com.cinchapi.ccl.Parser;
import com.cinchapi.ccl.type.Operator;
import com.cinchapi.concourse.lang.Language;
import com.cinchapi.concourse.thrift.TCriteria;
import com.cinchapi.concourse.util.Convert;
import com.google.common.collect.Multimap;
import java.util.function.Function;

public final class Parsers {
    public static final Function<String, Object> PARSER_TRANSFORM_VALUE_FUNCTION = value -> Convert.stringToJava(value);
    public static final Function<String, Operator> PARSER_TRANSFORM_OPERATOR_FUNCTION = operator -> Convert.stringToOperator(operator);

    public static Parser create(String ccl) {
        return Parser.create((String)ccl, PARSER_TRANSFORM_VALUE_FUNCTION, PARSER_TRANSFORM_OPERATOR_FUNCTION);
    }

    public static Parser create(String ccl, Multimap<String, Object> data) {
        return Parser.create((String)ccl, data, PARSER_TRANSFORM_VALUE_FUNCTION, PARSER_TRANSFORM_OPERATOR_FUNCTION);
    }

    public static Parser create(TCriteria criteria) {
        return Parsers.create(Language.translateFromThriftCriteria(criteria).getCclString());
    }

    public static Parser create(TCriteria criteria, Multimap<String, Object> data) {
        return Parsers.create(Language.translateFromThriftCriteria(criteria).getCclString(), data);
    }

    private Parsers() {
    }
}

