/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class PrettyLinkedHashMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private String keyName = "Key";
    private String valueName = "Value";
    private int keyLength = this.keyName.length();
    private int valueLength = this.valueName.length();

    public static <K, V> PrettyLinkedHashMap<K, V> newPrettyLinkedHashMap() {
        return new PrettyLinkedHashMap<K, V>(null, null);
    }

    public static <K, V> PrettyLinkedHashMap<K, V> newPrettyLinkedHashMap(String keyName, String valueName) {
        return new PrettyLinkedHashMap<K, V>(keyName, valueName);
    }

    private PrettyLinkedHashMap(@Nullable String keyName, @Nullable String valueName) {
        if (!Strings.isNullOrEmpty((String)keyName)) {
            this.setKeyName(keyName);
        }
        if (!Strings.isNullOrEmpty((String)valueName)) {
            this.setValueName(valueName);
        }
    }

    @Override
    public V put(K key, V value) {
        this.keyLength = Math.max(key.toString().length(), this.keyLength);
        this.valueLength = Math.max(value != null ? value.toString().length() : 4, this.valueLength);
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        map.forEach((key, value) -> this.put(key, value));
    }

    public PrettyLinkedHashMap<K, V> setKeyName(String name) {
        this.keyName = name;
        this.keyLength = Math.max(name.length(), this.keyLength);
        return this;
    }

    public PrettyLinkedHashMap<K, V> setValueName(String name) {
        this.valueName = name;
        this.valueLength = Math.max(name.length(), this.valueLength);
        return this;
    }

    @Override
    public String toString() {
        String format = "| %-" + this.keyLength + "s | %-" + this.valueLength + "s |%n";
        String hr = Strings.padEnd((String)"+", (int)(this.keyLength + this.valueLength + 6), (char)'-');
        hr = hr + "+" + System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append(System.getProperty("line.separator"));
        sb.append(hr);
        sb.append(String.format(format, this.keyName, this.valueName));
        sb.append(hr);
        for (Map.Entry entry : this.entrySet()) {
            sb.append(String.format(format, entry.getKey(), entry.getValue()));
        }
        sb.append(hr);
        return sb.toString();
    }
}

