/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class PrettyLinkedTableMap<R, C, V>
extends LinkedHashMap<R, Map<C, V>> {
    private String rowName = "Row";
    private int rowLength = this.rowName.length();
    private final Map<C, Integer> columns = Maps.newLinkedHashMap();

    public static <R, C, V> PrettyLinkedTableMap<R, C, V> newPrettyLinkedTableMap() {
        return new PrettyLinkedTableMap<R, C, V>(null);
    }

    public static <R, C, V> PrettyLinkedTableMap<R, C, V> newPrettyLinkedTableMap(String rowName) {
        return new PrettyLinkedTableMap<R, C, V>(rowName);
    }

    private PrettyLinkedTableMap(@Nullable String rowName) {
        if (!Strings.isNullOrEmpty((String)rowName)) {
            this.setRowName(rowName);
        }
    }

    public V put(R row, C column, V value) {
        Map rowdata = (Map)super.get(row);
        if (rowdata == null) {
            rowdata = Maps.newLinkedHashMap();
            super.put(row, rowdata);
        }
        this.rowLength = Math.max(row.toString().length(), this.rowLength);
        int current = this.columns.containsKey(column) ? this.columns.get(column) : 0;
        this.columns.put(column, Math.max(current, Math.max(column.toString().length(), value.toString().length())));
        return rowdata.put(column, value);
    }

    @Override
    public Map<C, V> put(R key, Map<C, V> value) {
        for (Map.Entry<C, V> entry : value.entrySet()) {
            this.put(key, entry.getKey(), entry.getValue());
        }
        return null;
    }

    public PrettyLinkedTableMap<R, C, V> setRowName(String name) {
        this.rowName = name;
        this.rowLength = Math.max(name.length(), this.rowLength);
        return this;
    }

    @Override
    public String toString() {
        int total = 0;
        Object[] header = new Object[this.columns.size() + 1];
        header[0] = this.rowName;
        String format = "| %-" + this.rowLength + "s | ";
        int i = 1;
        for (Map.Entry<C, Integer> entry : this.columns.entrySet()) {
            format = format + "%-" + entry.getValue() + "s | ";
            total += entry.getValue() + 3;
            header[i] = entry.getKey();
            ++i;
        }
        format = format + "%n";
        String hr = Strings.padEnd((String)"+", (int)(this.rowLength + 3 + total), (char)'-');
        hr = hr + "+" + System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append(System.getProperty("line.separator"));
        sb.append(hr);
        sb.append(String.format(format, header));
        sb.append(hr);
        for (Object row : this.keySet()) {
            Object[] rowdata = new Object[this.columns.size() + 1];
            rowdata[0] = row;
            i = 1;
            for (C column : this.columns.keySet()) {
                rowdata[i] = ((Map)this.get(row)).get(column);
                ++i;
            }
            sb.append(String.format(format, rowdata));
        }
        sb.append(hr);
        return sb.toString();
    }
}

