/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import com.cinchapi.common.base.CheckedExceptions;
import com.cinchapi.concourse.annotate.UtilityClass;
import com.cinchapi.concourse.util.Platform;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@UtilityClass
public final class Processes {
    public static ProcessBuilder getBuilder(String ... commands) {
        ProcessBuilder pb = new ProcessBuilder(commands);
        if (!Platform.isWindows()) {
            Map<String, String> env = pb.environment();
            env.put("BASH_ENV", System.getProperty("user.home") + "/.bash_profile");
        }
        return pb;
    }

    public static ProcessBuilder getBuilderWithPipeSupport(String ... commands) {
        if (!Platform.isWindows()) {
            ArrayList listCommands = Lists.newArrayListWithCapacity((int)(commands.length + 2));
            listCommands.add("/bin/sh");
            listCommands.add("-c");
            for (String command : commands) {
                listCommands.add(command);
            }
            return Processes.getBuilder(listCommands.toArray(commands));
        }
        return Processes.getBuilder(commands);
    }

    public static List<String> getStdErr(Process process) {
        return Processes.readStream(process.getErrorStream());
    }

    public static List<String> getStdOut(Process process) {
        return Processes.readStream(process.getInputStream());
    }

    public static boolean isPidRunning(String pid) {
        Process process;
        block6: {
            process = null;
            try {
                if (Platform.isLinux() || Platform.isMacOsX() || Platform.isSolaris()) {
                    ProcessBuilder pb = Processes.getBuilderWithPipeSupport("ps aux | grep <pid>");
                    process = pb.start();
                    break block6;
                }
                if (Platform.isWindows()) {
                    process = Runtime.getRuntime().exec("TASKLIST /fi \"PID eq " + pid + "\" /fo csv /nh");
                    break block6;
                }
                throw new UnsupportedOperationException("Cannot check pid on the underlying platform");
            }
            catch (IOException e) {
                throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
            }
        }
        if (process != null) {
            Processes.waitForSuccessfulCompletion(process);
            List<String> lines = Processes.readStream(process.getInputStream());
            for (String line : lines) {
                if (!line.contains(pid)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static void waitForSuccessfulCompletion(Process process) {
        try {
            int exitVal = process.waitFor();
            if (exitVal != 0) {
                throw new RuntimeException(Processes.getStdErr(process).toString());
            }
        }
        catch (Exception e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    public static String getCurrentPid() {
        return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }

    private static List<String> readStream(InputStream stream) {
        try {
            String line;
            BufferedReader out = new BufferedReader(new InputStreamReader(stream));
            ArrayList output = Lists.newArrayList();
            while ((line = out.readLine()) != null) {
                output.add(line);
            }
            return output;
        }
        catch (Exception e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    private Processes() {
    }
}

