/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import com.cinchapi.common.base.CheckedExceptions;
import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public final class Queues {
    public static <T> Queue<T> newSingleThreadedQueue() {
        return new ArrayDeque();
    }

    public static <E> int blockingDrain(BlockingQueue<E> queue, Collection<? super E> buffer) throws InterruptedException {
        Preconditions.checkNotNull(buffer);
        int added = queue.drainTo(buffer);
        if (added == 0) {
            buffer.add(queue.take());
            added += queue.drainTo(buffer);
            ++added;
        }
        return added;
    }

    public static <E> int blockingDrain(BlockingQueue<E> queue, Collection<? super E> buffer, long timeout, TimeUnit unit) {
        Preconditions.checkNotNull(buffer);
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        int added = queue.drainTo(buffer);
        try {
            E element;
            if (added == 0 && (element = queue.poll(deadline - System.nanoTime(), TimeUnit.NANOSECONDS)) != null) {
                buffer.add(element);
                added += queue.drainTo(buffer);
                ++added;
            }
        }
        catch (InterruptedException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
        return added;
    }

    private Queues() {
    }
}

