/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import com.cinchapi.concourse.util.SplitOption;
import com.cinchapi.concourse.util.StringSplitter;

public class QuoteAwareStringSplitter
extends StringSplitter {
    private boolean inSingleQuote = false;
    private boolean inDoubleQuote = false;
    private char previousChar = (char)32;
    private int singleQuotePos = -1;

    public QuoteAwareStringSplitter(String string) {
        super(string);
    }

    public QuoteAwareStringSplitter(String string, SplitOption ... options) {
        super(string, options);
    }

    public QuoteAwareStringSplitter(String string, char delimiter) {
        super(string, delimiter);
    }

    public QuoteAwareStringSplitter(String string, char delimiter, SplitOption ... options) {
        super(string, delimiter, options);
    }

    @Override
    protected boolean isReadyToSplit() {
        assert (!(this.inSingleQuote && this.inDoubleQuote));
        return !this.inSingleQuote && !this.inDoubleQuote;
    }

    @Override
    protected void updateIsReadyToSplit(char c) {
        if (this.previousChar != '\\' && c == '\'' && !this.inDoubleQuote && (this.inSingleQuote || !this.inSingleQuote && !Character.isLetter(this.previousChar))) {
            this.inSingleQuote ^= true;
            this.singleQuotePos = this.pos - 1;
        } else if (this.previousChar != '\\' && c == '\"' && !this.inSingleQuote) {
            this.inDoubleQuote ^= true;
        }
        this.previousChar = c;
    }

    @Override
    public boolean confirmSetNext() {
        if (this.inSingleQuote) {
            this.inSingleQuote = false;
            this.pos = this.singleQuotePos + 1;
            this.singleQuotePos = -1;
            return false;
        }
        return super.confirmSetNext();
    }
}

