/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import com.cinchapi.concourse.util.RandomStringGenerator;
import com.google.common.base.Strings;

public abstract class Random {
    private static final java.util.Random rand = new java.util.Random();
    private static final RandomStringGenerator strand = new RandomStringGenerator();

    public static boolean getBoolean() {
        int seed = rand.nextInt();
        return seed % 2 == 0;
    }

    public static double getDouble() {
        return rand.nextDouble();
    }

    public static float getFloat() {
        return rand.nextFloat();
    }

    public static int getInt() {
        return rand.nextInt();
    }

    public static long getLong() {
        return rand.nextLong();
    }

    public static Number getNegativeNumber() {
        int seed = Random.getInt();
        if (seed % 5 == 0) {
            return Float.valueOf(-1.0f * Math.abs(Random.getFloat()));
        }
        if (seed % 4 == 0) {
            return -1.0 * Math.abs(Random.getDouble());
        }
        if (seed % 3 == 0) {
            return -1L * Math.abs(Random.getLong());
        }
        return -1 * Math.abs(Random.getInt());
    }

    public static Number getNumber() {
        int seed = Random.getInt();
        if (seed % 5 == 0) {
            return Float.valueOf(Random.getFloat());
        }
        if (seed % 4 == 0) {
            return Random.getDouble();
        }
        if (seed % 3 == 0) {
            return Random.getLong();
        }
        return Random.getInt();
    }

    public static Object getObject() {
        int seed = rand.nextInt();
        if (seed % 5 == 0) {
            return Random.getBoolean();
        }
        if (seed % 2 == 0) {
            return Random.getNumber();
        }
        return Random.getString();
    }

    public static Number getPositiveNumber() {
        int seed = Random.getInt();
        if (seed % 5 == 0) {
            return Float.valueOf(Math.abs(Random.getFloat()));
        }
        if (seed % 4 == 0) {
            return Math.abs(Random.getDouble());
        }
        if (seed % 3 == 0) {
            return Math.abs(Random.getLong());
        }
        return Math.abs(Random.getInt());
    }

    public static void microSleep() {
        try {
            Thread.sleep(51L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void sleep() {
        try {
            Thread.sleep(rand.nextInt(1000) + 1);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void tinySleep() {
        try {
            Thread.sleep(rand.nextInt(200) + 100);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static int getScaleCount() {
        return rand.nextInt(90) + 10;
    }

    public static String getString() {
        String string = null;
        while (Strings.nullToEmpty(string).trim().isEmpty()) {
            string = strand.nextStringAllowDigits();
        }
        return string;
    }

    public static String getSimpleString() {
        String string = null;
        while (Strings.nullToEmpty(string).trim().isEmpty()) {
            string = Random.getStringNoDigits().replaceAll(" ", "");
        }
        return string;
    }

    public static String getStringNoDigits() {
        return strand.nextString();
    }
}

