/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class RandomStringGenerator {
    Random random;
    private static final int MAX_DISTRIBUTION_OF_SPACE_CHARS = 5;
    private static final int MAX_RANDOM_STRING_LENGTH = 100;
    private static final char spaceChar = ' ';
    private static final Character[] digits;
    private static final Character[] letters;

    public RandomStringGenerator() {
        this(0L);
    }

    public RandomStringGenerator(long seed) {
        this.random = seed == 0L ? new Random() : new Random(seed);
    }

    public String nextString() {
        return this.nextString(this.random.nextInt(100) + 1);
    }

    public String nextString(int length) {
        Character[] spaces = new Character[this.random.nextInt(5)];
        for (int i = 0; i < spaces.length; ++i) {
            spaces[i] = Character.valueOf(' ');
        }
        ArrayList<Character> source = new ArrayList<Character>();
        source.addAll(Arrays.asList(letters));
        source.addAll(Arrays.asList(spaces));
        Collections.shuffle(source);
        return this.build(length, source);
    }

    public String nextStringAllowDigits() {
        return this.nextStringAllowDigits(this.random.nextInt(100) + 1);
    }

    public String nextStringAllowDigits(int length) {
        Character[] spaces = new Character[this.random.nextInt(5)];
        for (int i = 0; i < spaces.length; ++i) {
            spaces[i] = Character.valueOf(' ');
        }
        ArrayList<Character> source = new ArrayList<Character>();
        source.addAll(Arrays.asList(letters));
        source.addAll(Arrays.asList(digits));
        source.addAll(Arrays.asList(spaces));
        Collections.shuffle(source);
        return this.build(length, source);
    }

    private String build(int length, List<Character> source) {
        if (length < 1) {
            throw new IllegalArgumentException("Cannot generate a string with fewer than 1 characters.");
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int index = this.random.nextInt(source.size());
            builder.append(source.get(index));
        }
        return builder.toString().trim();
    }

    static {
        int i;
        digits = new Character[10];
        letters = new Character[26];
        for (i = 0; i < digits.length; ++i) {
            RandomStringGenerator.digits[i] = Character.valueOf((char)(48 + i));
        }
        for (i = 0; i < letters.length; ++i) {
            RandomStringGenerator.letters[i] = Character.valueOf((char)(97 + i));
        }
    }
}

