/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import com.cinchapi.common.base.CheckedExceptions;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Map;

public class Resources {
    private static Map<String, URL> map = Maps.newHashMap();

    public static URL get(String name) {
        try {
            URL url = map.get(name);
            if (url == null) {
                File temp = File.createTempFile("java-resource", ".tmp");
                Path path = Paths.get(temp.getAbsolutePath(), new String[0]);
                Files.copy(Resources.class.getResourceAsStream(name), path, StandardCopyOption.REPLACE_EXISTING);
                url = temp.toURI().toURL();
                map.put(name, url);
                return url;
            }
            return url;
        }
        catch (IOException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    public static String getAbsolutePath(String name) {
        try {
            return new File(Resources.get(name).toURI()).getAbsolutePath();
        }
        catch (URISyntaxException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }
}

