/*
 * Decompiled with CFR 0.152.
 */
package com.cinchapi.concourse.util;

import com.cinchapi.common.base.CheckedExceptions;
import com.cinchapi.concourse.util.ByteBuffers;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public final class Serializables {
    public static ByteBuffer getBytes(Serializable object) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream output = new ObjectOutputStream(new BufferedOutputStream(baos));
            output.writeObject(object);
            output.flush();
            output.close();
            return ByteBuffer.wrap(baos.toByteArray());
        }
        catch (IOException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    public static <T extends Serializable> T read(ByteBuffer bytes, Class<T> classObj) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(ByteBuffers.toByteArray(bytes));
            BufferedInputStream bis = new BufferedInputStream(bais);
            ObjectInputStream input = new ObjectInputStream(bis);
            Serializable object = (Serializable)input.readObject();
            return (T)object;
        }
        catch (IOException | ReflectiveOperationException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    public static <T extends Serializable> T read(ByteBuffer bytes, String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (T)Serializables.read(bytes, clazz);
        }
        catch (ReflectiveOperationException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    public static void write(Serializable object, FileChannel channel) {
        try {
            ByteBuffer bytes = Serializables.getBytes(object);
            FileLock lock = channel.lock(channel.position(), bytes.capacity(), false);
            channel.write(bytes);
            channel.force(true);
            lock.release();
        }
        catch (IOException e) {
            throw CheckedExceptions.wrapAsRuntimeException((Exception)e);
        }
    }

    private Serializables() {
    }
}

